/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils.handler.channel;

import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.impl.ImplChannel;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.entities.impl.ImplUser;
import de.btobastian.javacord.entities.impl.ImplVoiceChannel;
import de.btobastian.javacord.listener.channel.ChannelCreateListener;
import de.btobastian.javacord.listener.voicechannel.VoiceChannelCreateListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.PacketHandler;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ChannelCreateHandler
extends PacketHandler {
    private static final Logger logger = LoggerUtil.getLogger(ChannelCreateHandler.class);

    public ChannelCreateHandler(ImplDiscordAPI api) {
        super(api, true, "CHANNEL_CREATE");
    }

    @Override
    public void handle(JSONObject packet) {
        int type = packet.getInt("type");
        switch (type) {
            case 0: {
                this.handleServerTextChannel(packet, this.api.getServerById(packet.getString("guild_id")));
                break;
            }
            case 1: {
                User recipient = this.api.getOrCreateUser(packet.getJSONArray("recipients").getJSONObject(0));
                ((ImplUser)recipient).setUserChannelId(packet.getString("id"));
                break;
            }
            case 2: {
                this.handleServerVoiceChannel(packet, this.api.getServerById(packet.getString("guild_id")));
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
        }
    }

    private void handleServerTextChannel(JSONObject packet, Server server) {
        if (server.getChannelById(packet.getString("id")) != null) {
            return;
        }
        final ImplChannel channel = new ImplChannel(packet, (ImplServer)server, this.api);
        this.listenerExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<ChannelCreateListener> listeners;
                List<ChannelCreateListener> list = listeners = ChannelCreateHandler.this.api.getListeners(ChannelCreateListener.class);
                synchronized (list) {
                    for (ChannelCreateListener listener : listeners) {
                        try {
                            listener.onChannelCreate(ChannelCreateHandler.this.api, channel);
                        }
                        catch (Throwable t) {
                            logger.warn("Uncaught exception in ChannelCreateListener!", t);
                        }
                    }
                }
            }
        });
    }

    private void handleServerVoiceChannel(JSONObject packet, Server server) {
        if (server.getVoiceChannelById(packet.getString("id")) != null) {
            return;
        }
        final ImplVoiceChannel channel = new ImplVoiceChannel(packet, (ImplServer)server, this.api);
        this.listenerExecutorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<VoiceChannelCreateListener> listeners;
                List<VoiceChannelCreateListener> list = listeners = ChannelCreateHandler.this.api.getListeners(VoiceChannelCreateListener.class);
                synchronized (list) {
                    for (VoiceChannelCreateListener listener : listeners) {
                        try {
                            listener.onVoiceChannelCreate(ChannelCreateHandler.this.api, channel);
                        }
                        catch (Throwable t) {
                            logger.warn("Uncaught exception in VoiceChannelCreateListener!", t);
                        }
                    }
                }
            }
        });
    }
}

