/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.utils;

import de.btobastian.javacord.utils.LoggerUtil;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MarkerIgnoringBase;
import org.slf4j.helpers.MessageFormatter;

public class JavacordLogger
extends MarkerIgnoringBase {
    private final String name;

    public JavacordLogger(String name) {
        this.name = name;
        Logger.getLogger(name).setLevel(Level.ALL);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final boolean isTraceEnabled() {
        return false;
    }

    @Override
    public final void trace(String msg) {
    }

    @Override
    public final void trace(String format, Object arg) {
    }

    @Override
    public final void trace(String format, Object arg1, Object arg2) {
    }

    @Override
    public final void trace(String format, Object ... arguments) {
    }

    @Override
    public final void trace(String msg, Throwable t) {
    }

    @Override
    public final boolean isDebugEnabled() {
        return LoggerUtil.isDebug();
    }

    @Override
    public final void debug(String msg) {
        if (this.isDebugEnabled()) {
            LogRecord record = new LogRecord(Level.FINE, msg);
            record.setLoggerName(this.name);
            Logger.getLogger(this.name).log(record);
        }
    }

    @Override
    public final void debug(String format, Object arg1) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1);
            LogRecord record = new LogRecord(Level.FINE, ft.getMessage());
            record.setThrown(ft.getThrowable());
            record.setLoggerName(this.name);
            Logger.getLogger(this.name).log(record);
        }
    }

    @Override
    public final void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
            LogRecord record = new LogRecord(Level.FINE, ft.getMessage());
            record.setThrown(ft.getThrowable());
            record.setLoggerName(this.name);
            Logger.getLogger(this.name).log(record);
        }
    }

    @Override
    public final void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
            LogRecord record = new LogRecord(Level.FINE, ft.getMessage());
            record.setThrown(ft.getThrowable());
            record.setLoggerName(this.name);
            Logger.getLogger(this.name).log(record);
        }
    }

    @Override
    public final void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            LogRecord record = new LogRecord(Level.FINE, msg);
            record.setThrown(t);
            record.setLoggerName(this.name);
            Logger.getLogger(this.name).log(record);
        }
    }

    @Override
    public final boolean isInfoEnabled() {
        return true;
    }

    @Override
    public final void info(String msg) {
        LogRecord record = new LogRecord(Level.INFO, msg);
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final void info(String format, Object arg1) {
        FormattingTuple ft = MessageFormatter.format(format, arg1);
        LogRecord record = new LogRecord(Level.INFO, ft.getMessage());
        record.setThrown(ft.getThrowable());
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final void info(String format, Object arg1, Object arg2) {
        FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
        LogRecord record = new LogRecord(Level.INFO, ft.getMessage());
        record.setThrown(ft.getThrowable());
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final void info(String format, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
        LogRecord record = new LogRecord(Level.INFO, ft.getMessage());
        record.setThrown(ft.getThrowable());
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final void info(String msg, Throwable t) {
        LogRecord record = new LogRecord(Level.INFO, msg);
        record.setThrown(t);
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final boolean isWarnEnabled() {
        return true;
    }

    @Override
    public final void warn(String msg) {
        LogRecord record = new LogRecord(Level.WARNING, msg);
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final void warn(String format, Object arg1) {
        FormattingTuple ft = MessageFormatter.format(format, arg1);
        LogRecord record = new LogRecord(Level.WARNING, ft.getMessage());
        record.setThrown(ft.getThrowable());
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final void warn(String format, Object arg1, Object arg2) {
        FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
        LogRecord record = new LogRecord(Level.WARNING, ft.getMessage());
        record.setThrown(ft.getThrowable());
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final void warn(String format, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
        LogRecord record = new LogRecord(Level.WARNING, ft.getMessage());
        record.setThrown(ft.getThrowable());
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final void warn(String msg, Throwable t) {
        LogRecord record = new LogRecord(Level.WARNING, msg);
        record.setThrown(t);
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final boolean isErrorEnabled() {
        return true;
    }

    @Override
    public final void error(String msg) {
        LogRecord record = new LogRecord(Level.SEVERE, msg);
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final void error(String format, Object arg1) {
        FormattingTuple ft = MessageFormatter.format(format, arg1);
        LogRecord record = new LogRecord(Level.SEVERE, ft.getMessage());
        record.setThrown(ft.getThrowable());
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final void error(String format, Object arg1, Object arg2) {
        FormattingTuple ft = MessageFormatter.format(format, arg1, arg2);
        LogRecord record = new LogRecord(Level.SEVERE, ft.getMessage());
        record.setThrown(ft.getThrowable());
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final void error(String format, Object ... arguments) {
        FormattingTuple ft = MessageFormatter.arrayFormat(format, arguments);
        LogRecord record = new LogRecord(Level.SEVERE, ft.getMessage());
        record.setThrown(ft.getThrowable());
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }

    @Override
    public final void error(String msg, Throwable t) {
        LogRecord record = new LogRecord(Level.SEVERE, msg);
        record.setThrown(t);
        record.setLoggerName(this.name);
        Logger.getLogger(this.name).log(record);
    }
}

