/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.permissions.impl;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.VoiceChannel;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.entities.permissions.Permissions;
import de.btobastian.javacord.entities.permissions.Role;
import de.btobastian.javacord.entities.permissions.impl.ImplPermissions;
import de.btobastian.javacord.listener.role.RoleChangeColorListener;
import de.btobastian.javacord.listener.role.RoleChangeHoistListener;
import de.btobastian.javacord.listener.role.RoleChangeManagedListener;
import de.btobastian.javacord.listener.role.RoleChangeMentionableListener;
import de.btobastian.javacord.listener.role.RoleChangeNameListener;
import de.btobastian.javacord.listener.role.RoleChangePermissionsListener;
import de.btobastian.javacord.listener.role.RoleDeleteListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.ratelimits.RateLimitType;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplRole
implements Role {
    private static final Logger logger = LoggerUtil.getLogger(ImplRole.class);
    private static final Permissions emptyPermissions = new ImplPermissions(0, 0);
    private final ConcurrentHashMap<String, Permissions> overwrittenPermissions = new ConcurrentHashMap();
    private final ImplDiscordAPI api;
    private final String id;
    private String name;
    private final ImplServer server;
    private ImplPermissions permissions;
    private int position;
    private Color color;
    private boolean hoist;
    private boolean mentionable;
    private boolean managed;
    private final List<User> users = new ArrayList<User>();

    public ImplRole(JSONObject data, ImplServer server, ImplDiscordAPI api) {
        this.server = server;
        this.api = api;
        this.id = data.getString("id");
        this.name = data.getString("name");
        this.permissions = new ImplPermissions(data.getInt("permissions"));
        this.position = data.getInt("position");
        this.color = new Color(data.getInt("color"));
        this.hoist = data.getBoolean("hoist");
        this.mentionable = data.getBoolean("mentionable");
        this.managed = data.getBoolean("managed");
        server.addRole(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public Permissions getPermissions() {
        return this.permissions;
    }

    @Override
    public Permissions getOverwrittenPermissions(Channel channel) {
        Permissions overwrittenPermissions = this.overwrittenPermissions.get(channel.getId());
        if (overwrittenPermissions == null) {
            overwrittenPermissions = emptyPermissions;
        }
        return overwrittenPermissions;
    }

    @Override
    public Permissions getOverwrittenPermissions(VoiceChannel channel) {
        Permissions overwrittenPermissions = this.overwrittenPermissions.get(channel.getId());
        if (overwrittenPermissions == null) {
            overwrittenPermissions = emptyPermissions;
        }
        return overwrittenPermissions;
    }

    @Override
    public List<User> getUsers() {
        return new ArrayList<User>(this.users);
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public boolean getHoist() {
        return this.hoist;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public boolean isMentionable() {
        return this.mentionable;
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public String getMentionTag() {
        return "<@&" + this.getId() + ">";
    }

    @Override
    public Future<Void> updatePermissions(Permissions permissions) {
        return this.update(this.name, this.color, this.hoist, permissions, this.mentionable);
    }

    @Override
    public Future<Void> updateName(String name) {
        return this.update(name, this.color, this.hoist, this.permissions, this.mentionable);
    }

    @Override
    public Future<Void> updateColor(Color color) {
        return this.update(this.name, color, this.hoist, this.permissions, this.mentionable);
    }

    @Override
    public Future<Void> updateHoist(boolean hoist) {
        return this.update(this.name, this.color, hoist, this.permissions, this.mentionable);
    }

    @Override
    public Future<Void> updateMentionable(boolean mentionable) {
        return this.update(this.name, this.color, this.hoist, this.permissions, mentionable);
    }

    @Override
    public Future<Void> update(String name, Color color, boolean hoist, Permissions permissions, boolean mentionable) {
        if (name == null) {
            name = this.getName();
        }
        if (color == null) {
            color = this.getColor();
        }
        if (permissions == null) {
            permissions = this.getPermissions();
        }
        return this.update(name, color.getRGB(), hoist, ((ImplPermissions)permissions).getAllowed(), mentionable);
    }

    private Future<Void> update(final String name, final int color, final boolean hoist, final int allow, final boolean mentionable) {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to update role {} (new name: {}, old name: {}, new color: {}, old color: {}, new hoist: {}, old hoist: {}, new allow: {}, old allow: {})", ImplRole.this, name, ImplRole.this.getName(), color & 0xFFFFFF, ImplRole.this.getColor().getRGB() & 0xFFFFFF, hoist, ImplRole.this.getHoist(), allow, ImplRole.this.permissions.getAllowed());
                HttpResponse<JsonNode> response = Unirest.patch("https://discordapp.com/api/v6/guilds/" + ImplRole.this.server.getId() + "/roles/" + ImplRole.this.id).header("authorization", ImplRole.this.api.getToken()).header("Content-Type", "application/json").body(new JSONObject().put("name", name).put("color", color & 0xFFFFFF).put("hoist", hoist).put("permissions", allow).put("mentionable", mentionable).toString()).asJson();
                ImplRole.this.api.checkResponse(response);
                ImplRole.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, null, null);
                logger.info("Updated role {} (new name: {}, old name: {}, new color: {}, old color: {}, new hoist: {}, old hoist: {}, new allow: {}, old allow: {})", ImplRole.this, name, ImplRole.this.getName(), color & 0xFFFFFF, ImplRole.this.getColor().getRGB() & 0xFFFFFF, hoist, ImplRole.this.getHoist(), allow, ImplRole.this.permissions.getAllowed());
                if (ImplRole.this.permissions.getAllowed() != allow) {
                    final ImplPermissions oldPermissions = ImplRole.this.permissions;
                    ImplRole.this.permissions = new ImplPermissions(allow);
                    ImplRole.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<RoleChangePermissionsListener> listeners;
                            List<RoleChangePermissionsListener> list = listeners = ImplRole.this.api.getListeners(RoleChangePermissionsListener.class);
                            synchronized (list) {
                                for (RoleChangePermissionsListener listener : listeners) {
                                    try {
                                        listener.onRoleChangePermissions(ImplRole.this.api, ImplRole.this, oldPermissions);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in RoleChangePermissionsListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                if (ImplRole.this.name.equals(name)) {
                    final String oldName = ImplRole.this.name;
                    ImplRole.this.name = name;
                    ImplRole.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<RoleChangeNameListener> listeners;
                            List<RoleChangeNameListener> list = listeners = ImplRole.this.api.getListeners(RoleChangeNameListener.class);
                            synchronized (list) {
                                for (RoleChangeNameListener listener : listeners) {
                                    try {
                                        listener.onRoleChangeName(ImplRole.this.api, ImplRole.this, oldName);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in RoleChangeNameListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                if (ImplRole.this.color.getRGB() != new Color(color).getRGB()) {
                    final Color oldColor = ImplRole.this.color;
                    ImplRole.this.color = new Color(color);
                    ImplRole.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<RoleChangeColorListener> listeners;
                            List<RoleChangeColorListener> list = listeners = ImplRole.this.api.getListeners(RoleChangeColorListener.class);
                            synchronized (list) {
                                for (RoleChangeColorListener listener : listeners) {
                                    try {
                                        listener.onRoleChangeColor(ImplRole.this.api, ImplRole.this, oldColor);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in RoleChangeColorListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                if (ImplRole.this.hoist != hoist) {
                    ImplRole.this.hoist = hoist;
                    ImplRole.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<RoleChangeHoistListener> listeners;
                            List<RoleChangeHoistListener> list = listeners = ImplRole.this.api.getListeners(RoleChangeHoistListener.class);
                            synchronized (list) {
                                for (RoleChangeHoistListener listener : listeners) {
                                    try {
                                        listener.onRoleChangeHoist(ImplRole.this.api, ImplRole.this, !ImplRole.this.hoist);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in RoleChangeHoistListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                if (ImplRole.this.managed != ImplRole.this.managed) {
                    ImplRole.this.managed = ImplRole.this.managed;
                    ImplRole.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<RoleChangeManagedListener> listeners;
                            List<RoleChangeManagedListener> list = listeners = ImplRole.this.api.getListeners(RoleChangeManagedListener.class);
                            synchronized (list) {
                                for (RoleChangeManagedListener listener : listeners) {
                                    try {
                                        listener.onRoleChangeManaged(ImplRole.this.api, ImplRole.this, !ImplRole.this.managed);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in RoleChangeManagedListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                if (ImplRole.this.mentionable != mentionable) {
                    ImplRole.this.mentionable = mentionable;
                    ImplRole.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<RoleChangeMentionableListener> listeners;
                            List<RoleChangeMentionableListener> list = listeners = ImplRole.this.api.getListeners(RoleChangeMentionableListener.class);
                            synchronized (list) {
                                for (RoleChangeMentionableListener listener : listeners) {
                                    try {
                                        listener.onRoleChangeMentionable(ImplRole.this.api, ImplRole.this, !ImplRole.this.mentionable);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in RoleChangeMentionableListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                return null;
            }
        });
    }

    @Override
    public Future<Void> delete() {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to delete role {}", (Object)ImplRole.this);
                HttpResponse<JsonNode> response = Unirest.delete("https://discordapp.com/api/v6/guilds/" + ImplRole.this.getServer().getId() + "/roles/" + ImplRole.this.getId()).header("authorization", ImplRole.this.api.getToken()).asJson();
                ImplRole.this.api.checkResponse(response);
                ImplRole.this.server.removeRole(ImplRole.this);
                logger.info("Deleted role {}", (Object)ImplRole.this);
                ImplRole.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<RoleDeleteListener> listeners;
                        List<RoleDeleteListener> list = listeners = ImplRole.this.api.getListeners(RoleDeleteListener.class);
                        synchronized (list) {
                            for (RoleDeleteListener listener : listeners) {
                                try {
                                    listener.onRoleDelete(ImplRole.this.api, ImplRole.this);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in RoleDeleteListener!", t);
                                }
                            }
                        }
                    }
                });
                return null;
            }
        });
    }

    @Override
    public Future<Void> removeUser(User user) {
        ArrayList<Role> roles = new ArrayList<Role>(user.getRoles(this.getServer()));
        roles.remove(this);
        return this.getServer().updateRoles(user, roles.toArray(new Role[roles.size()]));
    }

    @Override
    public Future<Void> addUser(User user) {
        ArrayList<Role> roles = new ArrayList<Role>(user.getRoles(this.getServer()));
        roles.add(this);
        return this.getServer().updateRoles(user, roles.toArray(new Role[roles.size()]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUserNoUpdate(User user) {
        List<User> list = this.users;
        synchronized (list) {
            this.users.add(user);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUserNoUpdate(User user) {
        List<User> list = this.users;
        synchronized (list) {
            this.users.remove(user);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPermissions(ImplPermissions permissions) {
        this.permissions = permissions;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setOverwrittenPermissions(Channel channel, Permissions permissions) {
        this.overwrittenPermissions.put(channel.getId(), permissions);
    }

    public void setOverwrittenPermissions(VoiceChannel channel, Permissions permissions) {
        this.overwrittenPermissions.put(channel.getId(), permissions);
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setHoist(boolean hoist) {
        this.hoist = hoist;
    }

    public void setMentionable(boolean mentionable) {
        this.mentionable = mentionable;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public String toString() {
        return this.getName() + " (id: " + this.getId() + ")";
    }
}

