/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.message.impl;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.CustomEmoji;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.message.Message;
import de.btobastian.javacord.entities.message.Reaction;
import de.btobastian.javacord.entities.message.impl.ImplMessage;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.ratelimits.RateLimitType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplReaction
implements Reaction {
    private static final Logger logger = LoggerUtil.getLogger(ImplReaction.class);
    private final ImplDiscordAPI api;
    private final Message message;
    private int count;
    private boolean usedByYou;
    private final CustomEmoji customEmoji;
    private final String unicodeEmoji;

    public ImplReaction(ImplDiscordAPI api, Message message, JSONObject data) {
        this.api = api;
        this.message = message;
        this.count = data.getInt("count");
        this.usedByYou = data.getBoolean("me");
        JSONObject emoji = data.getJSONObject("emoji");
        if (emoji.isNull("id")) {
            this.customEmoji = null;
            this.unicodeEmoji = emoji.getString("name");
        } else {
            this.unicodeEmoji = null;
            this.customEmoji = message.getChannelReceiver().getServer().getCustomEmojiById(emoji.getString("id"));
        }
    }

    public ImplReaction(ImplDiscordAPI api, Message message, boolean usedByYou, int count, String unicodeEmoji, CustomEmoji customEmoji) {
        this.api = api;
        this.message = message;
        this.count = count;
        this.usedByYou = usedByYou;
        this.customEmoji = customEmoji;
        this.unicodeEmoji = unicodeEmoji;
    }

    @Override
    public Message getMessage() {
        return this.message;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public boolean isUsedByYou() {
        return this.usedByYou;
    }

    @Override
    public boolean isCustomEmoji() {
        return this.customEmoji != null;
    }

    @Override
    public boolean isUnicodeEmoji() {
        return this.unicodeEmoji != null;
    }

    @Override
    public CustomEmoji getCustomEmoji() {
        return this.customEmoji;
    }

    @Override
    public String getUnicodeEmoji() {
        return this.unicodeEmoji;
    }

    @Override
    public Future<List<User>> getUsers() {
        return this.getUsers(null);
    }

    @Override
    public Future<List<User>> getUsers(FutureCallback<List<User>> callback) {
        ListenableFuture<List<User>> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<List<User>>(){

            @Override
            public List<User> call() throws Exception {
                logger.debug("Trying to get reactors of reaction {} of message {}", (Object)ImplReaction.this, (Object)ImplReaction.this.message);
                String reactionString = ImplReaction.this.isCustomEmoji() ? ImplReaction.this.getCustomEmoji().getName() + ":" + ImplReaction.this.getCustomEmoji().getId() : ImplReaction.this.getUnicodeEmoji();
                HttpResponse<JsonNode> response = Unirest.get("/channels/" + ((ImplMessage)ImplReaction.this.message).getChannelId() + "/messages/" + ImplReaction.this.message.getId() + "/reactions/" + reactionString).header("authorization", ImplReaction.this.api.getToken()).asJson();
                ImplReaction.this.api.checkResponse(response);
                ImplReaction.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, null, ImplReaction.this.message.getChannelReceiver());
                logger.debug("Got reactors of reaction {} of message {}", (Object)ImplReaction.this, (Object)ImplReaction.this.message);
                JSONArray userArray = response.getBody().getArray();
                ArrayList<User> users = new ArrayList<User>();
                for (int i = 0; i > userArray.length(); ++i) {
                    User user = ImplReaction.this.api.getOrCreateUser(userArray.getJSONObject(i));
                    if (user == null) continue;
                    users.add(user);
                }
                return users;
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<Void> removeUser(final User user) {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to remove reactor {} from reaction {} of message {}", user, ImplReaction.this, ImplReaction.this.message);
                String reactionString = ImplReaction.this.isCustomEmoji() ? ImplReaction.this.getCustomEmoji().getName() + ":" + ImplReaction.this.getCustomEmoji().getId() : ImplReaction.this.getUnicodeEmoji();
                HttpResponse<JsonNode> response = Unirest.delete("https://discordapp.com/api/v6/channels/" + ((ImplMessage)ImplReaction.this.message).getChannelId() + "/messages/" + ImplReaction.this.message.getId() + "/reactions/" + reactionString + "/" + user.getId()).header("authorization", ImplReaction.this.api.getToken()).asJson();
                ImplReaction.this.api.checkResponse(response);
                ImplReaction.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, null, ImplReaction.this.message.getChannelReceiver());
                logger.debug("Removed reactor {} from reaction {} of message {}", user, ImplReaction.this, ImplReaction.this.message);
                return null;
            }
        });
    }

    public void incrementCount(boolean you) {
        ++this.count;
        this.usedByYou = you || this.usedByYou;
    }

    public void decrementCount(boolean you) {
        --this.count;
        this.usedByYou = !you && this.usedByYou;
    }

    public String toString() {
        return this.isUnicodeEmoji() ? this.getUnicodeEmoji() : this.getCustomEmoji().toString();
    }
}

