/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.message.impl;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.message.Message;
import de.btobastian.javacord.entities.message.MessageHistory;
import de.btobastian.javacord.entities.message.impl.ImplMessage;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.ratelimits.RateLimitType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplMessageHistory
implements MessageHistory {
    private static final Logger logger = LoggerUtil.getLogger(ImplMessageHistory.class);
    private final ConcurrentHashMap<String, Message> messages = new ConcurrentHashMap();
    private Message oldestMessage = null;
    private Message newestMessage = null;

    public ImplMessageHistory(ImplDiscordAPI api, String channelId, int limit) throws Exception {
        this(api, channelId, null, false, limit);
    }

    public ImplMessageHistory(ImplDiscordAPI api, String channelId, String messageId, boolean before, int limit) throws Exception {
        int step = 0;
        if (messageId == null) {
            before = true;
        }
        logger.debug("Trying to get message history (channel id: {}, message id: {}, before: {}, limit: {}", channelId, messageId == null ? "none" : messageId, before, limit);
        for (int i = limit / 100; i > 0; --i) {
            int receivedMessages;
            if ((receivedMessages = step++ == 0 ? this.request(api, channelId, messageId, before, 100) : this.request(api, channelId, before ? this.oldestMessage.getId() : this.newestMessage.getId(), before, 100)) != 0) continue;
            return;
        }
        if (step == 0) {
            this.request(api, channelId, messageId, before, limit % 100);
        } else {
            this.request(api, channelId, before ? this.oldestMessage.getId() : this.newestMessage.getId(), before, limit % 100);
        }
        logger.debug("Got message history (channel id: {}, message id: {}, before: {}, limit: {}, amount: {}", channelId, messageId == null ? "none" : messageId, before, limit, this.messages.size());
    }

    private int request(ImplDiscordAPI api, String channelId, String messageId, boolean before, int limit) throws Exception {
        if (limit <= 0) {
            return 0;
        }
        logger.debug("Requesting part of message history (channel id: {}, message id: {}, before: {}, limit: {}", channelId, messageId == null ? "none" : messageId, before, limit);
        String link = messageId == null ? "https://discordapp.com/api/v6/channels/" + channelId + "/messages?&limit=" + limit : "https://discordapp.com/api/v6/channels/" + channelId + "/messages?&" + (before ? "before" : "after") + "=" + messageId + "&limit=" + limit;
        HttpResponse<JsonNode> response = Unirest.get(link).header("authorization", api.getToken()).asJson();
        api.checkResponse(response);
        api.checkRateLimit(response, RateLimitType.UNKNOWN, null, null);
        JSONArray messages = response.getBody().getArray();
        for (int i = 0; i < messages.length(); ++i) {
            JSONObject messageJson = messages.getJSONObject(i);
            String id = messageJson.getString("id");
            Message message = api.getMessageById(id);
            if (message == null) {
                message = new ImplMessage(messageJson, api, null);
            }
            if (this.newestMessage == null || message.compareTo(this.newestMessage) > 0) {
                this.newestMessage = message;
            }
            if (this.oldestMessage == null || message.compareTo(this.oldestMessage) < 0) {
                this.oldestMessage = message;
            }
            this.messages.put(id, message);
        }
        return messages.length();
    }

    @Override
    public Message getMessageById(String id) {
        return this.messages.get(id);
    }

    @Override
    public Iterator<Message> iterator() {
        return this.getMessages().iterator();
    }

    @Override
    public Collection<Message> getMessages() {
        return Collections.unmodifiableCollection(this.messages.values());
    }

    @Override
    public Message getNewestMessage() {
        if (this.newestMessage != null) {
            return this.newestMessage;
        }
        Message newestMessage = null;
        for (Message message : this.messages.values()) {
            if (newestMessage == null) {
                newestMessage = message;
                continue;
            }
            if (message.compareTo(newestMessage) <= 0) continue;
            newestMessage = message;
        }
        return newestMessage;
    }

    @Override
    public Message getOldestMessage() {
        if (this.oldestMessage != null) {
            return this.oldestMessage;
        }
        Message oldestMessage = null;
        for (Message message : this.messages.values()) {
            if (oldestMessage == null) {
                oldestMessage = message;
                continue;
            }
            if (message.compareTo(oldestMessage) >= 0) continue;
            oldestMessage = message;
        }
        return oldestMessage;
    }

    @Override
    public List<Message> getMessagesSorted() {
        ArrayList<Message> messages = new ArrayList<Message>(this.messages.values());
        Collections.sort(messages);
        return messages;
    }

    public void removeMessage(String id) {
        this.messages.remove(id);
        if (this.newestMessage != null && this.newestMessage.getId().equals(id)) {
            this.newestMessage = null;
        }
        if (this.oldestMessage != null && this.oldestMessage.getId().equals(id)) {
            this.oldestMessage = null;
        }
    }
}

