/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.message.impl;

import com.google.common.base.Joiner;
import com.google.common.util.concurrent.FutureCallback;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.CustomEmoji;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.entities.impl.ImplUser;
import de.btobastian.javacord.entities.message.Message;
import de.btobastian.javacord.entities.message.MessageAttachment;
import de.btobastian.javacord.entities.message.MessageReceiver;
import de.btobastian.javacord.entities.message.Reaction;
import de.btobastian.javacord.entities.message.embed.Embed;
import de.btobastian.javacord.entities.message.embed.EmbedBuilder;
import de.btobastian.javacord.entities.message.embed.impl.ImplEmbed;
import de.btobastian.javacord.entities.message.impl.ImplMessageAttachment;
import de.btobastian.javacord.entities.message.impl.ImplReaction;
import de.btobastian.javacord.entities.permissions.Role;
import de.btobastian.javacord.listener.message.MessageDeleteListener;
import de.btobastian.javacord.listener.message.MessageEditListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.ratelimits.RateLimitType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplMessage
implements Message {
    private static final Logger logger = LoggerUtil.getLogger(ImplMessage.class);
    private static final ThreadLocal<SimpleDateFormat> TIMEZONE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> FORMAT_ALTERNATIVE = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> FORMAT_ALTERNATIVE_TWO = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        }
    };
    private final ImplDiscordAPI api;
    private final String id;
    private String content = null;
    private final boolean tts;
    private final User author;
    private final List<User> mentions = new ArrayList<User>();
    private final List<Role> mentionedRoles = new ArrayList<Role>();
    private final MessageReceiver receiver;
    private final String channelId;
    private final List<MessageAttachment> attachments = new ArrayList<MessageAttachment>();
    private final String nonce;
    private boolean mentionsEveryone;
    private boolean pinned;
    private boolean deleted = false;
    private Calendar creationDate = Calendar.getInstance();
    private final Collection<Embed> embeds = new ArrayList<Embed>();
    private final List<Reaction> reactions = new ArrayList<Reaction>();

    public ImplMessage(JSONObject data, ImplDiscordAPI api, MessageReceiver receiver) {
        Object maybeItsAStringAndMaybeItsNotAStringIHaveNoClue;
        this.api = api;
        this.id = data.getString("id");
        if (data.has("content")) {
            this.content = data.getString("content");
        }
        this.tts = data.getBoolean("tts");
        this.mentionsEveryone = data.getBoolean("mention_everyone");
        this.pinned = data.getBoolean("pinned");
        if (data.has("timestamp")) {
            String time = data.getString("timestamp");
            Calendar calendar = Calendar.getInstance();
            try {
                String nanoSecondsRemoved = Joiner.on("+").join(time.split("\\d{3}\\+"));
                calendar.setTime(TIMEZONE_FORMAT.get().parse(nanoSecondsRemoved));
            }
            catch (ParseException timeZoneIgnored) {
                try {
                    calendar.setTime(FORMAT.get().parse(time.substring(0, time.length() - 9)));
                }
                catch (ParseException ignored) {
                    try {
                        calendar.setTime(FORMAT_ALTERNATIVE.get().parse(time.substring(0, time.length() - 9)));
                    }
                    catch (ParseException ignored2) {
                        try {
                            calendar.setTime(FORMAT_ALTERNATIVE_TWO.get().parse(time.substring(0, time.length() - 9)));
                        }
                        catch (ParseException e) {
                            logger.warn("Could not parse timestamp {}. Please contact the developer!", (Object)time, (Object)e);
                        }
                    }
                }
            }
            this.creationDate = calendar;
        }
        this.author = api.getOrCreateUser(data.getJSONObject("author"));
        try {
            JSONArray attachments = data.getJSONArray("attachments");
            for (int i = 0; i < attachments.length(); ++i) {
                JSONObject attachment = attachments.getJSONObject(i);
                String url = attachment.getString("url");
                String proxyUrl = attachment.getString("proxy_url");
                int size = attachment.getInt("size");
                String id = attachment.getString("id");
                String name = attachment.getString("filename");
                this.attachments.add(new ImplMessageAttachment(url, proxyUrl, size, id, name));
            }
        }
        catch (JSONException attachments) {
            // empty catch block
        }
        JSONArray mentions = data.getJSONArray("mentions");
        for (int i = 0; i < mentions.length(); ++i) {
            User user;
            String userId = mentions.getJSONObject(i).getString("id");
            try {
                user = api.getUserById(userId).get();
            }
            catch (InterruptedException | ExecutionException e) {
                continue;
            }
            this.mentions.add(user);
        }
        JSONArray embeds = data.getJSONArray("embeds");
        for (int i = 0; i < embeds.length(); ++i) {
            ImplEmbed embed = new ImplEmbed(embeds.getJSONObject(i));
            this.embeds.add(embed);
        }
        this.channelId = data.getString("channel_id");
        this.receiver = receiver == null ? this.findReceiver(this.channelId) : receiver;
        if (data.has("reactions")) {
            JSONArray reactions = data.getJSONArray("reactions");
            for (int i = 0; i < reactions.length(); ++i) {
                this.reactions.add(new ImplReaction(api, this, reactions.getJSONObject(i)));
            }
        }
        this.nonce = data.has("nonce") && !data.isNull("nonce") ? ((maybeItsAStringAndMaybeItsNotAStringIHaveNoClue = data.get("nonce")) instanceof String ? (String)maybeItsAStringAndMaybeItsNotAStringIHaveNoClue : null) : null;
        if (this.getChannelReceiver() != null) {
            ImplServer server = (ImplServer)this.getChannelReceiver().getServer();
            server.addMember(this.author);
            JSONArray mentionRoles = data.getJSONArray("mention_roles");
            for (int i = 0; i < mentionRoles.length(); ++i) {
                String roleId = mentionRoles.getString(i);
                Role role = server.getRoleById(roleId);
                if (role == null) continue;
                this.mentionedRoles.add(role);
            }
        }
        api.addMessage(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public Channel getChannelReceiver() {
        if (this.receiver instanceof Channel) {
            return (Channel)this.receiver;
        }
        return null;
    }

    @Override
    public User getUserReceiver() {
        if (this.receiver instanceof User) {
            return (User)this.receiver;
        }
        return null;
    }

    @Override
    public MessageReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public User getAuthor() {
        return this.author;
    }

    @Override
    public boolean isPrivateMessage() {
        return this.getUserReceiver() != null;
    }

    @Override
    public List<User> getMentions() {
        return new ArrayList<User>(this.mentions);
    }

    @Override
    public List<Role> getMentionedRoles() {
        return new ArrayList<Role>(this.mentionedRoles);
    }

    @Override
    public boolean isTts() {
        return this.tts;
    }

    @Override
    public String getNonce() {
        return this.nonce;
    }

    @Override
    public boolean isMentioningEveryone() {
        return this.mentionsEveryone;
    }

    @Override
    public Future<Void> pin() {
        final ImplMessage message = this;
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                logger.debug("Trying to pin message (id: {}, author: {}, content: \"{}\")", ImplMessage.this.getId(), ImplMessage.this.getAuthor(), ImplMessage.this.getContent());
                if (ImplMessage.this.isPrivateMessage()) {
                    ImplMessage.this.api.checkRateLimit(null, RateLimitType.PRIVATE_MESSAGE, null, null);
                } else {
                    ImplMessage.this.api.checkRateLimit(null, RateLimitType.SERVER_MESSAGE, null, ImplMessage.this.getChannelReceiver());
                }
                HttpResponse<JsonNode> response = Unirest.put("https://discordapp.com/api/v6/channels/" + ImplMessage.this.channelId + "/pins/" + ImplMessage.this.getId()).header("authorization", ImplMessage.this.api.getToken()).asJson();
                ImplMessage.this.api.checkResponse(response);
                if (ImplMessage.this.isPrivateMessage()) {
                    ImplMessage.this.api.checkRateLimit(response, RateLimitType.PRIVATE_MESSAGE, null, null);
                } else {
                    ImplMessage.this.api.checkRateLimit(response, RateLimitType.SERVER_MESSAGE, null, ImplMessage.this.getChannelReceiver());
                }
                logger.debug("Pinned message (id: {}, author: {}, content: \"{}\")", ImplMessage.this.getId(), ImplMessage.this.getAuthor(), ImplMessage.this.getContent());
                5 var2_2 = this;
                synchronized (var2_2) {
                    if (message.isPinned()) {
                        return null;
                    }
                    ImplMessage.this.pinned = true;
                }
                return null;
            }
        });
    }

    @Override
    public boolean isPinned() {
        return this.pinned;
    }

    @Override
    public Future<Void> delete() {
        final ImplMessage message = this;
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                logger.debug("Trying to delete message (id: {}, author: {}, content: \"{}\")", ImplMessage.this.getId(), ImplMessage.this.getAuthor(), ImplMessage.this.getContent());
                if (ImplMessage.this.isPrivateMessage()) {
                    ImplMessage.this.api.checkRateLimit(null, RateLimitType.PRIVATE_MESSAGE_DELETE, null, null);
                } else {
                    ImplMessage.this.api.checkRateLimit(null, RateLimitType.SERVER_MESSAGE_DELETE, null, ImplMessage.this.getChannelReceiver());
                }
                HttpResponse<JsonNode> response = Unirest.delete("https://discordapp.com/api/v6/channels/" + ImplMessage.this.channelId + "/messages/" + ImplMessage.this.getId()).header("authorization", ImplMessage.this.api.getToken()).asJson();
                ImplMessage.this.api.checkResponse(response);
                if (ImplMessage.this.isPrivateMessage()) {
                    ImplMessage.this.api.checkRateLimit(response, RateLimitType.PRIVATE_MESSAGE_DELETE, null, null);
                } else {
                    ImplMessage.this.api.checkRateLimit(response, RateLimitType.SERVER_MESSAGE_DELETE, null, ImplMessage.this.getChannelReceiver());
                }
                ImplMessage.this.api.removeMessage(message);
                logger.debug("Deleted message (id: {}, author: {}, content: \"{}\")", ImplMessage.this.getId(), ImplMessage.this.getAuthor(), ImplMessage.this.getContent());
                6 var2_2 = this;
                synchronized (var2_2) {
                    if (message.isDeleted()) {
                        return null;
                    }
                    message.setDeleted(true);
                }
                ImplMessage.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<MessageDeleteListener> listeners;
                        List<MessageDeleteListener> list = listeners = ImplMessage.this.api.getListeners(MessageDeleteListener.class);
                        synchronized (list) {
                            for (MessageDeleteListener listener : listeners) {
                                try {
                                    listener.onMessageDelete(ImplMessage.this.api, message);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in MessageDeleteListener!", t);
                                }
                            }
                        }
                    }
                });
                return null;
            }
        });
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public Collection<MessageAttachment> getAttachments() {
        return Collections.unmodifiableCollection(this.attachments);
    }

    @Override
    public Future<Message> reply(String content) {
        return this.receiver.sendMessage(content);
    }

    @Override
    public Future<Message> reply(String content, EmbedBuilder embed) {
        return this.receiver.sendMessage(content, embed);
    }

    @Override
    public Future<Message> reply(String content, FutureCallback<Message> callback) {
        return this.receiver.sendMessage(content, callback);
    }

    @Override
    public Future<Message> reply(String content, EmbedBuilder embed, FutureCallback<Message> callback) {
        return this.receiver.sendMessage(content, embed, callback);
    }

    @Override
    public Calendar getCreationDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.creationDate.getTime());
        return calendar;
    }

    @Override
    public int compareTo(Message other) {
        return this.creationDate.compareTo(other.getCreationDate());
    }

    @Override
    public Future<Void> edit(final String content) {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (ImplMessage.this.isPrivateMessage()) {
                    ImplMessage.this.api.checkRateLimit(null, RateLimitType.PRIVATE_MESSAGE, null, null);
                } else {
                    ImplMessage.this.api.checkRateLimit(null, RateLimitType.SERVER_MESSAGE, null, ImplMessage.this.getChannelReceiver());
                }
                HttpResponse<JsonNode> response = Unirest.patch("https://discordapp.com/api/v6/channels/" + ImplMessage.this.channelId + "/messages/" + ImplMessage.this.getId()).header("authorization", ImplMessage.this.api.getToken()).header("content-type", "application/json").body(new JSONObject().put("content", content).toString()).asJson();
                ImplMessage.this.api.checkResponse(response);
                if (ImplMessage.this.isPrivateMessage()) {
                    ImplMessage.this.api.checkRateLimit(response, RateLimitType.PRIVATE_MESSAGE, null, null);
                } else {
                    ImplMessage.this.api.checkRateLimit(response, RateLimitType.SERVER_MESSAGE, null, ImplMessage.this.getChannelReceiver());
                }
                final String oldContent = ImplMessage.this.getContent();
                ImplMessage.this.setContent(content);
                if (!oldContent.equals(content)) {
                    ImplMessage.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<MessageEditListener> listeners;
                            List<MessageEditListener> list = listeners = ImplMessage.this.api.getListeners(MessageEditListener.class);
                            synchronized (list) {
                                for (MessageEditListener listener : listeners) {
                                    try {
                                        listener.onMessageEdit(ImplMessage.this.api, ImplMessage.this, oldContent);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in MessageEditListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                return null;
            }
        });
    }

    @Override
    public Collection<Embed> getEmbeds() {
        return Collections.unmodifiableCollection(this.embeds);
    }

    @Override
    public Future<Void> addUnicodeReaction(String unicodeEmoji) {
        return this.addReaction(unicodeEmoji);
    }

    @Override
    public Future<Void> addCustomEmojiReaction(CustomEmoji emoji) {
        return this.addReaction(emoji.getName() + ":" + emoji.getId());
    }

    @Override
    public List<Reaction> getReactions() {
        return new ArrayList<Reaction>(this.reactions);
    }

    @Override
    public Future<Void> removeAllReactions() {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to remove all reactions from message {}", (Object)ImplMessage.this);
                HttpResponse<JsonNode> response = Unirest.delete("https://discordapp.com/api/v6/channels/" + ImplMessage.this.channelId + "/messages/" + ImplMessage.this.getId() + "/reactions").header("authorization", ImplMessage.this.api.getToken()).asJson();
                ImplMessage.this.api.checkResponse(response);
                if (ImplMessage.this.isPrivateMessage()) {
                    ImplMessage.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, null, null);
                } else {
                    ImplMessage.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, null, ImplMessage.this.getChannelReceiver());
                }
                logger.debug("Removed all reactions from message {}", (Object)ImplMessage.this);
                return null;
            }
        });
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public Reaction addUnicodeReactionToCache(String unicodeReaction, boolean you) {
        for (Reaction reaction : this.reactions) {
            if (!unicodeReaction.equals(reaction.getUnicodeEmoji())) continue;
            ((ImplReaction)reaction).incrementCount(you);
            return reaction;
        }
        ImplReaction reaction = new ImplReaction(this.api, this, you, 1, unicodeReaction, null);
        this.reactions.add(reaction);
        return reaction;
    }

    public Reaction addCustomEmojiReactionToCache(CustomEmoji customEmoji, boolean you) {
        for (Reaction reaction : this.reactions) {
            if (customEmoji != reaction.getCustomEmoji()) continue;
            ((ImplReaction)reaction).incrementCount(you);
            return reaction;
        }
        ImplReaction reaction = new ImplReaction(this.api, this, you, 1, null, customEmoji);
        this.reactions.add(reaction);
        return reaction;
    }

    public Reaction removeUnicodeReactionToCache(String unicodeReaction, boolean you) {
        for (Reaction reaction : this.reactions) {
            if (!unicodeReaction.equals(reaction.getUnicodeEmoji())) continue;
            ((ImplReaction)reaction).decrementCount(you);
            if (reaction.getCount() == 0) {
                this.reactions.remove(reaction);
            }
            return reaction;
        }
        return null;
    }

    public Reaction removeCustomEmojiReactionToCache(CustomEmoji customEmoji, boolean you) {
        for (Reaction reaction : this.reactions) {
            if (customEmoji != reaction.getCustomEmoji()) continue;
            ((ImplReaction)reaction).decrementCount(you);
            if (reaction.getCount() == 0) {
                this.reactions.remove(reaction);
            }
            return reaction;
        }
        return null;
    }

    public void removeAllReactionsFromCache() {
        this.reactions.clear();
    }

    public String getChannelId() {
        return this.channelId;
    }

    private Future<Void> addReaction(final String reaction) {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to add reaction to message with id {} (reaction: {})", (Object)ImplMessage.this.getId(), (Object)reaction);
                HttpResponse<JsonNode> response = Unirest.put("https://discordapp.com/api/v6/channels/" + ImplMessage.this.channelId + "/messages/" + ImplMessage.this.getId() + "/reactions/" + reaction + "/@me").header("authorization", ImplMessage.this.api.getToken()).header("content-type", "application/json").body("{}").asJson();
                ImplMessage.this.api.checkResponse(response);
                if (ImplMessage.this.isPrivateMessage()) {
                    ImplMessage.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, null, null);
                } else {
                    ImplMessage.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, null, ImplMessage.this.getChannelReceiver());
                }
                logger.debug("Added reaction to message with id {} (reaction: {})", (Object)ImplMessage.this.getId(), (Object)reaction);
                return null;
            }
        });
    }

    private MessageReceiver findReceiver(String channelId) {
        for (Server server : this.api.getServers()) {
            if (server.getChannelById(channelId) == null) continue;
            return server.getChannelById(channelId);
        }
        for (User user : this.api.getUsers()) {
            if (!channelId.equals(((ImplUser)user).getUserChannelId())) continue;
            return user;
        }
        return null;
    }

    public String toString() {
        return this.getAuthor().getName() + ": " + this.getContent() + " (id: " + this.getId() + ")";
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

