/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.message.embed.impl;

import de.btobastian.javacord.entities.message.embed.EmbedThumbnail;
import de.btobastian.javacord.utils.LoggerUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplEmbedThumbnail
implements EmbedThumbnail {
    private static final Logger logger = LoggerUtil.getLogger(ImplEmbedThumbnail.class);
    private String url;
    private String proxyUrl;
    private int height;
    private int width;

    public ImplEmbedThumbnail(JSONObject data) {
        this.url = data.has("url") ? data.getString("url") : null;
        this.proxyUrl = data.has("proxy_url") ? data.getString("proxy_url") : null;
        this.height = data.has("height") ? data.getInt("height") : -1;
        this.width = data.has("width") ? data.getInt("width") : -1;
    }

    @Override
    public URL getUrl() {
        if (this.url == null) {
            return null;
        }
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the url of the embed thumbnail is malformed! Please contact the developer!", e);
            return null;
        }
    }

    @Override
    public URL getProxyUrl() {
        if (this.proxyUrl == null) {
            return null;
        }
        try {
            return new URL(this.proxyUrl);
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the proxy url of the embed thumbnail is malformed! Please contact the developer!", e);
            return null;
        }
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }
}

