/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.message.embed.impl;

import de.btobastian.javacord.entities.message.embed.EmbedAuthor;
import de.btobastian.javacord.utils.LoggerUtil;
import java.net.MalformedURLException;
import java.net.URL;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplEmbedAuthor
implements EmbedAuthor {
    private static final Logger logger = LoggerUtil.getLogger(ImplEmbedAuthor.class);
    private String name;
    private String url;
    private String iconUrl;
    private String proxyIconUrl;

    public ImplEmbedAuthor(JSONObject data) {
        this.name = data.has("name") ? data.getString("name") : null;
        this.url = data.has("url") ? data.getString("url") : null;
        this.iconUrl = data.has("icon_url") ? data.getString("icon_url") : null;
        this.proxyIconUrl = data.has("proxy_icon_url") ? data.getString("proxy_icon_url") : null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URL getUrl() {
        if (this.url == null) {
            return null;
        }
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the url of the embed author is malformed! Please contact the developer!", e);
            return null;
        }
    }

    @Override
    public URL getIconUrl() {
        if (this.iconUrl == null) {
            return null;
        }
        try {
            return new URL(this.iconUrl);
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the icon url of the embed author is malformed! Please contact the developer!", e);
            return null;
        }
    }

    @Override
    public URL getProxyIconUrl() {
        if (this.proxyIconUrl == null) {
            return null;
        }
        try {
            return new URL(this.proxyIconUrl);
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the proxy icon url of the embed author is malformed! Please contact the developer!", e);
            return null;
        }
    }
}

