/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.message.embed.impl;

import com.google.common.base.Joiner;
import de.btobastian.javacord.entities.message.embed.Embed;
import de.btobastian.javacord.entities.message.embed.EmbedAuthor;
import de.btobastian.javacord.entities.message.embed.EmbedField;
import de.btobastian.javacord.entities.message.embed.EmbedFooter;
import de.btobastian.javacord.entities.message.embed.EmbedImage;
import de.btobastian.javacord.entities.message.embed.EmbedProvider;
import de.btobastian.javacord.entities.message.embed.EmbedThumbnail;
import de.btobastian.javacord.entities.message.embed.EmbedVideo;
import de.btobastian.javacord.utils.LoggerUtil;
import java.awt.Color;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplEmbed
implements Embed {
    private static final Logger logger = LoggerUtil.getLogger(ImplEmbed.class);
    private static final ThreadLocal<SimpleDateFormat> TIMEZONE_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> FORMAT_ALTERNATIVE = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        }
    };
    private static final ThreadLocal<SimpleDateFormat> FORMAT_ALTERNATIVE_TWO = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        }
    };
    private String title;
    private String type;
    private String description;
    private String url;
    private Calendar creationDate;
    private Color color;
    private EmbedFooter footer;
    private EmbedImage image;
    private EmbedThumbnail thumbnail;
    private EmbedVideo video;
    private EmbedProvider provider;
    private EmbedAuthor author;
    private Collection<EmbedField> fields;

    public ImplEmbed(JSONObject data) {
        this.title = data.has("title") ? data.getString("title") : null;
        this.type = data.has("type") ? data.getString("type") : null;
        this.description = data.has("description") ? data.getString("description") : null;
        String string = this.url = data.has("url") ? data.getString("url") : null;
        if (data.has("timestamp")) {
            String time = data.getString("timestamp");
            Calendar calendar = Calendar.getInstance();
            try {
                String nanoSecondsRemoved = Joiner.on("+").join(time.split("\\d{3}\\+"));
                calendar.setTime(TIMEZONE_FORMAT.get().parse(nanoSecondsRemoved));
            }
            catch (ParseException timeZoneIgnored) {
                try {
                    calendar.setTime(FORMAT.get().parse(time.substring(0, time.length() - 9)));
                }
                catch (ParseException ignored) {
                    try {
                        calendar.setTime(FORMAT_ALTERNATIVE.get().parse(time.substring(0, time.length() - 9)));
                    }
                    catch (ParseException ignored2) {
                        try {
                            calendar.setTime(FORMAT_ALTERNATIVE_TWO.get().parse(time.substring(0, time.length() - 9)));
                        }
                        catch (ParseException e) {
                            logger.warn("Could not parse timestamp {}. Please contact the developer!", (Object)time, (Object)e);
                        }
                    }
                }
            }
            this.creationDate = calendar;
        }
        this.color = data.has("color") ? new Color(data.getInt("color")) : null;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public URL getUrl() {
        if (this.url == null) {
            return null;
        }
        try {
            return new URL(this.url);
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the url of the embed is malformed! Please contact the developer!", e);
            return null;
        }
    }

    @Override
    public Calendar getCreationDate() {
        return this.creationDate;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public EmbedFooter getFooter() {
        return this.footer;
    }

    @Override
    public EmbedImage getImage() {
        return this.image;
    }

    @Override
    public EmbedThumbnail getThumbnail() {
        return this.thumbnail;
    }

    @Override
    public EmbedVideo getVideo() {
        return this.video;
    }

    @Override
    public EmbedProvider getProvider() {
        return this.provider;
    }

    @Override
    public EmbedAuthor getAuthor() {
        return this.author;
    }

    @Override
    public Collection<EmbedField> getFields() {
        return this.fields;
    }
}

