/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.impl;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.InviteBuilder;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.VoiceChannel;
import de.btobastian.javacord.entities.impl.ImplInviteBuilder;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.entities.permissions.Permissions;
import de.btobastian.javacord.entities.permissions.Role;
import de.btobastian.javacord.entities.permissions.impl.ImplPermissions;
import de.btobastian.javacord.entities.permissions.impl.ImplRole;
import de.btobastian.javacord.listener.voicechannel.VoiceChannelChangeNameListener;
import de.btobastian.javacord.listener.voicechannel.VoiceChannelChangePositionListener;
import de.btobastian.javacord.listener.voicechannel.VoiceChannelDeleteListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.SnowflakeUtil;
import de.btobastian.javacord.utils.ratelimits.RateLimitType;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplVoiceChannel
implements VoiceChannel {
    private static final Logger logger = LoggerUtil.getLogger(ImplVoiceChannel.class);
    private static final Permissions emptyPermissions = new ImplPermissions(0, 0);
    private final ImplDiscordAPI api;
    private final String id;
    private String name;
    private int position;
    private final ImplServer server;
    private String parentId = null;
    private final ConcurrentHashMap<String, Permissions> overwrittenPermissions = new ConcurrentHashMap();
    private Set<User> connectedUsers = new HashSet<User>();

    public ImplVoiceChannel(JSONObject data, ImplServer server, ImplDiscordAPI api) {
        this.api = api;
        this.server = server;
        this.id = data.getString("id");
        this.name = data.getString("name");
        this.position = data.getInt("position");
        if (data.has("parent_id") && !data.isNull("parent_id")) {
            this.parentId = data.getString("parent_id");
        }
        JSONArray permissionOverwrites = data.getJSONArray("permission_overwrites");
        for (int i = 0; i < permissionOverwrites.length(); ++i) {
            Role role;
            JSONObject permissionOverwrite = permissionOverwrites.getJSONObject(i);
            String id = permissionOverwrite.getString("id");
            int allow = permissionOverwrite.getInt("allow");
            int deny = permissionOverwrite.getInt("deny");
            String type = permissionOverwrite.getString("type");
            if (type.equals("role") && (role = server.getRoleById(id)) != null) {
                ((ImplRole)role).setOverwrittenPermissions(this, (Permissions)new ImplPermissions(allow, deny));
            }
            if (!type.equals("member")) continue;
            this.overwrittenPermissions.put(id, new ImplPermissions(allow, deny));
        }
        server.addVoiceChannel(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Calendar getCreationDate() {
        return SnowflakeUtil.parseDate(this.id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public Future<Void> delete() {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to delete voice channel {}", (Object)ImplVoiceChannel.this);
                HttpResponse<JsonNode> response = Unirest.delete("https://discordapp.com/api/v6/channels/" + ImplVoiceChannel.this.id).header("authorization", ImplVoiceChannel.this.api.getToken()).asJson();
                ImplVoiceChannel.this.api.checkResponse(response);
                ImplVoiceChannel.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplVoiceChannel.this.server, null);
                ImplVoiceChannel.this.server.removeVoiceChannel(ImplVoiceChannel.this);
                logger.info("Deleted voice channel {}", (Object)ImplVoiceChannel.this);
                ImplVoiceChannel.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<VoiceChannelDeleteListener> listeners;
                        List<VoiceChannelDeleteListener> list = listeners = ImplVoiceChannel.this.api.getListeners(VoiceChannelDeleteListener.class);
                        synchronized (list) {
                            for (VoiceChannelDeleteListener listener : listeners) {
                                try {
                                    listener.onVoiceChannelDelete(ImplVoiceChannel.this.api, ImplVoiceChannel.this);
                                }
                                catch (Throwable t) {
                                    logger.warn("Uncaught exception in VoiceChannelDeleteListener!", t);
                                }
                            }
                        }
                    }
                });
                return null;
            }
        });
    }

    @Override
    public InviteBuilder getInviteBuilder() {
        return new ImplInviteBuilder(this, this.api);
    }

    @Override
    public Permissions getOverwrittenPermissions(User user) {
        Permissions permissions = this.overwrittenPermissions.get(user.getId());
        return permissions == null ? emptyPermissions : permissions;
    }

    @Override
    public Permissions getOverwrittenPermissions(Role role) {
        return role.getOverwrittenPermissions(this);
    }

    @Override
    public Future<Void> updateOverwrittenPermissions(final Role role, final Permissions permissions) {
        return this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Updating permissions in channel {} for role {} (allow: {}, deny: {})", this, role, ((ImplPermissions)permissions).getAllowed(), ((ImplPermissions)permissions).getDenied());
                Unirest.put("https://discordapp.com/api/v6/channels/" + ImplVoiceChannel.this.getId() + "/permissions/" + role.getId()).header("authorization", ImplVoiceChannel.this.api.getToken()).header("Content-Type", "application/json").body(new JSONObject().put("allow", ((ImplPermissions)permissions).getAllowed()).put("deny", ((ImplPermissions)permissions).getDenied()).put("type", "role").toString()).asJson();
                logger.debug("Updated permissions in channel {} for role {} (allow: {}, deny: {})", this, role, ((ImplPermissions)permissions).getAllowed(), ((ImplPermissions)permissions).getDenied());
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateOverwrittenPermissions(final User user, final Permissions permissions) {
        return this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Updating permissions in channel {} for user {} (allow: {}, deny: {})", this, user, ((ImplPermissions)permissions).getAllowed(), ((ImplPermissions)permissions).getDenied());
                Unirest.put("https://discordapp.com/api/v6/channels/" + ImplVoiceChannel.this.getId() + "/permissions/" + user.getId()).header("authorization", ImplVoiceChannel.this.api.getToken()).header("Content-Type", "application/json").body(new JSONObject().put("allow", ((ImplPermissions)permissions).getAllowed()).put("deny", ((ImplPermissions)permissions).getDenied()).put("type", "member").toString()).asJson();
                logger.debug("Updated permissions in channel {} for user {} (allow: {}, deny: {})", this, user, ((ImplPermissions)permissions).getAllowed(), ((ImplPermissions)permissions).getDenied());
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteOverwrittenPermissions(final Role role) {
        return this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Deleting permissions in channel {} for role {}", (Object)this, (Object)role);
                Unirest.delete("https://discordapp.com/api/v6/channels/" + ImplVoiceChannel.this.getId() + "/permissions/" + role.getId()).header("authorization", ImplVoiceChannel.this.api.getToken()).asJson();
                logger.debug("Deleted permissions in channel {} for role {}", (Object)this, (Object)role);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteOverwrittenPermissions(final User user) {
        return this.api.getThreadPool().getListeningExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Deleting permissions in channel {} for user {}", (Object)this, (Object)user);
                Unirest.delete("https://discordapp.com/api/v6/channels/" + ImplVoiceChannel.this.getId() + "/permissions/" + user.getId()).header("authorization", ImplVoiceChannel.this.api.getToken()).asJson();
                logger.debug("Deleted permissions in channel {} for user {}", (Object)this, (Object)user);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateName(String newName) {
        return this.update(newName, this.getPosition());
    }

    @Override
    public Future<Void> updatePosition(int newPosition) {
        return this.update(this.getName(), newPosition);
    }

    @Override
    public Future<Void> update(final String newName, final int newPosition) {
        final JSONObject params = new JSONObject().put("name", newName).put("position", newPosition);
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to update channel {} (new name: {}, old name: {}, new position: {}, old position: {})", ImplVoiceChannel.this, newName, ImplVoiceChannel.this.getName(), newPosition, ImplVoiceChannel.this.getPosition());
                HttpResponse<JsonNode> response = Unirest.patch("https://discordapp.com/api/v6/channels/" + ImplVoiceChannel.this.getId()).header("authorization", ImplVoiceChannel.this.api.getToken()).header("Content-Type", "application/json").body(params.toString()).asJson();
                ImplVoiceChannel.this.api.checkResponse(response);
                ImplVoiceChannel.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplVoiceChannel.this.server, null);
                logger.info("Updated channel {} (new name: {}, old name: {}, new position: {}, old position: {})", ImplVoiceChannel.this, newName, ImplVoiceChannel.this.getName(), newPosition, ImplVoiceChannel.this.getPosition());
                String updatedName = response.getBody().getObject().getString("name");
                int updatedPosition = response.getBody().getObject().getInt("position");
                if (!updatedName.equals(ImplVoiceChannel.this.getName())) {
                    final String oldName = ImplVoiceChannel.this.getName();
                    ImplVoiceChannel.this.setName(updatedName);
                    ImplVoiceChannel.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<VoiceChannelChangeNameListener> listeners;
                            List<VoiceChannelChangeNameListener> list = listeners = ImplVoiceChannel.this.api.getListeners(VoiceChannelChangeNameListener.class);
                            synchronized (list) {
                                for (VoiceChannelChangeNameListener listener : listeners) {
                                    try {
                                        listener.onVoiceChannelChangeName(ImplVoiceChannel.this.api, ImplVoiceChannel.this, oldName);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in VoiceChannelChangeNameListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                if (updatedPosition != ImplVoiceChannel.this.getPosition()) {
                    final int oldPosition = ImplVoiceChannel.this.getPosition();
                    ImplVoiceChannel.this.setPosition(updatedPosition);
                    ImplVoiceChannel.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<VoiceChannelChangePositionListener> listeners;
                            List<VoiceChannelChangePositionListener> list = listeners = ImplVoiceChannel.this.api.getListeners(VoiceChannelChangePositionListener.class);
                            synchronized (list) {
                                for (VoiceChannelChangePositionListener listener : listeners) {
                                    try {
                                        listener.onVoiceChannelChangePosition(ImplVoiceChannel.this.api, ImplVoiceChannel.this, oldPosition);
                                    }
                                    catch (Throwable t) {
                                        logger.warn("Uncaught exception in VoiceChannelChangePositionListener!", t);
                                    }
                                }
                            }
                        }
                    });
                }
                return null;
            }
        });
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public void setOverwrittenPermissions(User user, Permissions permissions) {
        this.overwrittenPermissions.put(user.getId(), permissions);
    }

    public void removeOverwrittenPermissions(User user) {
        this.overwrittenPermissions.remove(user.getId());
    }

    public void addConnectedUser(User user) {
        this.connectedUsers.add(user);
    }

    public void removeConnectedUser(User user) {
        this.connectedUsers.remove(user);
    }

    @Override
    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Override
    public final Set<User> getConnectedUsers() {
        return this.connectedUsers;
    }

    public String toString() {
        return this.getName() + " (id: " + this.getId() + ")";
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

