/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities.impl;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import de.btobastian.javacord.ImplDiscordAPI;
import de.btobastian.javacord.entities.CustomEmoji;
import de.btobastian.javacord.entities.Server;
import de.btobastian.javacord.entities.impl.ImplServer;
import de.btobastian.javacord.entities.permissions.Role;
import de.btobastian.javacord.listener.server.CustomEmojiDeleteListener;
import de.btobastian.javacord.utils.LoggerUtil;
import de.btobastian.javacord.utils.SnowflakeUtil;
import de.btobastian.javacord.utils.ratelimits.RateLimitType;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import javax.imageio.ImageIO;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONObject;
import org.slf4j.Logger;

public class ImplCustomEmoji
implements CustomEmoji {
    private static final Logger logger = LoggerUtil.getLogger(ImplCustomEmoji.class);
    private final ImplDiscordAPI api;
    private final ConcurrentHashMap<String, Role> roles = new ConcurrentHashMap();
    private final ImplServer server;
    private final String id;
    private String name;
    private boolean managed;
    private boolean requiresColons;

    public ImplCustomEmoji(JSONObject data, ImplServer server, ImplDiscordAPI api) {
        this.api = api;
        this.server = server;
        this.id = data.getString("id");
        this.name = data.getString("name");
        this.managed = data.getBoolean("managed");
        this.requiresColons = data.getBoolean("require_colons");
        server.addCustomEmoji(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Calendar getCreationDate() {
        return SnowflakeUtil.parseDate(this.id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public boolean isManaged() {
        return this.managed;
    }

    @Override
    public boolean requiresColons() {
        return this.requiresColons;
    }

    @Override
    public Collection<Role> getRoles() {
        return this.roles.values();
    }

    @Override
    public String getMentionTag() {
        return "<:" + this.name + ":" + this.id + ">";
    }

    @Override
    public Future<byte[]> getEmojiAsByteArray() {
        return this.getEmojiAsByteArray(null);
    }

    @Override
    public Future<byte[]> getEmojiAsByteArray(FutureCallback<byte[]> callback) {
        ListenableFuture<byte[]> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                int n;
                logger.debug("Trying to get emoji {} from server {}", (Object)ImplCustomEmoji.this, (Object)ImplCustomEmoji.this.server);
                URL url = ImplCustomEmoji.this.getImageUrl();
                HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                conn.setRequestProperty("User-Agent", "DiscordBot (https://github.com/BtoBastian/Javacord, v2.0.17)");
                BufferedInputStream in = new BufferedInputStream(conn.getInputStream());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while (-1 != (n = ((InputStream)in).read(buf))) {
                    out.write(buf, 0, n);
                }
                out.close();
                ((InputStream)in).close();
                byte[] emoji = out.toByteArray();
                logger.debug("Got emoji {} from server {} (size: {})", ImplCustomEmoji.this, ImplCustomEmoji.this.server, emoji.length);
                return emoji;
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public Future<BufferedImage> getEmoji() {
        return this.getEmoji(null);
    }

    @Override
    public Future<BufferedImage> getEmoji(FutureCallback<BufferedImage> callback) {
        ListenableFuture<BufferedImage> future = this.api.getThreadPool().getListeningExecutorService().submit(new Callable<BufferedImage>(){

            @Override
            public BufferedImage call() throws Exception {
                byte[] imageAsBytes = ImplCustomEmoji.this.getEmojiAsByteArray().get();
                if (imageAsBytes.length == 0) {
                    return null;
                }
                ByteArrayInputStream in = new ByteArrayInputStream(imageAsBytes);
                return ImageIO.read(in);
            }
        });
        if (callback != null) {
            Futures.addCallback(future, callback);
        }
        return future;
    }

    @Override
    public URL getImageUrl() {
        try {
            return new URL("https://cdn.discordapp.com/emojis/" + this.id + ".png");
        }
        catch (MalformedURLException e) {
            logger.warn("Seems like the url of the emoji is malformed! Please contact the developer!", e);
            return null;
        }
    }

    @Override
    public Future<Void> delete() {
        return this.api.getThreadPool().getExecutorService().submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                logger.debug("Trying to delete emoji {}", (Object)ImplCustomEmoji.this);
                HttpResponse<JsonNode> response = Unirest.delete("https://discordapp.com/api/v6/guilds/" + ImplCustomEmoji.this.server.getId() + "/emojis/" + ImplCustomEmoji.this.id).header("authorization", ImplCustomEmoji.this.api.getToken()).asJson();
                ImplCustomEmoji.this.api.checkResponse(response);
                ImplCustomEmoji.this.api.checkRateLimit(response, RateLimitType.UNKNOWN, ImplCustomEmoji.this.server, null);
                ImplCustomEmoji.this.server.removeCustomEmoji(ImplCustomEmoji.this);
                logger.info("Deleted emoji {}", (Object)ImplCustomEmoji.this);
                ImplCustomEmoji.this.api.getThreadPool().getSingleThreadExecutorService("listeners").submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        List<CustomEmojiDeleteListener> listeners;
                        List<CustomEmojiDeleteListener> list = listeners = ImplCustomEmoji.this.api.getListeners(CustomEmojiDeleteListener.class);
                        synchronized (list) {
                            for (CustomEmojiDeleteListener listener : listeners) {
                                listener.onCustomEmojiDelete(ImplCustomEmoji.this.api, ImplCustomEmoji.this);
                            }
                        }
                    }
                });
                return null;
            }
        });
    }

    public String toString() {
        return this.getName() + " (id: " + this.getId() + ", server: " + this.getServer().toString() + ")";
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

