/*
 * Decompiled with CFR 0.152.
 */
package de.btobastian.javacord.entities;

import com.google.common.util.concurrent.FutureCallback;
import de.btobastian.javacord.entities.Channel;
import de.btobastian.javacord.entities.CustomEmoji;
import de.btobastian.javacord.entities.Invite;
import de.btobastian.javacord.entities.Region;
import de.btobastian.javacord.entities.User;
import de.btobastian.javacord.entities.VoiceChannel;
import de.btobastian.javacord.entities.permissions.Ban;
import de.btobastian.javacord.entities.permissions.Role;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Calendar;
import java.util.Collection;
import java.util.concurrent.Future;

public interface Server {
    public String getId();

    public Calendar getCreationDate();

    public String getName();

    public Future<Void> delete();

    public Future<Void> leave();

    public Channel getChannelById(String var1);

    public Collection<Channel> getChannels();

    public VoiceChannel getVoiceChannelById(String var1);

    public Collection<VoiceChannel> getVoiceChannels();

    public User getMemberById(String var1);

    public Collection<User> getMembers();

    public boolean isMember(User var1);

    public boolean isMember(String var1);

    public Collection<Role> getRoles();

    public Role getRoleById(String var1);

    public Future<Channel> createChannel(String var1);

    public Future<Channel> createChannel(String var1, FutureCallback<Channel> var2);

    public Future<VoiceChannel> createVoiceChannel(String var1);

    public Future<VoiceChannel> createVoiceChannel(String var1, FutureCallback<VoiceChannel> var2);

    public Future<Invite[]> getInvites();

    public Future<Invite[]> getInvites(FutureCallback<Invite[]> var1);

    public Future<Void> updateRoles(User var1, Role[] var2);

    public Future<Void> banUser(User var1);

    public Future<Void> banUser(String var1);

    public Future<Void> banUser(User var1, int var2);

    public Future<Void> banUser(String var1, int var2);

    public Future<Void> unbanUser(String var1);

    public Future<Ban[]> getBans();

    public Future<Ban[]> getBans(FutureCallback<Ban[]> var1);

    public Future<Void> kickUser(User var1);

    public Future<Void> kickUser(String var1);

    public Future<Role> createRole();

    public Future<Role> createRole(FutureCallback<Role> var1);

    public Future<Void> updateName(String var1);

    public Future<Void> updateRegion(Region var1);

    public Future<Void> updateIcon(BufferedImage var1);

    public Future<Void> update(String var1, Region var2, BufferedImage var3);

    public Region getRegion();

    public int getMemberCount();

    public boolean isLarge();

    public String getOwnerId();

    public Future<User> getOwner();

    public Collection<CustomEmoji> getCustomEmojis();

    public CustomEmoji getCustomEmojiById(String var1);

    public CustomEmoji getCustomEmojiByName(String var1);

    public String getNickname(User var1);

    public boolean hasNickname(User var1);

    public Future<Void> updateNickname(User var1, String var2);

    public URL getIconUrl();

    public Future<byte[]> getIcon();

    public Future<byte[]> getIcon(FutureCallback<byte[]> var1);
}

