/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import me.lucko.spark.common.monitor.ping.PlayerPingProvider;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.platform.serverconfig.ServerConfigProvider;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.forge.ForgeCommandSender;
import me.lucko.spark.forge.ForgePlatformInfo;
import me.lucko.spark.forge.ForgePlayerPingProvider;
import me.lucko.spark.forge.ForgeServerConfigProvider;
import me.lucko.spark.forge.ForgeSparkMod;
import me.lucko.spark.forge.ForgeTickHook;
import me.lucko.spark.forge.ForgeTickReporter;
import me.lucko.spark.forge.ForgeWorldInfoProvider;
import me.lucko.spark.forge.mixin.MinecraftServerAccessorMixin;
import me.lucko.spark.forge.plugin.ForgeSparkPlugin;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.server.permission.DefaultPermissionLevel;
import net.minecraftforge.server.permission.PermissionAPI;

public class ForgeServerSparkPlugin
extends ForgeSparkPlugin
implements ICommand {
    private final MinecraftServer server;
    private final ThreadDumper gameThreadDumper;

    public static ForgeServerSparkPlugin register(ForgeSparkMod mod, FMLServerStartingEvent event) {
        ForgeServerSparkPlugin plugin = new ForgeServerSparkPlugin(mod, event.getServer());
        plugin.enable();
        event.registerServerCommand((ICommand)plugin);
        PermissionAPI.registerNode((String)"spark", (DefaultPermissionLevel)DefaultPermissionLevel.OP, (String)"Access to the spark command");
        return plugin;
    }

    @Override
    public ThreadDumper getDefaultThreadDumper() {
        return this.gameThreadDumper;
    }

    private ForgeServerSparkPlugin(ForgeSparkMod mod, MinecraftServer server) {
        super(mod);
        this.server = server;
        this.gameThreadDumper = new ThreadDumper.Specific(((MinecraftServerAccessorMixin)server).getServerThread());
    }

    @Override
    public void enable() {
        super.enable();
    }

    @Override
    public void disable() {
        super.disable();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        String[] proc = ForgeServerSparkPlugin.processArgs(args, false);
        this.platform.executeCommand(new ForgeCommandSender(sender, this), proc);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        String[] proc = ForgeServerSparkPlugin.processArgs(args, true);
        return this.generateSuggestions(new ForgeCommandSender(sender, this), proc);
    }

    @Override
    public boolean hasPermission(ICommandSender sender, String permission) {
        if (sender instanceof EntityPlayer) {
            return PermissionAPI.hasPermission((EntityPlayer)((EntityPlayer)sender), (String)permission);
        }
        return true;
    }

    public Stream<ForgeCommandSender> getCommandSenders() {
        return Stream.concat(this.server.func_184103_al().func_181057_v().stream(), Stream.of(this.server)).map(sender -> new ForgeCommandSender((ICommandSender)sender, this));
    }

    @Override
    public boolean runBackgroundProfiler() {
        return true;
    }

    @Override
    public void executeSync(Runnable task) {
        this.server.func_152344_a(task);
    }

    @Override
    public TickHook createTickHook() {
        return new ForgeTickHook(TickEvent.Type.SERVER);
    }

    @Override
    public TickReporter createTickReporter() {
        return new ForgeTickReporter(TickEvent.Type.SERVER);
    }

    @Override
    public PlayerPingProvider createPlayerPingProvider() {
        return new ForgePlayerPingProvider(this.server);
    }

    @Override
    public ServerConfigProvider createServerConfigProvider() {
        return new ForgeServerConfigProvider();
    }

    @Override
    public WorldInfoProvider createWorldInfoProvider() {
        return new ForgeWorldInfoProvider.Server(this.server);
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new ForgePlatformInfo(PlatformInfo.Type.SERVER);
    }

    @Override
    public String getCommandName() {
        return "spark";
    }

    public String func_71517_b() {
        return this.getCommandName();
    }

    public String func_71518_a(ICommandSender iCommandSender) {
        return "/" + this.getCommandName();
    }

    public List<String> func_71514_a() {
        return Collections.singletonList(this.getCommandName());
    }

    public boolean func_184882_a(MinecraftServer minecraftServer, ICommandSender sender) {
        return this.platform.hasPermissionForAnyCommand(new ForgeCommandSender(sender, this));
    }

    public boolean func_82358_a(String[] strings, int i) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.getCommandName().compareTo(o.func_71517_b());
    }
}

