/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import java.nio.file.Path;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.stream.Stream;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.SparkPlugin;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.platform.serverconfig.ServerConfigProvider;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.util.SparkThreadFactory;
import me.lucko.spark.forge.ForgePlatformInfo;
import me.lucko.spark.forge.ForgeServerConfigProvider;
import me.lucko.spark.forge.ForgeSparkMod;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForgeLoadingSparkPlugin
implements SparkPlugin {
    private final boolean isClient = FMLLaunchHandler.side() == Side.CLIENT;
    private final Logger logger = LogManager.getLogger((String)"spark");
    protected final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(4, new SparkThreadFactory());
    protected SparkPlatform platform;

    protected ForgeLoadingSparkPlugin() {
    }

    public static ForgeLoadingSparkPlugin register() {
        ForgeLoadingSparkPlugin plugin = new ForgeLoadingSparkPlugin();
        plugin.enable();
        return plugin;
    }

    public void enable() {
        this.platform = new SparkPlatform(this);
        this.platform.enable();
    }

    public void disable() {
        this.platform.disable();
        this.scheduler.shutdown();
    }

    public SparkPlatform getPlatform() {
        return this.platform;
    }

    @Override
    public ThreadDumper getDefaultThreadDumper() {
        return ThreadDumper.ALL;
    }

    @Override
    public ServerConfigProvider createServerConfigProvider() {
        return this.isClient ? null : new ForgeServerConfigProvider();
    }

    @Override
    public String getVersion() {
        return ForgeSparkMod.getVersion();
    }

    @Override
    public Path getPluginDirectory() {
        return ForgeSparkMod.getConfigDirectory();
    }

    @Override
    public String getCommandName() {
        return null;
    }

    @Override
    public Stream<? extends CommandSender> getCommandSenders() {
        return Stream.empty();
    }

    @Override
    public void executeAsync(Runnable task) {
        this.scheduler.execute(task);
    }

    @Override
    public void log(Level level, String msg) {
        if (level == Level.INFO) {
            this.logger.info(msg);
        } else if (level == Level.WARNING) {
            this.logger.warn(msg);
        } else if (level == Level.SEVERE) {
            this.logger.error(msg);
        } else {
            throw new IllegalArgumentException(level.getName());
        }
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return this.isClient ? new ForgePlatformInfo(PlatformInfo.Type.CLIENT) : new ForgePlatformInfo(PlatformInfo.Type.SERVER);
    }
}

