/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge.plugin;

import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import me.lucko.spark.common.platform.PlatformInfo;
import me.lucko.spark.common.platform.world.WorldInfoProvider;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.common.tick.TickReporter;
import me.lucko.spark.forge.ForgeCommandSender;
import me.lucko.spark.forge.ForgePlatformInfo;
import me.lucko.spark.forge.ForgeSparkMod;
import me.lucko.spark.forge.ForgeTickHook;
import me.lucko.spark.forge.ForgeTickReporter;
import me.lucko.spark.forge.ForgeWorldInfoProvider;
import me.lucko.spark.forge.mixin.MinecraftAccessorMixin;
import me.lucko.spark.forge.plugin.ForgeSparkPlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ForgeClientSparkPlugin
extends ForgeSparkPlugin
implements ICommand {
    private final Minecraft minecraft;
    private final ThreadDumper gameThreadDumper;

    public static void register(ForgeSparkMod mod) {
        ForgeClientSparkPlugin plugin = new ForgeClientSparkPlugin(mod, Minecraft.func_71410_x());
        plugin.enable();
        MinecraftForge.EVENT_BUS.register((Object)plugin);
        ClientCommandHandler.instance.func_71560_a((ICommand)plugin);
    }

    @Override
    public ThreadDumper getDefaultThreadDumper() {
        return this.gameThreadDumper;
    }

    public ForgeClientSparkPlugin(ForgeSparkMod mod, Minecraft minecraft) {
        super(mod);
        this.minecraft = minecraft;
        this.gameThreadDumper = new ThreadDumper.Specific(((MinecraftAccessorMixin)minecraft).getThread());
    }

    @Override
    public void enable() {
        super.enable();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
        String[] proc = ForgeClientSparkPlugin.processArgs(args, false);
        this.platform.executeCommand(new ForgeCommandSender(sender, this), proc);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos pos) {
        String[] proc = ForgeClientSparkPlugin.processArgs(args, true);
        return this.generateSuggestions(new ForgeCommandSender(sender, this), proc);
    }

    @Override
    public boolean hasPermission(ICommandSender sender, String permission) {
        return true;
    }

    public Stream<ForgeCommandSender> getCommandSenders() {
        return Stream.of(new ForgeCommandSender((ICommandSender)this.minecraft.field_71439_g, this));
    }

    @Override
    public void executeSync(Runnable task) {
        this.minecraft.func_152344_a(task);
    }

    @Override
    public TickHook createTickHook() {
        return new ForgeTickHook(TickEvent.Type.CLIENT);
    }

    @Override
    public TickReporter createTickReporter() {
        return new ForgeTickReporter(TickEvent.Type.CLIENT);
    }

    @Override
    public WorldInfoProvider createWorldInfoProvider() {
        return new ForgeWorldInfoProvider.Client(this.minecraft);
    }

    @Override
    public PlatformInfo getPlatformInfo() {
        return new ForgePlatformInfo(PlatformInfo.Type.CLIENT);
    }

    @Override
    public String getCommandName() {
        return "sparkc";
    }

    public String func_71517_b() {
        return this.getCommandName();
    }

    public String func_71518_a(ICommandSender iCommandSender) {
        return "/" + this.getCommandName();
    }

    public List<String> func_71514_a() {
        return Collections.singletonList(this.getCommandName());
    }

    public boolean func_184882_a(MinecraftServer minecraftServer, ICommandSender sender) {
        return this.platform.hasPermissionForAnyCommand(new ForgeCommandSender(sender, this));
    }

    public boolean func_82358_a(String[] strings, int i) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.getCommandName().compareTo(o.func_71517_b());
    }
}

