/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.forge;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import me.lucko.spark.forge.ForgeLoadingSamplerModule;
import me.lucko.spark.forge.plugin.ForgeClientSparkPlugin;
import me.lucko.spark.forge.plugin.ForgeLoadingSparkPlugin;
import me.lucko.spark.forge.plugin.ForgeServerSparkPlugin;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="spark", name="Spark Unforged", version="1.11.2", acceptableRemoteVersions="*")
public class ForgeSparkMod {
    private static final Path configDirectory = Paths.get(new File("config").toPath() + File.separator + "spark", new String[0]);
    private ForgeServerSparkPlugin activeServerPlugin;
    private static ForgeLoadingSparkPlugin activeLoadingPlugin;

    public static String getVersion() {
        return ForgeSparkMod.class.getAnnotation(Mod.class).version();
    }

    public static Path getConfigDirectory() {
        return configDirectory;
    }

    @Mod.EventHandler
    public void clientInit(FMLInitializationEvent e) {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            ForgeClientSparkPlugin.register(this);
        }
    }

    @Mod.EventHandler
    public void serverInit(FMLServerStartingEvent e) {
        this.activeServerPlugin = ForgeServerSparkPlugin.register(this, e);
    }

    @Mod.EventHandler
    public void serverStop(FMLServerStoppingEvent e) {
        if (this.activeServerPlugin != null) {
            this.activeServerPlugin.disable();
            this.activeServerPlugin = null;
        }
    }

    public static void startLoadingPlugin() {
        activeLoadingPlugin = ForgeLoadingSparkPlugin.register();
        if (!ForgeSparkMod.getActiveLoadingPlugin().getPlatform().getConfiguration().getOrSaveBoolean("loadingProfiler_ENABLED", false)) {
            activeLoadingPlugin.disable();
            activeLoadingPlugin = null;
        }
    }

    public static ForgeLoadingSparkPlugin getActiveLoadingPlugin() {
        return activeLoadingPlugin;
    }

    public static void endLoadingPlugin() {
        if (activeLoadingPlugin != null) {
            ForgeLoadingSamplerModule.clearHangingSamplers(ForgeSparkMod.getActiveLoadingPlugin());
            activeLoadingPlugin.disable();
            activeLoadingPlugin = null;
        }
    }
}

