/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.command;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.Arguments;
import me.lucko.spark.common.command.CommandResponseHandler;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.format.NamedTextColor;
import me.lucko.spark.lib.adventure.text.format.TextColor;

public class Command {
    private final List<String> aliases;
    private final List<ArgumentInfo> arguments;
    private final Executor executor;
    private final TabCompleter tabCompleter;
    private final boolean allowSubCommand;

    public static Builder builder() {
        return new Builder();
    }

    private Command(List<String> aliases, List<ArgumentInfo> arguments, Executor executor, TabCompleter tabCompleter, boolean allowSubCommand) {
        this.aliases = aliases;
        this.arguments = arguments;
        this.executor = executor;
        this.tabCompleter = tabCompleter;
        this.allowSubCommand = allowSubCommand;
    }

    public List<String> aliases() {
        return this.aliases;
    }

    public List<ArgumentInfo> arguments() {
        return this.arguments;
    }

    public Executor executor() {
        return this.executor;
    }

    public TabCompleter tabCompleter() {
        return this.tabCompleter;
    }

    public String primaryAlias() {
        return this.aliases.get(0);
    }

    public boolean allowSubCommand() {
        return this.allowSubCommand;
    }

    public static final class ArgumentInfo {
        private final String subCommandName;
        private final String argumentName;
        private final String parameterDescription;

        public ArgumentInfo(String subCommandName, String argumentName, String parameterDescription) {
            this.subCommandName = subCommandName;
            this.argumentName = argumentName;
            this.parameterDescription = parameterDescription;
        }

        public String subCommandName() {
            return this.subCommandName;
        }

        public String argumentName() {
            return this.argumentName;
        }

        public String parameterDescription() {
            return this.parameterDescription;
        }

        public boolean requiresParameter() {
            return this.parameterDescription != null;
        }

        public Component toComponent(String padding) {
            if (this.requiresParameter()) {
                return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(padding).append((Component)Component.text("[", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text("--" + this.argumentName(), (TextColor)NamedTextColor.GRAY))).append((Component)Component.space())).append((Component)Component.text("<" + this.parameterDescription() + ">", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text("]", (TextColor)NamedTextColor.DARK_GRAY))).build();
            }
            return ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(padding).append((Component)Component.text("[", (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text("--" + this.argumentName(), (TextColor)NamedTextColor.GRAY))).append((Component)Component.text("]", (TextColor)NamedTextColor.DARK_GRAY))).build();
        }
    }

    @FunctionalInterface
    public static interface TabCompleter {
        public static <S> TabCompleter empty() {
            return (platform, sender, arguments) -> Collections.emptyList();
        }

        public List<String> completions(SparkPlatform var1, CommandSender var2, List<String> var3);
    }

    @FunctionalInterface
    public static interface Executor {
        public void execute(SparkPlatform var1, CommandSender var2, CommandResponseHandler var3, Arguments var4);
    }

    public static final class Builder {
        private final ImmutableList.Builder<String> aliases = ImmutableList.builder();
        private final ImmutableList.Builder<ArgumentInfo> arguments = ImmutableList.builder();
        private Executor executor = null;
        private TabCompleter tabCompleter = null;
        private boolean allowSubCommand = false;

        Builder() {
        }

        public Builder aliases(String ... aliases) {
            this.aliases.add((Object[])aliases);
            return this;
        }

        public Builder argumentUsage(String subCommandName, String argumentName, String parameterDescription) {
            this.arguments.add((Object)new ArgumentInfo(subCommandName, argumentName, parameterDescription));
            return this;
        }

        public Builder argumentUsage(String argumentName, String parameterDescription) {
            this.arguments.add((Object)new ArgumentInfo("", argumentName, parameterDescription));
            return this;
        }

        public Builder executor(Executor executor) {
            this.executor = Objects.requireNonNull(executor, "executor");
            return this;
        }

        public Builder tabCompleter(TabCompleter tabCompleter) {
            this.tabCompleter = Objects.requireNonNull(tabCompleter, "tabCompleter");
            return this;
        }

        public Builder allowSubCommand(boolean allowSubCommand) {
            this.allowSubCommand = allowSubCommand;
            return this;
        }

        public Command build() {
            ImmutableList aliases = this.aliases.build();
            if (aliases.isEmpty()) {
                throw new IllegalStateException("No aliases defined");
            }
            if (this.executor == null) {
                throw new IllegalStateException("No defined executor");
            }
            if (this.tabCompleter == null) {
                this.tabCompleter = TabCompleter.empty();
            }
            return new Command((List)aliases, (List)this.arguments.build(), this.executor, this.tabCompleter, this.allowSubCommand);
        }
    }
}

