/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.magicwerk.brownies.collections.helper.primitive.IntBinarySearch;
import org.magicwerk.brownies.collections.helper.primitive.IntMergeSort;
import org.magicwerk.brownies.collections.primitive.IIntList;
import org.magicwerk.brownies.collections.primitive.IntGapList;

public class IntBigList
extends IIntList {
    private static final long serialVersionUID = 3715838828540564836L;
    private static final int DEFAULT_BLOCK_SIZE = 1000;
    private static final float MERGE_THRESHOLD = 0.35f;
    private static final float FILL_THRESHOLD = 0.95f;
    private static final boolean CHECK = false;
    private static final IntBigList EMPTY = IntBigList.create().unmodifiableList();
    private int blockSize;
    private int size;
    private IntBlockNode rootNode;
    private IntBlockNode currNode;
    private int currIntBlockStart;
    private int currIntBlockEnd;
    private int currModify;

    public static IIntList of(int[] values2) {
        return new ImmutableIntListArrayPrimitive(values2);
    }

    public static IIntList of(Integer[] values2) {
        return new ImmutableIntListArrayWrapper(values2);
    }

    public static IIntList of(List<Integer> values2) {
        return new ImmutableIntListList(values2);
    }

    public static IntBigList EMPTY() {
        return EMPTY;
    }

    protected IntBigList(boolean copy2, IntBigList that) {
        if (copy2) {
            this.blockSize = that.blockSize;
            this.currIntBlockStart = that.currIntBlockStart;
            this.currIntBlockEnd = that.currIntBlockEnd;
            this.currNode = that.currNode;
            this.rootNode = that.rootNode;
            this.size = that.size;
        }
    }

    public static IntBigList create() {
        return new IntBigList();
    }

    public static IntBigList create(Collection<Integer> coll) {
        return new IntBigList(coll);
    }

    public static IntBigList create(int ... elems) {
        IntBigList list2 = new IntBigList();
        for (int elem : elems) {
            list2.add(elem);
        }
        return list2;
    }

    public IntBigList() {
        this(1000);
    }

    public IntBigList(int blockSize) {
        if (blockSize < 2) {
            throw new IndexOutOfBoundsException("Invalid blockSize: " + blockSize);
        }
        this.doInit(blockSize, -1);
    }

    public IntBigList(Collection<Integer> coll) {
        if (coll instanceof IntBigList) {
            this.doAssign((IntBigList)((Object)coll));
            this.doClone((IntBigList)((Object)coll));
        } else {
            this.blockSize = 1000;
            this.addIntBlock(0, new IntBlock());
            for (Object obj : coll.toArray()) {
                this.add((Integer)obj);
            }
            assert (this.size() == coll.size());
        }
    }

    public int blockSize() {
        return this.blockSize;
    }

    private IntBigList(int blockSize, int firstIntBlockSize) {
        this.doInit(blockSize, firstIntBlockSize);
    }

    private void doInit(int blockSize, int firstIntBlockSize) {
        this.blockSize = blockSize;
        IntBlock block = firstIntBlockSize <= 1 ? new IntBlock() : new IntBlock(firstIntBlockSize);
        this.addIntBlock(0, block);
    }

    @Override
    public IntBigList copy() {
        return (IntBigList)super.copy();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    protected void doAssign(IIntList that) {
        IntBigList list2 = (IntBigList)that;
        this.blockSize = list2.blockSize;
        this.currIntBlockEnd = list2.currIntBlockEnd;
        this.currIntBlockStart = list2.currIntBlockStart;
        this.currNode = list2.currNode;
        this.rootNode = list2.rootNode;
        this.size = list2.size;
    }

    @Override
    protected void doClone(IIntList that) {
        IntBigList bigList = (IntBigList)that;
        bigList.releaseIntBlock();
        this.rootNode = this.copy(bigList.rootNode);
        this.currNode = null;
        this.currModify = 0;
    }

    private IntBlockNode copy(IntBlockNode node) {
        IntBlockNode newNode = node.min();
        int index = newNode.block.size();
        IntBlockNode newRoot = new IntBlockNode(null, index, newNode.block.ref(), null, null);
        while ((newNode = newNode.next()) != null) {
            newRoot = newRoot.insert(index += newNode.block.size(), newNode.block.ref());
            newRoot.parent = null;
        }
        return newRoot;
    }

    @Override
    public int getDefaultElem() {
        return 0;
    }

    protected void finalize() {
        IntBlockNode node = this.rootNode.min();
        while (node != null) {
            node.block.unref();
            node = node.next();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    protected int doGet(int index) {
        int pos2 = this.getIntBlockIndex(index, false, 0);
        return this.currNode.block.doGet(pos2);
    }

    @Override
    protected int doSet(int index, int elem) {
        int pos2 = this.getIntBlockIndex(index, true, 0);
        int oldElem = this.currNode.block.doGet(pos2);
        this.currNode.block.doSet(pos2, elem);
        return oldElem;
    }

    @Override
    protected int doReSet(int index, int elem) {
        int pos2 = this.getIntBlockIndex(index, true, 0);
        int oldElem = this.currNode.block.doGet(pos2);
        this.currNode.block.doSet(pos2, elem);
        return oldElem;
    }

    private void releaseIntBlock() {
        if (this.currModify != 0) {
            int modify = this.currModify;
            this.currModify = 0;
            this.modify(this.currNode, modify);
        }
        this.currNode = null;
    }

    private int getIntBlockIndex(int index, boolean write, int modify) {
        if (this.currNode != null) {
            if (index >= this.currIntBlockStart && (index < this.currIntBlockEnd || index == this.currIntBlockEnd && this.size == index)) {
                if (write && this.currNode.block.isShared()) {
                    this.currNode.block.unref();
                    this.currNode.setIntBlock(new IntBlock(this.currNode.block));
                }
                this.currModify += modify;
                return index - this.currIntBlockStart;
            }
            this.releaseIntBlock();
        }
        if (index == this.size) {
            if (this.currNode == null || this.currIntBlockEnd != this.size) {
                this.currNode = this.rootNode.max();
                this.currIntBlockEnd = this.size;
                this.currIntBlockStart = this.size - this.currNode.block.size();
            }
            if (modify != 0) {
                this.currNode.relPos += modify;
                IntBlockNode leftNode = this.currNode.getLeftSubTree();
                if (leftNode != null) {
                    leftNode.relPos -= modify;
                }
            }
        } else if (index == 0) {
            if (this.currNode == null || this.currIntBlockStart != 0) {
                this.currNode = this.rootNode.min();
                this.currIntBlockEnd = this.currNode.block.size();
                this.currIntBlockStart = 0;
            }
            if (modify != 0) {
                this.rootNode.relPos += modify;
            }
        }
        if (this.currNode == null) {
            this.doGetIntBlock(index, modify);
        }
        assert (index >= this.currIntBlockStart && index <= this.currIntBlockEnd);
        if (write && this.currNode.block.isShared()) {
            this.currNode.block.unref();
            this.currNode.setIntBlock(new IntBlock(this.currNode.block));
        }
        return index - this.currIntBlockStart;
    }

    private boolean isOnlyRootIntBlock() {
        return this.rootNode.left == null && this.rootNode.right == null;
    }

    private void doGetIntBlock(int index, int modify) {
        this.currNode = this.rootNode;
        this.currIntBlockEnd = this.rootNode.relPos;
        if (this.currNode.relPos == 0) {
            if (modify != 0) {
                this.currNode.relPos += modify;
            }
        } else {
            boolean wasLeft = false;
            while (true) {
                IntBlockNode nextNode;
                assert (index >= 0);
                int leftIndex = this.currIntBlockEnd - this.currNode.block.size();
                assert (leftIndex >= 0);
                if (index >= leftIndex && index < this.currIntBlockEnd) {
                    if (modify == 0) break;
                    IntBlockNode leftNode = this.currNode.getLeftSubTree();
                    if (this.currNode.relPos > 0) {
                        this.currNode.relPos += modify;
                        if (leftNode == null) break;
                        leftNode.relPos -= modify;
                        break;
                    }
                    if (leftNode == null) break;
                    leftNode.relPos -= modify;
                    break;
                }
                if (index < this.currIntBlockEnd) {
                    nextNode = this.currNode.getLeftSubTree();
                    if (!(modify == 0 || nextNode != null && wasLeft)) {
                        this.currNode.relPos = this.currNode.relPos > 0 ? (this.currNode.relPos += modify) : (this.currNode.relPos -= modify);
                        wasLeft = true;
                    }
                    if (nextNode == null) {
                        break;
                    }
                } else {
                    nextNode = this.currNode.getRightSubTree();
                    if (modify != 0 && (nextNode == null || wasLeft)) {
                        if (this.currNode.relPos > 0) {
                            this.currNode.relPos += modify;
                            IntBlockNode left = this.currNode.getLeftSubTree();
                            if (left != null) {
                                left.relPos -= modify;
                            }
                        } else {
                            this.currNode.relPos -= modify;
                        }
                        wasLeft = false;
                    }
                    if (nextNode == null) break;
                }
                this.currIntBlockEnd += nextNode.relPos;
                this.currNode = nextNode;
            }
        }
        this.currIntBlockStart = this.currIntBlockEnd - this.currNode.block.size();
    }

    private void addIntBlock(int index, IntBlock obj) {
        if (this.rootNode == null) {
            this.rootNode = new IntBlockNode(null, index, obj, null, null);
        } else {
            this.rootNode = this.rootNode.insert(index, obj);
            this.rootNode.parent = null;
        }
    }

    @Override
    protected boolean doAdd(int index, int element) {
        int maxSize;
        if (index == -1) {
            index = this.size;
        }
        int pos2 = this.getIntBlockIndex(index, true, 1);
        int n = maxSize = index == this.size || index == 0 ? (int)((float)this.blockSize * 0.95f) : this.blockSize;
        if (this.currNode.block.size() < maxSize || this.currNode.block.size() == 1 && this.currNode.block.size() < this.blockSize) {
            this.currNode.block.doAdd(pos2, element);
            ++this.currIntBlockEnd;
        } else {
            IntBlock newIntBlock = new IntBlock(this.blockSize);
            if (index == this.size) {
                IntBlockNode lastNode;
                newIntBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addIntBlock(this.size + 1, newIntBlock);
                this.currNode = lastNode = this.currNode.next();
                this.currIntBlockStart = this.currIntBlockEnd++;
            } else if (index == 0) {
                IntBlockNode firstNode;
                newIntBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addIntBlock(1, newIntBlock);
                this.currNode = firstNode = this.currNode.previous();
                this.currIntBlockStart = 0;
                this.currIntBlockEnd = 1;
            } else {
                int nextIntBlockLen = this.blockSize / 2;
                int blockLen = this.blockSize - nextIntBlockLen;
                IntGapList.transferRemove(this.currNode.block, blockLen, nextIntBlockLen, newIntBlock, 0, 0);
                this.modify(this.currNode, -nextIntBlockLen - 1);
                this.addIntBlock(this.currIntBlockEnd - nextIntBlockLen, newIntBlock);
                if (pos2 < blockLen) {
                    this.currNode.block.doAdd(pos2, element);
                    this.currIntBlockEnd = this.currIntBlockStart + blockLen + 1;
                    this.modify(this.currNode, 1);
                } else {
                    this.currNode = this.currNode.next();
                    this.modify(this.currNode, 1);
                    this.currNode.block.doAdd(pos2 - blockLen, element);
                    this.currIntBlockStart += blockLen;
                    ++this.currIntBlockEnd;
                }
            }
        }
        ++this.size;
        return true;
    }

    private void modify(IntBlockNode node, int modify) {
        if (node == this.currNode) {
            modify += this.currModify;
            this.currModify = 0;
        } else {
            this.releaseIntBlock();
        }
        if (modify == 0) {
            return;
        }
        if (node.relPos < 0) {
            IntBlockNode p;
            IntBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            IntBlockNode pp = node.parent;
            assert (pp.getLeftSubTree() == node);
            boolean parentRight = true;
            while ((p = pp.parent) != null) {
                boolean pRight;
                boolean bl = pRight = p.getLeftSubTree() == pp;
                if (parentRight != pRight) {
                    pp.relPos = pp.relPos > 0 ? (pp.relPos += modify) : (pp.relPos -= modify);
                }
                pp = p;
                parentRight = pRight;
            }
            if (parentRight) {
                this.rootNode.relPos += modify;
            }
        } else {
            IntBlockNode parent2;
            node.relPos += modify;
            IntBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            if ((parent2 = node.parent) != null) {
                IntBlockNode p;
                assert (parent2.getRightSubTree() == node);
                boolean parentLeft = true;
                while ((p = parent2.parent) != null) {
                    boolean pLeft;
                    boolean bl = pLeft = p.getRightSubTree() == parent2;
                    if (parentLeft != pLeft) {
                        parent2.relPos = parent2.relPos > 0 ? (parent2.relPos += modify) : (parent2.relPos -= modify);
                    }
                    parent2 = p;
                    parentLeft = pLeft;
                }
                if (!parentLeft) {
                    this.rootNode.relPos += modify;
                }
            }
        }
    }

    private IntBlockNode doRemove(IntBlockNode node) {
        IntBlockNode newNode;
        IntBlockNode p = node.parent;
        IntBlockNode n = newNode = node.removeSelf();
        while (p != null) {
            assert (p.left == node || p.right == node);
            if (p.left == node) {
                p.left = newNode;
            } else {
                p.right = newNode;
            }
            node = p;
            node.recalcHeight();
            newNode = node.balance();
            p = newNode.parent;
        }
        this.rootNode = newNode;
        return n;
    }

    @Override
    protected boolean doAddAll(int index, IIntList list2) {
        if (list2.size() == 0) {
            return false;
        }
        if (index == -1) {
            index = this.size;
        }
        int oldSize = this.size;
        if (list2.size() == 1) {
            return this.doAdd(index, list2.get(0));
        }
        int addPos = this.getIntBlockIndex(index, true, 0);
        IntBlock addIntBlock = this.currNode.block;
        int space = this.blockSize - addIntBlock.size();
        int addLen = list2.size();
        if (addLen <= space) {
            this.currNode.block.addAll(addPos, list2);
            this.modify(this.currNode, addLen);
            this.size += addLen;
            this.currIntBlockEnd += addLen;
        } else if (index == this.size) {
            int add;
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list2.get(i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                IntBlock nextIntBlock = new IntBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextIntBlock.add(i, list2.get(done + i));
                }
                this.addIntBlock(this.size + (done += add), nextIntBlock);
                this.currNode = this.currNode.next();
            }
            this.size += addLen;
            this.currIntBlockEnd = this.size;
            this.currIntBlockStart = this.currIntBlockEnd - this.currNode.block.size();
        } else if (index == 0) {
            int add;
            assert (addPos == 0);
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list2.get(addLen - space + i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                IntBlock nextIntBlock = new IntBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextIntBlock.add(i, list2.get(addLen - done - add + i));
                }
                done += add;
                this.addIntBlock(0, nextIntBlock);
                this.currNode = this.currNode.previous();
            }
            this.size += addLen;
            this.currIntBlockStart = 0;
            this.currIntBlockEnd = this.currNode.block.size();
        } else {
            IntGapList sublist;
            int add;
            IntGapList list22 = IntGapList.create();
            list22.addAll(list2);
            int remove = this.currNode.block.size() - addPos;
            if (remove > 0) {
                list22.addAll(this.currNode.block.getAll(addPos, remove));
                this.currNode.block.remove(addPos, remove);
                this.modify(this.currNode, -remove);
                this.size -= remove;
                this.currIntBlockEnd -= remove;
            }
            int numElems = this.currNode.block.size() + list22.size();
            int numIntBlocks = (numElems - 1) / this.blockSize + 1;
            assert (numIntBlocks > 1);
            int has = this.currNode.block.size();
            int should = numElems / numIntBlocks;
            int listPos = 0;
            if (has < should) {
                add = should - has;
                sublist = list22.getAll(0, add);
                listPos += add;
                this.currNode.block.addAll(addPos, sublist);
                this.modify(this.currNode, add);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                --numIntBlocks;
                this.size += add;
                this.currIntBlockEnd += add;
            } else if (has > should) {
                IntBlock nextIntBlock = new IntBlock(this.blockSize);
                int move = has - should;
                nextIntBlock.addAll(this.currNode.block.getAll(this.currNode.block.size() - move, move));
                this.currNode.block.remove(this.currNode.block.size() - move, move);
                this.modify(this.currNode, -move);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                this.currIntBlockEnd -= move;
                should = numElems / --numIntBlocks;
                int add2 = should - move;
                assert (add2 >= 0);
                IntGapList sublist2 = list22.getAll(0, add2);
                nextIntBlock.addAll(move, sublist2);
                listPos += add2;
                assert (nextIntBlock.size() == should);
                numElems -= should;
                --numIntBlocks;
                this.size += add2;
                this.addIntBlock(this.currIntBlockEnd, nextIntBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextIntBlock);
                assert (this.currNode.block.size() == add2 + move);
                this.currIntBlockStart = this.currIntBlockEnd;
                this.currIntBlockEnd += add2 + move;
            } else {
                numElems -= should;
                --numIntBlocks;
            }
            while (numIntBlocks > 0) {
                add = numElems / numIntBlocks;
                assert (add > 0);
                sublist = list22.getAll(listPos, add);
                listPos += add;
                IntBlock nextIntBlock = new IntBlock();
                nextIntBlock.addAll(sublist);
                assert (nextIntBlock.size() == add);
                numElems -= add;
                this.addIntBlock(this.currIntBlockEnd, nextIntBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextIntBlock);
                assert (this.currNode.block.size() == add);
                this.currIntBlockStart = this.currIntBlockEnd;
                this.currIntBlockEnd += add;
                this.size += add;
                --numIntBlocks;
            }
        }
        assert (oldSize + addLen == this.size);
        return true;
    }

    @Override
    protected void doClear() {
        this.finalize();
        this.rootNode = null;
        this.currIntBlockStart = 0;
        this.currIntBlockEnd = 0;
        this.currModify = 0;
        this.currNode = null;
        this.size = 0;
        this.doInit(this.blockSize, 0);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        if (len == 0) {
            return;
        }
        if (index == 0 && len == this.size) {
            this.doClear();
            return;
        }
        if (len == 1) {
            this.doRemove(index);
            return;
        }
        int startPos = this.getIntBlockIndex(index, true, 0);
        IntBlockNode startNode = this.currNode;
        int endPos = this.getIntBlockIndex(index + len - 1, true, 0);
        IntBlockNode endNode = this.currNode;
        if (startNode == endNode) {
            this.getIntBlockIndex(index, true, -len);
            this.currNode.block.remove(startPos, len);
            if (this.currNode.block.isEmpty()) {
                IntBlockNode oldCurrNode = this.currNode;
                this.releaseIntBlock();
                IntBlockNode node = this.doRemove(oldCurrNode);
                this.merge(node);
            } else {
                this.currIntBlockEnd -= len;
                this.merge(this.currNode);
            }
            this.size -= len;
        } else {
            int startLen = startNode.block.size() - startPos;
            this.getIntBlockIndex(index, true, -startLen);
            startNode.block.remove(startPos, startLen);
            assert (startNode == this.currNode);
            if (this.currNode.block.isEmpty()) {
                this.releaseIntBlock();
                this.doRemove(startNode);
                startNode = null;
            }
            len -= startLen;
            this.size -= startLen;
            while (len > 0) {
                this.currNode = null;
                this.getIntBlockIndex(index, true, 0);
                int s = this.currNode.block.size();
                if (s <= len) {
                    this.modify(this.currNode, -s);
                    IntBlockNode oldCurrNode = this.currNode;
                    this.releaseIntBlock();
                    this.doRemove(oldCurrNode);
                    if (oldCurrNode == endNode) {
                        endNode = null;
                    }
                    len -= s;
                    this.size -= s;
                    continue;
                }
                this.modify(this.currNode, -len);
                this.currNode.block.remove(0, len);
                this.size -= len;
                break;
            }
            this.releaseIntBlock();
            this.getIntBlockIndex(index, false, 0);
            this.merge(this.currNode);
        }
    }

    private void merge(IntBlockNode node) {
        if (node == null) {
            return;
        }
        int minIntBlockSize = Math.max((int)((float)this.blockSize * 0.35f), 1);
        if (node.block.size() >= minIntBlockSize) {
            return;
        }
        IntBlockNode oldCurrNode = node;
        IntBlockNode leftNode = node.previous();
        if (leftNode != null && leftNode.block.size() < minIntBlockSize) {
            int len = node.block.size();
            int dstSize = leftNode.getIntBlock().size();
            for (int i = 0; i < len; ++i) {
                leftNode.block.add(0);
            }
            IntGapList.transferCopy(node.block, 0, len, leftNode.block, dstSize, len);
            assert (leftNode.block.size() <= this.blockSize);
            this.modify(leftNode, len);
            this.modify(oldCurrNode, -len);
            this.releaseIntBlock();
            this.doRemove(oldCurrNode);
        } else {
            IntBlockNode rightNode = node.next();
            if (rightNode != null && rightNode.block.size() < minIntBlockSize) {
                int len = node.block.size();
                for (int i = 0; i < len; ++i) {
                    rightNode.block.add(0, 0);
                }
                IntGapList.transferCopy(node.block, 0, len, rightNode.block, 0, len);
                assert (rightNode.block.size() <= this.blockSize);
                this.modify(rightNode, len);
                this.modify(oldCurrNode, -len);
                this.releaseIntBlock();
                this.doRemove(oldCurrNode);
            }
        }
    }

    @Override
    protected int doRemove(int index) {
        int pos2 = this.getIntBlockIndex(index, true, -1);
        int oldElem = this.currNode.block.doRemove(pos2);
        --this.currIntBlockEnd;
        int minIntBlockSize = Math.max(this.blockSize / 3, 1);
        if (this.currNode.block.size() < minIntBlockSize) {
            if (this.currNode.block.size() == 0) {
                if (!this.isOnlyRootIntBlock()) {
                    IntBlockNode oldCurrNode = this.currNode;
                    this.releaseIntBlock();
                    this.doRemove(oldCurrNode);
                }
            } else if (index != 0 && index != this.size - 1) {
                this.merge(this.currNode);
            }
        }
        --this.size;
        return oldElem;
    }

    @Override
    public IntBigList unmodifiableList() {
        return new ImmutableIntBigList(this);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        if (this.isOnlyRootIntBlock()) {
            if (minCapacity > this.blockSize) {
                minCapacity = this.blockSize;
            }
            this.rootNode.block.doEnsureCapacity(minCapacity);
        }
    }

    @Override
    public void trimToSize() {
        this.doModify();
        if (this.isOnlyRootIntBlock()) {
            this.rootNode.block.trimToSize();
        } else {
            IntBigList newList = new IntBigList(this.blockSize);
            IntBlockNode node = this.rootNode.min();
            while (node != null) {
                newList.addAll(node.block);
                this.remove(0, node.block.size());
                node = node.next();
            }
            this.doAssign(newList);
        }
    }

    @Override
    protected IIntList doCreate(int capacity) {
        if (capacity <= this.blockSize) {
            return new IntBigList(this.blockSize);
        }
        return new IntBigList(this.blockSize, capacity);
    }

    @Override
    public void sort(int index, int len) {
        this.checkRange(index, len);
        if (this.isOnlyRootIntBlock()) {
            this.rootNode.block.sort(index, len);
        } else {
            IntMergeSort.sort(this, index, index + len);
        }
    }

    @Override
    public int binarySearch(int index, int len, int key) {
        this.checkRange(index, len);
        if (this.isOnlyRootIntBlock()) {
            return this.rootNode.block.binarySearch(key);
        }
        return IntBinarySearch.binarySearch(this, key, 0, this.size());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.blockSize);
        int size2 = this.size();
        oos.writeInt(size2);
        for (int i = 0; i < size2; ++i) {
            oos.writeInt(this.doGet(i));
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int blockSize = ois.readInt();
        int size2 = ois.readInt();
        int firstIntBlockSize = size2 <= blockSize ? size2 : -1;
        this.doInit(blockSize, firstIntBlockSize);
        for (int i = 0; i < size2; ++i) {
            this.add(ois.readInt());
        }
    }

    private void checkNode(IntBlockNode node) {
        assert ((node.block.size() > 0 || node == this.rootNode) && node.block.size() <= this.blockSize);
        IntBlockNode child = node.getLeftSubTree();
        assert (child == null || child.parent == node);
        child = node.getRightSubTree();
        assert (child == null || child.parent == node);
    }

    private void checkHeight(IntBlockNode node) {
        IntBlockNode left = node.getLeftSubTree();
        IntBlockNode right = node.getRightSubTree();
        if (left == null) {
            if (right == null) {
                assert (node.height == 0);
            } else {
                assert (right.height == node.height - 1);
                this.checkHeight(right);
            }
        } else {
            if (right == null) {
                assert (left.height == node.height - 1);
            } else {
                assert (left.height == node.height - 1 || left.height == node.height - 2);
                assert (right.height == node.height - 1 || right.height == node.height - 2);
                assert (right.height == node.height - 1 || left.height == node.height - 1);
            }
            this.checkHeight(left);
        }
    }

    private void check() {
        if (this.currNode != null) {
            assert (this.currIntBlockStart >= 0 && this.currIntBlockEnd <= this.size && this.currIntBlockStart <= this.currIntBlockEnd);
            assert (this.currIntBlockStart + this.currNode.block.size() == this.currIntBlockEnd);
        }
        if (this.rootNode == null) {
            assert (this.size == 0);
            return;
        }
        this.checkHeight(this.rootNode);
        IntBlockNode oldCurrNode = this.currNode;
        int oldCurrModify = this.currModify;
        if (this.currModify != 0) {
            this.currNode = null;
            this.currModify = 0;
            this.modify(oldCurrNode, oldCurrModify);
        }
        IntBlockNode node = this.rootNode;
        this.checkNode(node);
        int index = node.relPos;
        while (node.left != null) {
            node = node.left;
            this.checkNode(node);
            assert (node.relPos < 0);
            index += node.relPos;
        }
        IntBlock block = node.getIntBlock();
        assert (block.size() == index);
        int lastIndex = index;
        while (lastIndex < this.size()) {
            node = this.rootNode;
            index = node.relPos;
            int searchIndex = lastIndex + 1;
            while (true) {
                this.checkNode(node);
                block = node.getIntBlock();
                assert (block.size() > 0);
                if (searchIndex > index - block.size() && searchIndex <= index) break;
                if (searchIndex < index) {
                    if (node.left == null || node.left.height >= node.height) break;
                    node = node.left;
                } else {
                    if (node.right == null || node.right.height >= node.height) break;
                    node = node.right;
                }
                index += node.relPos;
            }
            block = node.getIntBlock();
            assert (block.size() == index - lastIndex);
            lastIndex = index;
        }
        assert (index == this.size());
        if (oldCurrModify != 0) {
            this.modify(oldCurrNode, -oldCurrModify);
        }
        this.currNode = oldCurrNode;
        this.currModify = oldCurrModify;
    }

    protected static class ImmutableIntBigList
    extends IntBigList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableIntBigList(IntBigList that) {
            super(true, that);
        }

        @Override
        protected boolean doAdd(int index, int elem) {
            this.error();
            return false;
        }

        @Override
        protected int doSet(int index, int elem) {
            this.error();
            return 0;
        }

        @Override
        protected int doReSet(int index, int elem) {
            this.error();
            return 0;
        }

        @Override
        protected int doRemove(int index) {
            this.error();
            return 0;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }

    static class IntBlockNode {
        IntBlockNode parent;
        IntBlockNode left;
        boolean leftIsPrevious;
        IntBlockNode right;
        boolean rightIsNext;
        int height;
        int relPos;
        IntBlock block;

        private IntBlockNode(IntBlockNode parent2, int relPos, IntBlock block, IntBlockNode rightFollower, IntBlockNode leftFollower) {
            this.parent = parent2;
            this.relPos = relPos;
            this.block = block;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
        }

        private IntBlock getIntBlock() {
            return this.block;
        }

        private void setIntBlock(IntBlock block) {
            this.block = block;
        }

        private IntBlockNode next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return this.right.min();
        }

        private IntBlockNode previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return this.left.max();
        }

        private IntBlockNode insert(int index, IntBlock obj) {
            assert (this.relPos != 0);
            int relIndex = index - this.relPos;
            if (relIndex < 0) {
                return this.insertOnLeft(relIndex, obj);
            }
            return this.insertOnRight(relIndex, obj);
        }

        private IntBlockNode insertOnLeft(int relIndex, IntBlock obj) {
            if (this.getLeftSubTree() == null) {
                int pos2 = this.relPos >= 0 ? -this.relPos : -this.block.size();
                this.setLeft(new IntBlockNode(this, pos2, obj, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(relIndex, obj), null);
            }
            if (this.relPos >= 0) {
                this.relPos += obj.size();
            }
            IntBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private IntBlockNode insertOnRight(int relIndex, IntBlock obj) {
            if (this.getRightSubTree() == null) {
                this.setRight(new IntBlockNode(this, obj.size(), obj, this.right, this), null);
            } else {
                this.setRight(this.right.insert(relIndex, obj), null);
            }
            if (this.relPos < 0) {
                this.relPos -= obj.size();
            }
            IntBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private IntBlockNode getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private IntBlockNode getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private IntBlockNode max() {
            return this.getRightSubTree() == null ? this : this.right.max();
        }

        private IntBlockNode min() {
            return this.getLeftSubTree() == null ? this : this.left.min();
        }

        private IntBlockNode removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(this.right.removeMax(), this.right.right);
            this.recalcHeight();
            return this.balance();
        }

        private IntBlockNode removeMin(int size2) {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(this.left.removeMin(size2), this.left.left);
            if (this.relPos > 0) {
                this.relPos -= size2;
            }
            this.recalcHeight();
            return this.balance();
        }

        private IntBlockNode removeSelf() {
            IntBlockNode p = this.parent;
            IntBlockNode n = this.doRemoveSelf();
            if (n != null) {
                assert (p != n);
                n.parent = p;
            }
            return n;
        }

        private IntBlockNode doRemoveSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                this.left.relPos = this.relPos > 0 ? this.left.relPos + (this.relPos + (this.relPos > 0 ? 0 : 1)) : (this.left.relPos += this.relPos);
                this.left.max().setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                if (this.relPos < 0) {
                    this.right.relPos = this.right.relPos + (this.relPos - (this.relPos < 0 ? 0 : 1));
                }
                this.right.min().setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                IntBlockNode rightMin = this.right.min();
                this.block = rightMin.block;
                int bs = this.block.size();
                if (this.leftIsPrevious) {
                    this.left = rightMin.left;
                }
                this.right = this.right.removeMin(bs);
                this.relPos += bs;
                this.left.relPos -= bs;
            } else {
                IntBlockNode leftMax = this.left.max();
                this.block = leftMax.block;
                if (this.rightIsNext) {
                    this.right = leftMax.right;
                }
                IntBlockNode leftPrevious = this.left.left;
                this.left = this.left.removeMax();
                if (this.left == null) {
                    this.left = leftPrevious;
                    this.leftIsPrevious = true;
                } else if (this.left.relPos == 0) {
                    this.left.relPos = -1;
                }
            }
            this.recalcHeight();
            return this;
        }

        private IntBlockNode balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (this.left.heightRightMinusLeft() > 0) {
                        this.setLeft(this.left.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (this.right.heightRightMinusLeft() < 0) {
                        this.setRight(this.right.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(IntBlockNode node) {
            if (node == null) {
                return 0;
            }
            return node.relPos;
        }

        private int setOffset(IntBlockNode node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int oldOffset = this.getOffset(node);
            node.relPos = newOffest;
            return oldOffset;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(IntBlockNode node) {
            return node == null ? -1 : node.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private IntBlockNode rotateLeft() {
            assert (!this.rightIsNext);
            IntBlockNode newTop = this.right;
            IntBlockNode movedNode = this.getRightSubTree().getLeftSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            IntBlockNode p = this.parent;
            this.setRight(movedNode, newTop);
            newTop.setLeft(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private IntBlockNode rotateRight() {
            assert (!this.leftIsPrevious);
            IntBlockNode newTop = this.left;
            IntBlockNode movedNode = this.getLeftSubTree().getRightSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            IntBlockNode p = this.parent;
            this.setLeft(movedNode, newTop);
            newTop.setRight(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private void setLeft(IntBlockNode node, IntBlockNode previous) {
            assert (node != this && previous != this);
            boolean bl = this.leftIsPrevious = node == null;
            if (this.leftIsPrevious) {
                this.left = previous;
            } else {
                this.left = node;
                this.left.parent = this;
            }
            this.recalcHeight();
        }

        private void setRight(IntBlockNode node, IntBlockNode next) {
            assert (node != this && next != this);
            boolean bl = this.rightIsNext = node == null;
            if (this.rightIsNext) {
                this.right = next;
            } else {
                this.right = node;
                this.right.parent = this;
            }
            this.recalcHeight();
        }

        public String toString() {
            return "IntBlockNode(" + this.relPos + ',' + (this.getRightSubTree() != null) + ',' + this.block + ',' + (this.getRightSubTree() != null) + ", height " + this.height + " )";
        }
    }

    static class IntBlock
    extends IntGapList {
        private AtomicInteger refCount = new AtomicInteger(1);

        public IntBlock() {
        }

        public IntBlock(int capacity) {
            super(capacity);
        }

        public IntBlock(IntBlock that) {
            super(that.capacity());
            this.addAll(that);
        }

        public boolean isShared() {
            return this.refCount.get() > 1;
        }

        public IntBlock ref() {
            this.refCount.incrementAndGet();
            return this;
        }

        public void unref() {
            this.refCount.decrementAndGet();
        }
    }

    protected static abstract class ImmutableIntList
    extends IIntList {
        protected ImmutableIntList() {
        }

        @Override
        public int capacity() {
            return this.size();
        }

        @Override
        public int binarySearch(int index, int len, int key) {
            return IntBinarySearch.binarySearch(this, key, index, index + len);
        }

        @Override
        public IIntList unmodifiableList() {
            return this;
        }

        @Override
        protected int getDefaultElem() {
            return 0;
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        @Override
        protected void doClone(IIntList that) {
            this.error();
        }

        @Override
        protected int doSet(int index, int elem) {
            this.error();
            return 0;
        }

        @Override
        protected int doReSet(int index, int elem) {
            this.error();
            return 0;
        }

        @Override
        protected boolean doAdd(int index, int elem) {
            this.error();
            return false;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IIntList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IIntList that) {
            this.error();
        }

        @Override
        protected int doRemove(int index) {
            this.error();
            return 0;
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }
    }

    static class ImmutableIntListList
    extends ImmutableIntList {
        List<Integer> values;

        public ImmutableIntListList(List<Integer> values2) {
            this.values = values2;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        protected int doGet(int index) {
            return this.values.get(index);
        }
    }

    static class ImmutableIntListArrayWrapper
    extends ImmutableIntList {
        Integer[] values;

        public ImmutableIntListArrayWrapper(Integer[] values2) {
            this.values = values2;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected int doGet(int index) {
            return this.values[index];
        }
    }

    static class ImmutableIntListArrayPrimitive
    extends ImmutableIntList {
        int[] values;

        public ImmutableIntListArrayPrimitive(int[] values2) {
            this.values = values2;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected int doGet(int index) {
            return this.values[index];
        }
    }
}

