/*
 * Decompiled with CFR 0.152.
 */
package com.yyon.grapplinghook;

import com.yyon.grapplinghook.GrappleCustomization;
import com.yyon.grapplinghook.blocks.TileEntityGrappleModifier;
import com.yyon.grapplinghook.grapplemod;
import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiSlider;

public class GuiModifier
extends GuiScreen {
    private static final ResourceLocation texture = new ResourceLocation("grapplemod", "textures/gui/guimodifier_bg.png");
    int xSize = 221;
    int ySize = 221;
    protected int guiLeft;
    protected int guiTop;
    int posy;
    int id;
    HashMap<GuiButton, String> options;
    HashMap<GuiButton, String> tooltips;
    TileEntityGrappleModifier tileent;
    GrappleCustomization customization;
    grapplemod.upgradeCategories category = null;
    boolean allowed = false;
    boolean showinghelpscreen = false;
    GuiButton buttonpressed = null;

    public GuiModifier(TileEntityGrappleModifier tileent) {
        this.tileent = tileent;
        this.customization = tileent.customization;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.clearscreen();
        this.mainscreen();
    }

    public void mainscreen() {
        this.field_146292_n.add(new GuiButton(1, this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10, 50, 20, grapplemod.proxy.localize("grapplemodifier.close.desc")));
        this.field_146292_n.add(new GuiButton(2, this.guiLeft + this.xSize - 50 - 10, this.guiTop + this.ySize - 20 - 10, 50, 20, grapplemod.proxy.localize("grapplemodifier.reset.desc")));
        this.field_146292_n.add(new GuiButton(4, this.guiLeft + 10 + 75, this.guiTop + this.ySize - 20 - 10, 50, 20, grapplemod.proxy.localize("grapplemodifier.helpbutton.desc")));
        int y = 0;
        int x = 0;
        for (int i = 0; i < grapplemod.upgradeCategories.size(); ++i) {
            grapplemod.upgradeCategories category = grapplemod.upgradeCategories.fromInt(i);
            if (category == grapplemod.upgradeCategories.LIMITS) continue;
            if (i == grapplemod.upgradeCategories.size() / 2) {
                y = 0;
                ++x;
            }
            this.field_146292_n.add(new GuiButton(99 + i, this.guiLeft + 10 + 105 * x, this.guiTop + 15 + 30 * y, 95, 20, category.description));
            ++y;
        }
    }

    public void clearscreen() {
        this.field_146292_n.clear();
        this.category = null;
        this.allowed = false;
        this.posy = 10;
        this.id = 10;
        this.options = new HashMap();
        this.tooltips = new HashMap();
    }

    public void notAllowedScreen(grapplemod.upgradeCategories category) {
        this.field_146292_n.add(new GuiButton(3, this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10, 50, 20, grapplemod.proxy.localize("grapplemodifier.back.desc")));
        this.category = category;
        this.allowed = false;
    }

    public void helpscreen() {
        this.field_146292_n.add(new GuiButton(3, this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10, 50, 20, grapplemod.proxy.localize("grapplemodifier.back.desc")));
    }

    public void addCheckbox(String option) {
        String text = grapplemod.proxy.localize(this.customization.getName(option));
        String desc = grapplemod.proxy.localize(this.customization.getDescription(option));
        GuiCheckBox checkbox = new GuiCheckBox(this.id++, 10 + this.guiLeft, this.posy + this.guiTop, text, this.customization.getBoolean(option));
        this.posy += 20;
        this.field_146292_n.add(checkbox);
        this.options.put((GuiButton)checkbox, option);
        this.tooltips.put((GuiButton)checkbox, desc);
    }

    public void addSlider(String option) {
        double d = this.customization.getDouble(option);
        d = Math.floor(d * 10.0 + 0.5) / 10.0;
        double max = this.customization.getMax(option, this.getLimits());
        double min = this.customization.getMin(option, this.getLimits());
        String text = grapplemod.proxy.localize(this.customization.getName(option));
        GuiSlider slider = new GuiSlider(this.id++, 10 + this.guiLeft, this.posy + this.guiTop, this.xSize - 20, 20, text + ": ", "", min, max, d, true, true);
        slider.field_146126_j = text + ": " + Double.toString(d);
        slider.precision = 1;
        this.posy += 25;
        this.field_146292_n.add(slider);
        this.options.put((GuiButton)slider, option);
        String desc = grapplemod.proxy.localize(this.customization.getDescription(option));
        this.tooltips.put((GuiButton)slider, desc);
    }

    public void showCategoryScreen(grapplemod.upgradeCategories category) {
        this.field_146292_n.add(new GuiButton(3, this.guiLeft + 10, this.guiTop + this.ySize - 20 - 10, 50, 20, grapplemod.proxy.localize("grapplemodifier.back.desc")));
        this.category = category;
        this.allowed = true;
        if (category == grapplemod.upgradeCategories.ROPE) {
            this.addSlider("maxlen");
            this.addCheckbox("phaserope");
            this.addCheckbox("sticky");
        } else if (category == grapplemod.upgradeCategories.THROW) {
            this.addSlider("hookgravity");
            this.addSlider("throwspeed");
            this.addCheckbox("reelin");
            this.addSlider("verticalthrowangle");
            this.addSlider("sneakingverticalthrowangle");
            this.addCheckbox("detachonkeyrelease");
        } else if (category == grapplemod.upgradeCategories.MOTOR) {
            this.addCheckbox("motor");
            this.addSlider("motormaxspeed");
            this.addSlider("motoracceleration");
            this.addCheckbox("motorwhencrouching");
            this.addCheckbox("motorwhennotcrouching");
            this.addCheckbox("smartmotor");
            this.addCheckbox("motordampener");
            this.addCheckbox("pullbackwards");
        } else if (category == grapplemod.upgradeCategories.SWING) {
            this.addSlider("playermovementmult");
        } else if (category == grapplemod.upgradeCategories.STAFF) {
            this.addCheckbox("enderstaff");
        } else if (category == grapplemod.upgradeCategories.FORCEFIELD) {
            this.addCheckbox("repel");
            this.addSlider("repelforce");
        } else if (category == grapplemod.upgradeCategories.MAGNET) {
            this.addCheckbox("attract");
            this.addSlider("attractradius");
        } else if (category == grapplemod.upgradeCategories.DOUBLE) {
            this.addCheckbox("doublehook");
            this.addCheckbox("smartdoublemotor");
            this.addSlider("angle");
            this.addSlider("sneakingangle");
            this.addCheckbox("oneropepull");
        } else if (category == grapplemod.upgradeCategories.ROCKET) {
            this.addCheckbox("rocket");
            this.addSlider("rocket_force");
            this.addSlider("rocket_active_time");
            this.addSlider("rocket_refuel_ratio");
            this.addSlider("rocket_vertical_angle");
        }
        this.updateEnabled();
    }

    public void func_146281_b() {
        this.updateOptions();
        this.tileent.setCustomizationClient(this.customization);
        super.func_146281_b();
    }

    public void updateOptions() {
        for (GuiButton b : this.options.keySet()) {
            this.updateOption(b);
        }
    }

    public void updateOption(GuiButton b) {
        if (b instanceof GuiCheckBox) {
            boolean checked = ((GuiCheckBox)b).isChecked();
            String option = this.options.get(b);
            this.customization.setBoolean(option, checked);
        } else if (b instanceof GuiSlider) {
            double d = ((GuiSlider)b).getValue();
            d = Math.floor(d * 10.0 + 0.5) / 10.0;
            String option = this.options.get(b);
            this.customization.setDouble(option, d);
        }
        this.updateEnabled();
    }

    public void updateEnabled() {
        for (GuiButton b : this.options.keySet()) {
            String option = this.options.get(b);
            boolean enabled = true;
            String desc = grapplemod.proxy.localize(this.customization.getDescription(option));
            if (!this.customization.isoptionvalid(option)) {
                desc = grapplemod.proxy.localize("grapplemodifier.incompatability.desc") + "\n" + desc;
                enabled = false;
            }
            int level = this.customization.optionEnabled(option);
            if (this.getLimits() < level) {
                desc = level == 1 ? grapplemod.proxy.localize("grapplemodifier.limits.desc") + "\n" + desc : grapplemod.proxy.localize("grapplemodifier.locked.desc") + "\n" + desc;
                enabled = false;
            }
            b.field_146124_l = enabled;
            this.tooltips.put(b, desc);
        }
    }

    public int getLimits() {
        if (this.tileent.isUnlocked(grapplemod.upgradeCategories.LIMITS) || Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d) {
            return 1;
        }
        return 0;
    }

    public void func_73876_c() {
        if (this.buttonpressed != null) {
            GuiButton b = this.buttonpressed;
            this.buttonpressed = null;
            if (b.field_146127_k == 1) {
                Minecraft.func_71410_x().field_71439_g.func_71053_j();
                return;
            }
            if (b.field_146127_k == 2) {
                this.customization = new GrappleCustomization();
            } else if (b.field_146127_k == 3) {
                this.showinghelpscreen = false;
                this.updateOptions();
                this.clearscreen();
                this.mainscreen();
            } else if (b.field_146127_k == 4) {
                this.showinghelpscreen = true;
                this.clearscreen();
                this.helpscreen();
            } else if (this.options.containsKey(b)) {
                this.updateOption(b);
            } else {
                boolean unlocked;
                int categoryid = b.field_146127_k - 99;
                grapplemod.upgradeCategories category = grapplemod.upgradeCategories.fromInt(categoryid);
                this.clearscreen();
                boolean bl = unlocked = this.tileent.isUnlocked(category) || Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d;
                if (unlocked) {
                    this.showCategoryScreen(category);
                } else {
                    this.notAllowedScreen(category);
                }
            }
        }
        super.func_73876_c();
    }

    protected void func_146284_a(GuiButton b) {
        this.buttonpressed = b;
        try {
            super.func_146284_a(b);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (this.field_146289_q == null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        GlStateManager.func_179109_b((float)this.guiLeft, (float)this.guiTop, (float)0.0f);
        if (this.category != null) {
            if (!this.allowed) {
                this.field_146289_q.func_78276_b(grapplemod.proxy.localize("grapplemodifier.unlock1.desc"), 10, 10, Color.darkGray.getRGB());
                this.field_146289_q.func_78276_b(this.category.description, 10, 25, Color.darkGray.getRGB());
                this.field_146289_q.func_78276_b(grapplemod.proxy.localize("grapplemodifier.unlock2.desc"), 10, 40, Color.darkGray.getRGB());
                this.field_146289_q.func_78276_b(grapplemod.proxy.localize("grapplemodifier.unlock3.desc"), 10, 55, Color.darkGray.getRGB());
                this.field_146289_q.func_78276_b(new ItemStack(this.category.getItem()).func_82833_r(), 10, 70, Color.darkGray.getRGB());
                this.field_146289_q.func_78276_b(grapplemod.proxy.localize("grapplemodifier.unlock4.desc"), 10, 85, Color.darkGray.getRGB());
            }
        } else if (this.showinghelpscreen) {
            String helptext = grapplemod.proxy.localize("grapplemodifier.help.desc");
            int linenum = 0;
            for (String line : helptext.split(Pattern.quote("\\n"))) {
                this.field_146289_q.func_78276_b(line, 10, 10 + 15 * linenum, Color.darkGray.getRGB());
                ++linenum;
            }
        } else {
            this.field_146289_q.func_78276_b(grapplemod.proxy.localize("grapplemodifier.apply.desc"), 10, this.ySize - 20 - 10 - 10, Color.darkGray.getRGB());
        }
        GlStateManager.func_179109_b((float)(-this.guiLeft), (float)(-this.guiTop), (float)0.0f);
        GlStateManager.func_179101_C();
        RenderHelper.func_74518_a();
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
        GlStateManager.func_179091_B();
        RenderHelper.func_74519_b();
        for (GuiButton b : this.tooltips.keySet()) {
            if (mouseX < b.field_146128_h || mouseY < b.field_146129_i || mouseX > b.field_146128_h + b.field_146120_f || mouseY > b.field_146129_i + b.field_146121_g) continue;
            this.func_146279_a(this.tooltips.get(b), mouseX, mouseY);
        }
    }
}

