/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.proxy;

import java.util.ArrayList;
import java.util.List;
import mirror.normalasm.NormalLogger;
import mirror.normalasm.bakedquad.NormalVertexDataPool;
import mirror.normalasm.client.models.bucket.NormalBakedDynBucket;
import mirror.normalasm.client.screenshot.ScreenshotListener;
import mirror.normalasm.client.sprite.FramesTextureData;
import mirror.normalasm.common.modfixes.qmd.QMDEventHandler;
import mirror.normalasm.config.NormalConfig;
import mirror.normalasm.core.NormalTransformer;
import mirror.normalasm.proxy.CommonProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="normalasm", value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    public static final List<Runnable> refreshAfterModels = new ArrayList<Runnable>();

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        if (NormalConfig.instance.releaseSpriteFramesCache) {
            MinecraftForge.EVENT_BUS.register(FramesTextureData.class);
        }
        if (Loader.isModLoaded((String)"qmd") && NormalConfig.instance.optimizeQMDBeamRenderer) {
            MinecraftForge.EVENT_BUS.register(QMDEventHandler.class);
        }
        if (NormalConfig.instance.copyScreenshotToClipboard) {
            MinecraftForge.EVENT_BUS.register(ScreenshotListener.class);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        if (!Loader.isModLoaded((String)"jei")) {
            this.releaseSpriteFramesCache();
        }
    }

    @Override
    public void loadComplete(FMLLoadCompleteEvent event) {
        super.loadComplete(event);
        if (Loader.isModLoaded((String)"jei")) {
            this.releaseSpriteFramesCache();
        }
        if (!NormalTransformer.isOptifineInstalled && NormalConfig.instance.vertexDataCanonicalization) {
            NormalLogger.instance.info("{} total quads processed. {} unique vertex data array in NormalVertexDataPool, {} vertex data arrays deduplicated altogether during game load.", (Object)NormalVertexDataPool.getDeduplicatedCount(), (Object)NormalVertexDataPool.getSize(), (Object)(NormalVertexDataPool.getDeduplicatedCount() - NormalVertexDataPool.getSize()));
            MinecraftForge.EVENT_BUS.register(NormalVertexDataPool.class);
        }
    }

    private void releaseSpriteFramesCache() {
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)((ISelectiveResourceReloadListener)(manager, predicate) -> {
            if (predicate.test(VanillaResourceType.MODELS)) {
                refreshAfterModels.forEach(Runnable::run);
                if (NormalConfig.instance.reuseBucketQuads) {
                    NormalBakedDynBucket.baseQuads.clear();
                    NormalBakedDynBucket.flippedBaseQuads.clear();
                    NormalBakedDynBucket.coverQuads.clear();
                    NormalBakedDynBucket.flippedCoverQuads.clear();
                }
                if (!NormalTransformer.isOptifineInstalled && NormalConfig.instance.vertexDataCanonicalization) {
                    NormalVertexDataPool.invalidate();
                }
            }
        }));
    }
}

