/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.common.internal.mixins;

import com.google.common.base.Strings;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.logging.log4j.ThreadContext;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={LoadController.class}, priority=-1000, remap=false)
public abstract class LoadControllerMixin {
    @Shadow(remap=false)
    private ModContainer activeContainer;

    @Shadow(remap=false)
    @Nullable
    protected abstract ModContainer findActiveContainerFromStack();

    @Nullable
    @Overwrite
    public ModContainer activeContainer() {
        if (this.activeContainer == null) {
            String modId = ThreadContext.get((String)"mod");
            if (Strings.isNullOrEmpty((String)modId)) {
                return this.findActiveContainerFromStack();
            }
            ModContainer container = (ModContainer)Loader.instance().getIndexedModList().get(modId);
            return container == null ? this.findActiveContainerFromStack() : container;
        }
        return this.activeContainer;
    }
}

