/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.common.crashes.mixins;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import mirror.normalasm.NormalASM;
import mirror.normalasm.NormalLogger;
import mirror.normalasm.common.crashes.CrashUtils;
import mirror.normalasm.common.crashes.GuiCrashScreen;
import mirror.normalasm.common.crashes.GuiInitErrorScreen;
import mirror.normalasm.common.crashes.GuiWarningScreen;
import mirror.normalasm.common.crashes.IMinecraftExtender;
import mirror.normalasm.common.crashes.IStateful;
import mirror.normalasm.common.crashes.ProblemToast;
import mirror.normalasm.config.NormalConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.FileResourcePack;
import net.minecraft.client.resources.FolderResourcePack;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.IResourcePack;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.client.resources.data.MetadataSerializer;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.crash.CrashReport;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.MinecraftError;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.fml.client.SplashProgress;
import org.apache.logging.log4j.Logger;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GLContext;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MinecraftMixin
implements IMinecraftExtender {
    @Shadow
    public static byte[] field_71444_a;
    @Shadow
    @Final
    private static Logger field_147123_G;
    @Shadow
    @Final
    private List<IResourcePack> field_110449_ao;
    @Shadow
    @Final
    private MetadataSerializer field_110452_an;
    @Shadow
    @Final
    private Queue<FutureTask<?>> field_152351_aB;
    @Shadow
    public TextureManager field_71446_o;
    @Shadow
    public GameSettings field_71474_y;
    @Shadow
    public FontRenderer field_71466_p;
    @Shadow
    public EntityRenderer field_71460_t;
    @Shadow
    @Nullable
    public GuiScreen field_71462_r;
    @Shadow
    public int field_71443_c;
    @Shadow
    public int field_71440_d;
    @Shadow
    public GuiIngame field_71456_v;
    @Shadow
    volatile boolean field_71425_J;
    @Shadow
    private boolean field_71434_R;
    @Shadow
    private CrashReport field_71433_S;
    @Shadow
    private SoundHandler field_147127_av;
    @Shadow
    private LanguageManager field_135017_as;
    @Shadow
    private IReloadableResourceManager field_110451_am;
    @Shadow
    private int field_71429_W;
    @Shadow
    private Framebuffer field_147124_at;
    @Shadow
    private long field_83002_am;
    @Shadow
    private boolean field_184129_aV;
    @Shadow
    private boolean field_71455_al;
    @Shadow
    @Nullable
    private IntegratedServer field_71437_Z;
    @Unique
    private boolean crashIntegratedServerNextTick;
    @Unique
    private int clientCrashCount = 0;
    @Unique
    private int serverCrashCount = 0;
    @Unique
    @Nullable
    private Class<?> customMainMenuGuiCustomClass = null;

    @Shadow
    public static long func_71386_F() {
        throw new AssertionError();
    }

    @Shadow
    public abstract void func_71405_e();

    @Shadow
    public abstract CrashReport func_71396_d(CrashReport var1);

    @Shadow
    public abstract void func_175601_h();

    @Shadow
    public abstract void func_147108_a(@Nullable GuiScreen var1);

    @Shadow
    public abstract void func_71403_a(@Nullable WorldClient var1);

    @Shadow
    @Deprecated
    public abstract void func_110436_a();

    @Shadow
    @Nullable
    public abstract NetHandlerPlayClient func_147114_u();

    @Shadow
    protected abstract void func_71384_a() throws LWJGLException, IOException;

    @Shadow
    protected abstract void func_71411_J() throws IOException;

    @Shadow
    protected abstract void func_71361_d(String var1);

    @Shadow
    public abstract GuiToast func_193033_an();

    @Shadow
    public abstract ListenableFuture<Object> func_152344_a(Runnable var1);

    private static void resetGlStates() {
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)6144);
        GlStateManager.func_179096_D();
        GlStateManager.func_179144_i((int)0);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GlStateManager.func_187424_a((int)2899, (FloatBuffer)RenderHelper.func_74521_a((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f));
        for (int i = 0; i < 8; ++i) {
            GlStateManager.func_179122_b((int)i);
            GlStateManager.func_187438_a((int)(16384 + i), (int)4608, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
            GlStateManager.func_187438_a((int)(16384 + i), (int)4611, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f));
            if (i == 0) {
                GlStateManager.func_187438_a((int)(16384 + i), (int)4609, (FloatBuffer)RenderHelper.func_74521_a((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
                GlStateManager.func_187438_a((int)(16384 + i), (int)4610, (FloatBuffer)RenderHelper.func_74521_a((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f));
                continue;
            }
            GlStateManager.func_187438_a((int)(16384 + i), (int)4609, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
            GlStateManager.func_187438_a((int)(16384 + i), (int)4610, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        }
        GlStateManager.func_179119_h();
        GlStateManager.func_179104_a((int)1032, (int)5634);
        GlStateManager.func_179097_i();
        GlStateManager.func_179143_c((int)513);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_187398_d((int)32774);
        GlStateManager.func_179106_n();
        GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.LINEAR);
        GlStateManager.func_179095_a((float)1.0f);
        GlStateManager.func_179102_b((float)0.0f);
        GlStateManager.func_179153_c((float)1.0f);
        GlStateManager.func_187402_b((int)2918, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        if (GLContext.getCapabilities().GL_NV_fog_distance) {
            GlStateManager.func_187412_c((int)2917, (int)34140);
        }
        GlStateManager.func_179136_a((float)0.0f, (float)0.0f);
        GlStateManager.func_179113_r();
        GlStateManager.func_179134_v();
        GlStateManager.func_179116_f((int)5379);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.S);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.T);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.R);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.Q);
        GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9216);
        GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9216);
        GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9216);
        GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.Q, (int)9216);
        GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9474, (FloatBuffer)RenderHelper.func_74521_a((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9474, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f));
        GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9474, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f));
        GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.Q, (int)9474, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9217, (FloatBuffer)RenderHelper.func_74521_a((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9217, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f));
        GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9217, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f));
        GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.Q, (int)9217, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f));
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
        GlStateManager.func_187421_b((int)3553, (int)10240, (int)9729);
        GlStateManager.func_187421_b((int)3553, (int)10241, (int)9986);
        GlStateManager.func_187421_b((int)3553, (int)10242, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)10243, (int)10497);
        GlStateManager.func_187421_b((int)3553, (int)33085, (int)1000);
        GlStateManager.func_187421_b((int)3553, (int)33083, (int)1000);
        GlStateManager.func_187421_b((int)3553, (int)33082, (int)-1000);
        GlStateManager.func_187403_b((int)3553, (int)34049, (float)0.0f);
        GlStateManager.func_187399_a((int)8960, (int)8704, (int)8448);
        GlStateManager.func_187448_b((int)8960, (int)8705, (FloatBuffer)RenderHelper.func_74521_a((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        GlStateManager.func_187399_a((int)8960, (int)34161, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)34162, (int)8448);
        GlStateManager.func_187399_a((int)8960, (int)34176, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)34177, (int)34168);
        GlStateManager.func_187399_a((int)8960, (int)34178, (int)34166);
        GlStateManager.func_187399_a((int)8960, (int)34184, (int)5890);
        GlStateManager.func_187399_a((int)8960, (int)34185, (int)34168);
        GlStateManager.func_187399_a((int)8960, (int)34186, (int)34166);
        GlStateManager.func_187399_a((int)8960, (int)34192, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)34193, (int)768);
        GlStateManager.func_187399_a((int)8960, (int)34194, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)34200, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)34201, (int)770);
        GlStateManager.func_187399_a((int)8960, (int)34202, (int)770);
        GlStateManager.func_187436_a((int)8960, (int)34163, (float)1.0f);
        GlStateManager.func_187436_a((int)8960, (int)3356, (float)1.0f);
        GlStateManager.func_179133_A();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179101_C();
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179151_a((double)1.0);
        GlStateManager.func_187441_d((float)1.0f);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_187409_d((int)1028, (int)6914);
        GlStateManager.func_187409_d((int)1029, (int)6914);
        GlStateManager.func_179098_w();
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179151_a((double)1.0);
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
    }

    @Override
    public boolean shouldCrashIntegratedServerNextTick() {
        return this.crashIntegratedServerNextTick;
    }

    @Override
    public void showWarningScreen(CrashReport report) {
        this.func_152344_a(() -> this.func_147108_a(new GuiWarningScreen(report, this.field_71462_r)));
    }

    @Override
    public void makeErrorNotification(CrashReport report) {
        if (!NormalConfig.instance.hideToastsAndContinuePlaying) {
            ProblemToast lastToast = (ProblemToast)this.func_193033_an().func_192990_a(ProblemToast.class, IToast.field_193655_b);
            if (lastToast != null) {
                lastToast.hide = true;
            }
            this.func_193033_an().func_192988_a((IToast)new ProblemToast(report));
        }
    }

    @Overwrite
    public void func_99999_d() {
        this.field_71425_J = true;
        try {
            this.func_71384_a();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Initializing game");
            this.displayInitErrorScreen(this.func_71396_d(crashreport));
            return;
        }
        try {
            while (this.field_71425_J) {
                if (!this.field_71434_R || this.field_71433_S == null) {
                    try {
                        this.func_71411_J();
                    }
                    catch (ReportedException e) {
                        ++this.clientCrashCount;
                        this.func_71396_d(e.func_71575_a());
                        this.addInfoToCrash(e.func_71575_a());
                        this.resetGameState();
                        field_147123_G.fatal("Reported exception thrown!", (Throwable)e);
                        this.displayCrashScreen(e.func_71575_a());
                    }
                    catch (Throwable e) {
                        ++this.clientCrashCount;
                        CrashReport report = new CrashReport("Unexpected error", e);
                        this.func_71396_d(report);
                        this.addInfoToCrash(report);
                        this.resetGameState();
                        field_147123_G.fatal("Unreported exception thrown!", e);
                        this.displayCrashScreen(report);
                    }
                    continue;
                }
                ++this.serverCrashCount;
                this.addInfoToCrash(this.field_71433_S);
                this.func_71398_f();
                this.displayCrashScreen(this.field_71433_S);
                this.field_71434_R = false;
            }
        }
        catch (MinecraftError minecraftError) {
        }
        finally {
            this.func_71405_e();
        }
    }

    @Overwrite
    public void func_71377_b(CrashReport report) {
        CrashUtils.outputReport(report);
    }

    @Overwrite
    public void func_71398_f() {
        this.resetGameState();
    }

    @Redirect(method={"runTickKeyboard"}, at=@At(value="FIELD", target="Lnet/minecraft/client/Minecraft;debugCrashKeyPressTime:J", ordinal=0))
    private long checkForF3C(Minecraft mc) {
        if (Keyboard.isKeyDown((int)61) && Keyboard.isKeyDown((int)46)) {
            this.field_83002_am = MinecraftMixin.func_71386_F();
            this.field_184129_aV = true;
        } else {
            this.field_83002_am = -1L;
        }
        if (this.field_83002_am > 0L && MinecraftMixin.func_71386_F() - this.field_83002_am >= 0L) {
            if (GuiScreen.func_146272_n()) {
                if (GuiScreen.func_175283_s()) {
                    if (this.field_71455_al) {
                        this.field_71437_Z.func_152344_a(() -> {
                            throw new ReportedException(new CrashReport("Manually triggered server-side scheduled task exception", new Throwable()));
                        });
                    }
                } else {
                    this.field_152351_aB.add((FutureTask<?>)ListenableFutureTask.create(() -> {
                        throw new ReportedException(new CrashReport("Manually triggered client-side scheduled task exception", new Throwable()));
                    }));
                }
            } else if (GuiScreen.func_175283_s()) {
                if (this.field_71455_al) {
                    this.crashIntegratedServerNextTick = true;
                }
            } else {
                throw new ReportedException(new CrashReport("Manually triggered client-side debug crash", new Throwable()));
            }
        }
        return -1L;
    }

    @Redirect(method={"runTickKeyboard"}, at=@At(value="INVOKE", target="Lorg/lwjgl/input/Keyboard;isKeyDown(I)Z", ordinal=0))
    private boolean isKeyDownF3(int key) {
        return false;
    }

    @Inject(method={"runTickKeyboard"}, at={@At(value="HEAD")})
    private void checkForCtrlI(CallbackInfo ci) {
        ProblemToast lastToast;
        if (GuiScreen.func_146271_m() && !GuiScreen.func_146272_n() && !GuiScreen.func_175283_s() && Keyboard.isKeyDown((int)23) && (lastToast = (ProblemToast)this.func_193033_an().func_192990_a(ProblemToast.class, IToast.field_193655_b)) != null) {
            lastToast.hide = true;
            this.func_147108_a(new GuiWarningScreen(lastToast.report, this.field_71462_r));
        }
    }

    private void resetGameState() {
        try {
            int originalMemoryReserveSize = -1;
            try {
                if (field_71444_a != null) {
                    originalMemoryReserveSize = field_71444_a.length;
                    field_71444_a = new byte[0];
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            IStateful.resetAll();
            if (this.func_147114_u() != null) {
                this.func_147114_u().func_147298_b().func_150718_a((ITextComponent)new TextComponentString("[VanillaFix] Client crashed"));
            }
            this.func_71403_a(null);
            if (this.field_71460_t.func_147702_a()) {
                this.field_71460_t.func_181022_b();
            }
            this.field_152351_aB.clear();
            MinecraftMixin.resetGlStates();
            if (originalMemoryReserveSize != -1) {
                try {
                    field_71444_a = new byte[originalMemoryReserveSize];
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            System.gc();
        }
        catch (Throwable t) {
            field_147123_G.error("Failed to reset state after a crash", t);
            try {
                IStateful.resetAll();
                MinecraftMixin.resetGlStates();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void addInfoToCrash(CrashReport report) {
        report.func_85056_g().func_189529_a("Client Crashes Since Restart", () -> String.valueOf(this.clientCrashCount));
        report.func_85056_g().func_189529_a("Integrated Server Crashes Since Restart", () -> String.valueOf(this.serverCrashCount));
    }

    private void displayInitErrorScreen(CrashReport report) {
        CrashUtils.outputReport(report);
        try {
            try {
                File modFile;
                URL url = NormalASM.class.getProtectionDomain().getCodeSource().getLocation();
                if (url.getProtocol().equals("jar")) {
                    url = new URL(url.getFile().substring(0, url.getFile().indexOf(33)));
                }
                this.field_110449_ao.add((IResourcePack)((modFile = new File(url.toURI())).isDirectory() ? new FolderResourcePack(modFile) : new FileResourcePack(modFile)));
            }
            catch (Throwable t) {
                NormalLogger.instance.error("Failed to load FermiumASM resource pack", t);
            }
            this.field_110451_am = new SimpleReloadableResourceManager(this.field_110452_an);
            this.field_71446_o = new TextureManager((IResourceManager)this.field_110451_am);
            this.field_110451_am.func_110542_a((IResourceManagerReloadListener)this.field_71446_o);
            this.field_135017_as = new LanguageManager(this.field_110452_an, this.field_71474_y.field_74363_ab);
            this.field_110451_am.func_110542_a((IResourceManagerReloadListener)this.field_135017_as);
            this.func_110436_a();
            this.field_71466_p = new FontRenderer(this.field_71474_y, new ResourceLocation("textures/font/ascii.png"), this.field_71446_o, false);
            this.field_110451_am.func_110542_a((IResourceManagerReloadListener)this.field_71466_p);
            this.field_147127_av = new SoundHandler((IResourceManager)this.field_110451_am, this.field_71474_y);
            this.field_110451_am.func_110542_a((IResourceManagerReloadListener)this.field_147127_av);
            this.field_71425_J = true;
            try {
                SplashProgress.pause();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.runGUILoop(new GuiInitErrorScreen(report));
        }
        catch (Throwable t) {
            field_147123_G.error("An uncaught exception occured while displaying the init error screen, making normal report instead", t);
            this.func_71377_b(report);
            System.exit(report.func_71497_f() != null ? -1 : -2);
        }
    }

    private void displayCrashScreen(CrashReport report) {
        try {
            CrashUtils.outputReport(report);
            this.field_71434_R = false;
            this.field_83002_am = -1L;
            this.crashIntegratedServerNextTick = false;
            this.field_71474_y.field_74330_P = false;
            this.field_71456_v.func_146158_b().func_146231_a(true);
            this.runGUILoop(new GuiCrashScreen(report));
        }
        catch (Throwable t) {
            field_147123_G.error("An uncaught exception occured while displaying the crash screen, making normal report instead", t);
            this.func_71377_b(report);
            System.exit(report.func_71497_f() != null ? -1 : -2);
        }
    }

    private void runGUILoop(GuiScreen screen) throws IOException {
        this.func_147108_a(screen);
        while (this.field_71425_J && this.field_71462_r != null && !(this.field_71462_r instanceof GuiMainMenu) && !this.isCurrentMenuCustom(this.field_71462_r)) {
            if (Display.isCreated() && Display.isCloseRequested()) {
                System.exit(0);
            }
            this.field_71429_W = 10000;
            this.field_71462_r.func_146269_k();
            this.field_71462_r.func_73876_c();
            GlStateManager.func_179094_E();
            GlStateManager.func_179086_m((int)16640);
            this.field_147124_at.func_147610_a(true);
            GlStateManager.func_179098_w();
            GlStateManager.func_179083_b((int)0, (int)0, (int)this.field_71443_c, (int)this.field_71440_d);
            ScaledResolution scaledResolution = new ScaledResolution((Minecraft)this);
            GlStateManager.func_179086_m((int)256);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)scaledResolution.func_78327_c(), (double)scaledResolution.func_78324_d(), (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
            GlStateManager.func_179086_m((int)256);
            int width = scaledResolution.func_78326_a();
            int height = scaledResolution.func_78328_b();
            int mouseX = Mouse.getX() * width / this.field_71443_c;
            int mouseY = height - Mouse.getY() * height / this.field_71440_d - 1;
            this.field_71462_r.func_73863_a(mouseX, mouseY, 0.0f);
            this.field_147124_at.func_147609_e();
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            this.field_147124_at.func_147615_c(this.field_71443_c, this.field_71440_d);
            GlStateManager.func_179121_F();
            this.func_175601_h();
            Thread.yield();
            Display.sync((int)60);
            this.func_71361_d("FermiumASM GUI Loop");
        }
    }

    private boolean isCurrentMenuCustom(GuiScreen currentScreen) {
        if (this.customMainMenuGuiCustomClass == null) {
            try {
                this.customMainMenuGuiCustomClass = Class.forName("lumien.custommainmenu.gui.GuiCustom");
            }
            catch (ClassNotFoundException e) {
                this.customMainMenuGuiCustomClass = Object.class;
            }
        }
        return this.customMainMenuGuiCustomClass != Object.class && this.customMainMenuGuiCustomClass.isAssignableFrom(currentScreen.getClass());
    }
}

