/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.common.crashes.mixins;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import mirror.normalasm.api.StacktraceDeobfuscator;
import mirror.normalasm.common.crashes.ICrashReportSuspectGetter;
import mirror.normalasm.common.crashes.ModIdentifier;
import mirror.normalasm.config.NormalConfig;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CrashReport.class}, priority=500)
public abstract class CrashReportMixin
implements ICrashReportSuspectGetter {
    @Shadow
    @Final
    private CrashReportCategory field_85061_c;
    @Shadow
    @Final
    private Throwable field_71511_b;
    @Shadow
    @Final
    private List<CrashReportCategory> field_71512_c;
    @Shadow
    @Final
    private String field_71513_a;
    @Unique
    private Set<ModContainer> suspectedMods;

    @Shadow
    private static String func_71503_h() {
        throw new AssertionError();
    }

    @Shadow
    public abstract String func_71498_d();

    @Override
    public Set<ModContainer> getSuspectedMods() {
        return this.suspectedMods;
    }

    @Inject(method={"populateEnvironment"}, at={@At(value="TAIL")})
    private void afterPopulateEnvironment(CallbackInfo ci) {
        this.field_85061_c.func_189529_a("Suspected Mods", () -> {
            try {
                this.suspectedMods = ModIdentifier.identifyFromStacktrace(this.field_71511_b);
                String modListString = "Unknown";
                ArrayList<String> modNames = new ArrayList<String>();
                for (ModContainer mod : this.suspectedMods) {
                    modNames.add(mod.getName() + " (" + mod.getModId() + ")");
                }
                if (!modNames.isEmpty()) {
                    modListString = StringUtils.join(modNames, (String)", ");
                }
                return modListString;
            }
            catch (Throwable e) {
                return ExceptionUtils.getStackTrace((Throwable)e).replace("\t", "    ");
            }
        });
    }

    @Inject(method={"populateEnvironment"}, at={@At(value="HEAD")})
    private void beforePopulateEnvironment(CallbackInfo ci) {
        StacktraceDeobfuscator.deobfuscateThrowable(this.field_71511_b);
    }

    @Overwrite
    public String func_71502_e() {
        StringBuilder builder = new StringBuilder();
        builder.append("---- Minecraft Crash Report ----\n").append("// Crash report modified by FermiumASM.\n").append("// ").append(NormalConfig.instance.vanityDeobfuscationName).append(" deobfuscated this stacktrace using MCP's stable-39 mappings.\n").append("// ").append(CrashReportMixin.func_71503_h());
        builder.append("\n\n").append("Time: ").append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z").format(new Date())).append("\n").append("Description: ").append(this.field_71513_a).append("\n\n").append(this.func_71498_d()).append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i = 0; i < 87; ++i) {
            builder.append("-");
        }
        builder.append("\n\n");
        this.func_71506_a(builder);
        return builder.toString().replace("\t", "    ");
    }

    @Overwrite
    public void func_71506_a(StringBuilder builder) {
        for (CrashReportCategory crashreportcategory : this.field_71512_c) {
            crashreportcategory.func_85072_a(builder);
            builder.append("\n");
        }
        this.field_85061_c.func_85072_a(builder);
    }
}

