/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.common.crashes;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import mirror.normalasm.NormalLogger;
import mirror.normalasm.common.crashes.IMinecraftExtender;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ReportedException;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;

public final class CrashUtils {
    public static final ThreadLocal<Boolean> WRITING_DETAIL = ThreadLocal.withInitial(() -> false);

    public static void crash(CrashReport report) {
        throw new ReportedException(report);
    }

    public static void warn(CrashReport report) {
        if (FMLLaunchHandler.side().isClient()) {
            CrashUtils.outputReport(report);
            ((IMinecraftExtender)Minecraft.func_71410_x()).showWarningScreen(report);
        } else {
            NormalLogger.instance.fatal(report.func_71501_a(), report.func_71505_b());
        }
    }

    public static void notify(CrashReport report) {
        if (FMLLaunchHandler.side().isClient()) {
            CrashUtils.outputReport(report);
            ((IMinecraftExtender)Minecraft.func_71410_x()).makeErrorNotification(report);
        } else {
            NormalLogger.instance.fatal(report.func_71501_a(), report.func_71505_b());
        }
    }

    public static void outputReport(CrashReport report) {
        try {
            if (report.func_71497_f() == null) {
                String reportName = "crash-";
                reportName = reportName + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date());
                reportName = reportName + (Minecraft.func_71410_x().func_152345_ab() ? "-client" : "-server");
                reportName = reportName + ".txt";
                File reportsDir = FMLLaunchHandler.side().isClient() ? new File(Minecraft.func_71410_x().field_71412_D, "crash-reports") : new File("crash-reports");
                File reportFile = new File(reportsDir, reportName);
                report.func_147149_a(reportFile);
            }
        }
        catch (Throwable e) {
            NormalLogger.instance.fatal("Failed saving report", e);
        }
        NormalLogger.instance.fatal("Minecraft ran into a problem! " + (report.func_71497_f() != null ? "Report saved to: " + report.func_71497_f() : "Crash report could not be saved.") + "\n" + report.func_71502_e());
    }
}

