/*
 * Decompiled with CFR 0.152.
 */
package mirror.normalasm.api;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Locale;
import mirror.normalasm.NormalLogger;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NormalStringPool {
    public static final int FILE_PERMISSIONS_ID = 1;
    private static final Int2ObjectMap<Internal> POOLS = new Int2ObjectArrayMap();

    public static void establishPool(int poolId, int expectedSize, String ... startingValues) {
        if (POOLS.containsKey(poolId)) {
            return;
        }
        POOLS.put(poolId, (Object)new Internal(poolId, expectedSize, startingValues));
    }

    public static Internal purgePool(int poolId) {
        return (Internal)POOLS.remove(poolId);
    }

    public static int getSize() {
        return ((Internal)NormalStringPool.POOLS.defaultReturnValue()).internalPool.size();
    }

    public static int getSize(int pool) {
        return ((Internal)NormalStringPool.POOLS.get((int)pool)).internalPool.size();
    }

    public static long getDeduplicatedCount() {
        return ((Internal)NormalStringPool.POOLS.defaultReturnValue()).deduplicatedCount;
    }

    public static long getDeduplicatedCount(int pool) {
        return ((Internal)NormalStringPool.POOLS.get((int)pool)).deduplicatedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String canonicalize(String string) {
        Int2ObjectMap<Internal> int2ObjectMap = POOLS;
        synchronized (int2ObjectMap) {
            return ((Internal)POOLS.defaultReturnValue()).addOrGet(string);
        }
    }

    public static String unsafe$Canonicalize(String string) {
        return ((Internal)POOLS.defaultReturnValue()).addOrGet(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String lowerCaseAndCanonicalize(String string) {
        Int2ObjectMap<Internal> int2ObjectMap = POOLS;
        synchronized (int2ObjectMap) {
            return ((Internal)POOLS.defaultReturnValue()).addOrGet(string.toLowerCase(Locale.ROOT));
        }
    }

    public static String unsafe$LowerCaseAndCanonicalize(String string) {
        return ((Internal)POOLS.defaultReturnValue()).addOrGet(string.toLowerCase(Locale.ROOT));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String canonicalize(String string, int poolId, boolean checkMainPool) {
        Int2ObjectMap<Internal> int2ObjectMap;
        if (checkMainPool) {
            int2ObjectMap = POOLS;
            synchronized (int2ObjectMap) {
                String canonicalized = (String)((Internal)NormalStringPool.POOLS.get((int)poolId)).internalPool.get((Object)string);
                if (canonicalized != null) {
                    return canonicalized;
                }
            }
        }
        int2ObjectMap = POOLS;
        synchronized (int2ObjectMap) {
            return ((Internal)POOLS.get(poolId)).addOrGet(string);
        }
    }

    public static String unsafe$Canonicalize(String string, int poolId, boolean checkMainPool) {
        String canonicalized;
        if (checkMainPool && (canonicalized = (String)((Internal)NormalStringPool.POOLS.get((int)poolId)).internalPool.get((Object)string)) != null) {
            return canonicalized;
        }
        return ((Internal)POOLS.get(poolId)).addOrGet(string);
    }

    @SubscribeEvent
    public static void onDebugList(RenderGameOverlayEvent.Text event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.field_71474_y.field_74330_P) {
            ArrayList list = event.getLeft();
            if (!((String)list.get(list.size() - 1)).equals("")) {
                list.add("");
            }
            int size = NormalStringPool.getSize();
            long deduplicatedCount = NormalStringPool.getDeduplicatedCount();
            list.add(String.format("%s%s%s: %s strings processed. %s unique, %s deduplicated.", TextFormatting.AQUA, "<FermiumASM>", TextFormatting.RESET, deduplicatedCount, size, deduplicatedCount - (long)size));
        }
    }

    static {
        NormalStringPool.establishPool(-1, 12288, "", " ");
        POOLS.defaultReturnValue(POOLS.get(-1));
    }

    static class Internal {
        final int id;
        final ObjectOpenHashSet<String> internalPool;
        long deduplicatedCount;

        Internal(int id, int expectedSize, String ... startingValues) {
            this.id = id;
            this.internalPool = new ObjectOpenHashSet(expectedSize);
            for (String startingValue : startingValues) {
                this.internalPool.add((Object)startingValue);
            }
        }

        String addOrGet(String string) {
            ++this.deduplicatedCount;
            return (String)this.internalPool.addOrGet((Object)string);
        }

        protected void finalize() {
            NormalLogger.instance.warn("Clearing NormalStringPool {}", (Object)this.id);
        }
    }
}

