/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.entity.projectile;

import lykrast.defiledlands.common.item.IPellet;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntitySmallFireball;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityRavagerProjectile
extends EntitySmallFireball {
    private static final DataParameter<ItemStack> ITEM = EntityDataManager.func_187226_a(EntityRavagerProjectile.class, (DataSerializer)DataSerializers.field_187196_f);
    private float damage;
    private float speed;

    public EntityRavagerProjectile(World worldIn) {
        super(worldIn);
        this.damage = 12.0f;
        this.speed = 1.0f;
    }

    public EntityRavagerProjectile(World worldIn, EntityLivingBase shooter, double accelX, double accelY, double accelZ, float speed) {
        super(worldIn, shooter, accelX, accelY, accelZ);
        float f;
        double d0 = MathHelper.func_76133_a((double)(accelX * accelX + accelY * accelY + accelZ * accelZ));
        this.field_70232_b = accelX / d0 * 0.2 * (double)speed;
        this.field_70233_c = accelY / d0 * 0.2 * (double)speed;
        this.field_70230_d = accelZ / d0 * 0.2 * (double)speed;
        this.damage = 12.0f;
        this.speed = f = 1.0f - 0.05f / speed;
    }

    public EntityRavagerProjectile(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ, float speed) {
        super(worldIn, x, y, z, accelX, accelY, accelZ);
        float f;
        this.field_70232_b *= (double)speed;
        this.field_70233_c *= (double)speed;
        this.field_70230_d *= (double)speed;
        this.damage = 12.0f;
        this.speed = f = 1.0f - 0.05f / speed;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ITEM, (Object)ItemStack.field_190927_a);
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K) {
            boolean flag;
            if (result.field_72308_g != null && (flag = result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.field_70235_a), this.getDamage()))) {
                ItemStack stack;
                this.func_174815_a(this.field_70235_a, result.field_72308_g);
                if (result.field_72308_g instanceof EntityLivingBase && (stack = this.getItem()).func_77973_b() instanceof IPellet) {
                    ((IPellet)stack.func_77973_b()).onHit((EntityLivingBase)result.field_72308_g, this.field_70235_a, stack);
                }
            }
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("Damage", this.damage);
        compound.func_74776_a("Speed", this.speed);
        ItemStack itemstack = this.getItem();
        if (!itemstack.func_190926_b()) {
            compound.func_74782_a("Item", (NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.damage = compound.func_74760_g("Damage");
        this.speed = compound.func_74760_g("Speed");
        ItemStack itemstack = new ItemStack(compound.func_74775_l("Item"));
        if (itemstack.func_190926_b()) {
            this.func_70106_y();
        } else {
            this.setItem(itemstack);
        }
    }

    protected float func_82341_c() {
        return this.getSpeed();
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public ItemStack getItem() {
        return (ItemStack)this.func_184212_Q().func_187225_a(ITEM);
    }

    public void setItem(ItemStack stack) {
        this.func_184212_Q().func_187227_b(ITEM, (Object)stack);
        this.func_184212_Q().func_187217_b(ITEM);
    }

    protected boolean func_184564_k() {
        return false;
    }
}

