/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcreopargh.ctintegration.vanilla.expansion;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.api.player.IPlayer;
import crafttweaker.api.util.Position3f;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.annotations.ZenGetter;
import stanhebben.zenscript.annotations.ZenMethod;
import xyz.tcreopargh.ctintegration.modutil.XPUtil;
import xyz.tcreopargh.ctintegration.vanilla.advancement.AdvancementProgressImpl;
import xyz.tcreopargh.ctintegration.vanilla.advancement.IAdvancement;
import xyz.tcreopargh.ctintegration.vanilla.advancement.IAdvancementProgress;

@ZenExpansion(value="crafttweaker.player.IPlayer")
@ZenRegister
public class PlayerExpansionMC {
    @ZenMethod
    public static void addExperience(IPlayer player, int amount) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        mcPlayer.func_71023_q(amount);
    }

    @ZenMethod
    public static void removeExperience(IPlayer player, int amount) {
        PlayerExpansionMC.addExperience(player, -amount);
    }

    @ZenGetter(value="experience")
    public static int getExperience(IPlayer player) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        return XPUtil.getPlayerXP(mcPlayer);
    }

    @ZenMethod
    public static int getTotalXP(IPlayer player) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        return mcPlayer.field_71067_cb;
    }

    @ZenMethod
    public static void playSound(IPlayer player, String soundResourceLocation, float volume, float pitch) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        mcPlayer.func_184185_a(Objects.requireNonNull((SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(soundResourceLocation))), volume, pitch);
    }

    @ZenMethod
    public static void sendPlaySoundPacket(IPlayer player, String soundResourceLocation, String soundCategory, Position3f pos, float volume, float pitch) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        if (mcPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)mcPlayer;
            SoundCategory category = SoundCategory.func_187950_a((String)soundCategory);
            if (category != null) {
                entityPlayerMP.field_71135_a.func_147359_a((Packet)new SPacketCustomSound(soundResourceLocation, category, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), volume, pitch));
            } else {
                CraftTweakerAPI.logWarning((String)"Failed to send play sound packet. soundCategory is invalid.");
            }
        } else {
            CraftTweakerAPI.logInfo((String)"Failed to send play sound packet. Player is not an instance of EntityPlayerMP");
        }
    }

    @ZenMethod
    public static boolean isPlayerMP(IPlayer player) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        return mcPlayer instanceof EntityPlayerMP;
    }

    @ZenMethod
    public static IAdvancementProgress getAdvancementProgress(IPlayer player, IAdvancement advancement) {
        EntityPlayer mcPlayer = CraftTweakerMC.getPlayer((IPlayer)player);
        Advancement mcAdvancement = (Advancement)advancement.getInternal();
        if (mcPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)mcPlayer;
            return new AdvancementProgressImpl(entityPlayerMP.func_192039_O().func_192747_a(mcAdvancement));
        }
        return null;
    }
}

