/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcreopargh.ctintegration.modutil;

import com.google.common.math.BigIntegerMath;
import com.google.common.math.LongMath;
import java.math.BigInteger;
import java.math.RoundingMode;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;

public class XPUtil {
    private static final BigInteger B72 = BigInteger.valueOf(72L);
    private static final BigInteger B54215 = BigInteger.valueOf(54215L);
    private static final BigInteger B325 = BigInteger.valueOf(325L);
    private static final BigInteger B18 = BigInteger.valueOf(18L);
    private static final long LVLOFFSET32 = -XPUtil.calculateXPfromLevelHigh(32) + XPUtil.calculateXPfromLevelLow(32);

    public static long termial(long level) {
        return (level * level + level) / 2L;
    }

    private static long calculateXPfromLevelHigh(int level) {
        return -158L * ((long)level + 1L) + XPUtil.termial(level - 1) * 9L;
    }

    private static long calculateXPfromLevelLow(int level) {
        if (level >= 1 && level <= 16) {
            return (long)(Math.pow(level, 2.0) + (double)(6 * level));
        }
        if (level >= 17 && level <= 31) {
            return (long)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0);
        }
        if (level >= 32) {
            return (long)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0);
        }
        return 0L;
    }

    private static long calculateXPfromLevel(int level) {
        if (level >= 32) {
            return XPUtil.calculateXPfromLevelHigh(level) + LVLOFFSET32;
        }
        return XPUtil.calculateXPfromLevelLow(level);
    }

    public static int getExperienceForLevel(int level) {
        if (level < 0) {
            throw new ArithmeticException("level underflow");
        }
        return Math.toIntExact(XPUtil.calculateXPfromLevel(level));
    }

    public static int getPlayerXP(@Nonnull EntityPlayer player) throws ArithmeticException {
        try {
            return player.field_71075_bZ.field_75098_d ? 0x3FFFFFFF : Math.addExact(XPUtil.getExperienceForLevel(player.field_71068_ca), (int)(player.field_71106_cc * (float)player.func_71050_bK()));
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Too many XP levels");
        }
    }

    public static void addPlayerXP(@Nonnull EntityPlayer player, int amount) throws ArithmeticException {
        try {
            int experience;
            player.field_71067_cb = experience = Math.max(0, Math.addExact(XPUtil.getPlayerXP(player), amount));
            player.field_71068_ca = XPUtil.getLevelForExperience(experience);
            int expForLevel = XPUtil.getExperienceForLevel(player.field_71068_ca);
            player.field_71106_cc = (float)(experience - expForLevel) / (float)XPUtil.getXpBarCapacity(player.field_71068_ca);
        }
        catch (ArithmeticException e) {
            throw new ArithmeticException("Too many XP levels");
        }
    }

    public static int getXpBarCapacity(int level) {
        if (level >= 30) {
            return -158 + level * 9;
        }
        if (level >= 15) {
            return -38 + level * 5;
        }
        if (level >= 0) {
            return 7 + level * 2;
        }
        throw new ArithmeticException("level underflow");
    }

    public static int getLevelForExperience(long exp) {
        if (exp > 0x1C71C71C71C71C7L) {
            return BigIntegerMath.sqrt((BigInteger)BigInteger.valueOf(exp).multiply(B72).subtract(B54215), (RoundingMode)RoundingMode.DOWN).add(B325).divide(B18).intValueExact();
        }
        if (exp > Integer.MAX_VALUE) {
            return (int)((LongMath.sqrt((long)(72L * exp - 54215L), (RoundingMode)RoundingMode.DOWN) + 325L) / 18L);
        }
        if (exp > 1395L) {
            return (int)((Math.sqrt(72L * exp - 54215L) + 325.0) / 18.0);
        }
        if (exp > 315L) {
            return (int)(Math.sqrt(40L * exp - 7839L) / 10.0 + 8.1);
        }
        if (exp > 0L) {
            return (int)(Math.sqrt(exp + 9L) - 3.0);
        }
        return 0;
    }
}

