/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcreopargh.ctintegration.data;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.data.DataBool;
import crafttweaker.api.data.DataByte;
import crafttweaker.api.data.DataByteArray;
import crafttweaker.api.data.DataDouble;
import crafttweaker.api.data.DataFloat;
import crafttweaker.api.data.DataInt;
import crafttweaker.api.data.DataIntArray;
import crafttweaker.api.data.DataList;
import crafttweaker.api.data.DataLong;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.DataShort;
import crafttweaker.api.data.DataString;
import crafttweaker.api.data.IData;
import crafttweaker.api.minecraft.CraftTweakerMC;
import crafttweaker.mc1120.data.NBTConverter;
import java.util.Map;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.StringEscapeUtils;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.ctintegration.data.DataUtil")
public class DataUtil {
    @ZenMethod
    public static IData fromJson(String jsonString) {
        return DataUtil.parse(jsonString);
    }

    @ZenMethod
    public static IData parse(String jsonString) {
        try {
            NBTTagCompound tagCompound = JsonToNBT.func_180713_a((String)jsonString);
            return NBTConverter.from((NBTBase)tagCompound, (boolean)false);
        }
        catch (NBTException e) {
            CraftTweakerAPI.logError((String)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @ZenMethod
    public static String toNBTString(IData data) {
        return CraftTweakerMC.getNBT((IData)data).toString();
    }

    @ZenMethod
    public static String getRawString(IData data) {
        if (data instanceof DataBool) {
            return data.asBool() ? "true" : "false";
        }
        if (data instanceof DataByte) {
            return String.valueOf(data.asByte());
        }
        if (data instanceof DataDouble) {
            return String.valueOf(data.asDouble());
        }
        if (data instanceof DataFloat) {
            return String.valueOf(data.asFloat());
        }
        if (data instanceof DataInt) {
            return String.valueOf(data.asInt());
        }
        if (data instanceof DataString) {
            return data.asString();
        }
        if (data instanceof DataShort) {
            return String.valueOf(data.asShort());
        }
        if (data instanceof DataLong) {
            return String.valueOf(data.asLong());
        }
        return data.toString();
    }

    @ZenMethod
    public static String toJson(IData data) {
        if (data instanceof DataBool) {
            return data.asBool() ? "true" : "false";
        }
        if (data instanceof DataByte) {
            return String.valueOf(data.asByte());
        }
        if (data instanceof DataDouble) {
            return String.valueOf(data.asDouble());
        }
        if (data instanceof DataFloat) {
            return String.valueOf(data.asFloat());
        }
        if (data instanceof DataInt) {
            return String.valueOf(data.asInt());
        }
        if (data instanceof DataString) {
            return "\"" + StringEscapeUtils.escapeJava((String)data.asString()) + "\"";
        }
        if (data instanceof DataShort) {
            return String.valueOf(data.asShort());
        }
        if (data instanceof DataLong) {
            return String.valueOf(data.asLong());
        }
        if (data instanceof DataByteArray) {
            StringBuilder result = new StringBuilder();
            result.append("[");
            boolean first = true;
            for (byte value : data.asByteArray()) {
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(value);
            }
            result.append("]");
            return result.toString();
        }
        if (data instanceof DataIntArray) {
            StringBuilder result = new StringBuilder();
            result.append('[');
            boolean first = true;
            for (int value : data.asIntArray()) {
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(value);
            }
            result.append(']');
            return result.toString();
        }
        if (data instanceof DataList) {
            StringBuilder output = new StringBuilder();
            output.append('[');
            boolean first = true;
            for (IData value : data.asList()) {
                if (first) {
                    first = false;
                } else {
                    output.append(", ");
                }
                output.append(DataUtil.toJson(value));
            }
            output.append(']');
            return output.toString();
        }
        if (data instanceof DataMap) {
            StringBuilder result = new StringBuilder();
            result.append('{');
            boolean first = true;
            for (Map.Entry entry : data.asMap().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append("\"").append(StringEscapeUtils.escapeJava((String)((String)entry.getKey()))).append("\"");
                result.append(": ");
                result.append(DataUtil.toJson((IData)entry.getValue()));
            }
            result.append('}');
            return result.toString();
        }
        return "";
    }
}

