/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.List;
import java.util.Vector;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.AbstractIllager;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityEndermite;
import net.minecraft.entity.monster.EntityGuardian;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityStray;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.projectile.EntityWitherSkull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.ExtendedResourceLocation;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;

public final class NPE {
    private static final List<ResourceLocation> _BAD_GUYS = new Vector<ResourceLocation>(40);

    public static final EntityLiving getOrNull(@Nullable Entity entity) {
        return entity instanceof EntityLiving ? (EntityLiving)entity : null;
    }

    public static final boolean isa(@Nullable Entity entity) {
        return NPE.getOrNull(entity) != null;
    }

    public static final boolean isaWitch(EnumCreatureAttribute creatureType, boolean modded) {
        return creatureType == EnumCreatureAttribute.UNDEFINED || modded && creatureType != null && creatureType.name().contains("WITCH");
    }

    public static final boolean isaWitch(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (modded) {
            if (target instanceof EntityWitch) {
                return true;
            }
            String eid = String.valueOf(EntityList.func_191301_a((Entity)target));
            return eid.endsWith("witch");
        }
        return !modded && target.getClass() == EntityWitch.class;
    }

    public static final boolean isaFish(ItemStack stack, boolean modded) {
        if (ItemStacks.isEmpty(stack)) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemFishFood) {
            return true;
        }
        if (modded) {
            String cn = item.getClass().getName();
            if (cn.endsWith("ItemFish") && cn.contains(".aquaculture.")) {
                return true;
            }
            if (cn.endsWith("Cod") && cn.contains(".combustfish.")) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isaSilverfish(Entity target, boolean modded) {
        return modded && target instanceof EntitySilverfish || !modded && target != null && target.getClass().equals(EntitySilverfish.class);
    }

    public static final boolean isaSlime(Entity target, boolean modded) {
        return modded && target instanceof EntitySlime || !modded && target != null && target.getClass().equals(EntitySlime.class);
    }

    public static final boolean isaSkeleton(Entity target, boolean modded, boolean wither_ok) {
        if (target == null) {
            return false;
        }
        boolean iz = target instanceof AbstractSkeleton;
        if (modded) {
            return wither_ok ? iz : !(target instanceof EntityWitherSkeleton);
        }
        if (iz) {
            Class<?> klass = target.getClass();
            iz = klass == EntitySkeleton.class || klass == EntityWitherSkeleton.class && wither_ok || klass == EntityStray.class;
        }
        return iz;
    }

    public static final boolean isaArthropod(Entity target, boolean modded) {
        boolean iz;
        if (target == null) {
            return false;
        }
        if (modded) {
            if (NPE.isaSpider(target, modded)) {
                return true;
            }
            if (NPE.isaSilverfish(target, modded)) {
                return true;
            }
            if (ModIntegration.THE_BETWEENLANDS.matchesAny(target, "sludge", "leech", "blood_snail", "mire_snail", "termite", "silt_crab")) {
                return true;
            }
        }
        boolean bl = iz = target instanceof EntityLiving && ((EntityLiving)target).func_70668_bt() == EnumCreatureAttribute.ARTHROPOD;
        if (iz && !modded) {
            Class<?> klass = target.getClass();
            iz = klass == EntitySpider.class || klass == EntityCaveSpider.class || klass == EntitySilverfish.class || klass == EntityEndermite.class;
        }
        return iz;
    }

    public static final boolean isaSkeleton(Entity target, boolean modded) {
        return NPE.isaSkeleton(target, modded, true);
    }

    public static final boolean isaTaintableSoul(Entity victim, boolean modded, boolean strict) {
        if (victim != null) {
            if (victim instanceof EntityZombie) {
                return !strict || !(victim instanceof EntityPigZombie);
            }
            if (victim instanceof AbstractIllager) {
                return true;
            }
            if (victim instanceof EntityVillager) {
                return !strict;
            }
            if (NPE.isaWitch(victim, modded)) {
                return true;
            }
            if (!strict && SharedGlue.isRealPlayer(victim)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isaTaintedSoul(Entity victim, boolean modded) {
        return NPE.isaTaintableSoul(victim, modded, true);
    }

    public static final boolean isZombieLike(Entity victim, boolean strict) {
        if (victim instanceof EntityLiving) {
            if (victim instanceof EntityZombie) {
                return true;
            }
            if (!strict && victim instanceof AbstractIllager) {
                return true;
            }
            if (!strict && NPE.isaWitch(victim, true)) {
                return true;
            }
            String cn = victim.getClass().getName();
            if (ModIntegration.ABYSSALCRAFT.belongsTo(victim)) {
                return cn.endsWith("Zombie");
            }
            if (ModIntegration.THE_BETWEENLANDS.belongsTo(victim)) {
                return cn.endsWith("Mummy");
            }
        }
        return false;
    }

    public static final boolean isVillagerish(Entity victim) {
        if (victim != null) {
            if (victim instanceof EntityVillager || victim instanceof EntityZombieVillager) {
                return true;
            }
            if (victim instanceof AbstractIllager) {
                return true;
            }
            if (NPE.isaWitch(victim, true)) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isaSpider(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (modded) {
            if (target instanceof EntitySpider) {
                return true;
            }
            String cn = target.getClass().getName();
            if (cn.contains(".primitivemobs.") && cn.endsWith("Spider")) {
                return true;
            }
        }
        return !modded && (target.getClass() == EntitySpider.class || target.getClass() == EntityCaveSpider.class);
    }

    public static final boolean isaVenomousSpider(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (modded) {
            return target instanceof EntityCaveSpider;
        }
        return !modded && target.getClass() == EntityCaveSpider.class;
    }

    public static final boolean isaCreeper(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (!modded) {
            return target.getClass() == EntityCreeper.class;
        }
        if (target instanceof EntityCreeper) {
            return true;
        }
        return ModIntegration.NETHER_EX.matches(target, "monster_spore_creeper");
    }

    public static final boolean isaBlaze(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (!modded) {
            return target.getClass() == EntityBlaze.class;
        }
        if (target instanceof EntityBlaze) {
            return true;
        }
        return ModIntegration.PRIMITIVE_MOBS.matches(target, "blazing_juggernaut");
    }

    public static final boolean isTooEasyTarget(Entity target, boolean modded, float threshold) {
        if (SharedGlue.isBoss(target)) {
            return false;
        }
        if (target instanceof EntityLiving) {
            EntityLiving livingtarget = (EntityLiving)target;
            IAttributeInstance ia = livingtarget.func_110148_a(SharedMonsterAttributes.field_111264_e);
            if (ia != null && ia.func_111126_e() < (double)threshold) {
                return true;
            }
            if (target instanceof EntitySlime) {
                return ((EntitySlime)target).func_70809_q() < 3;
            }
            return false;
        }
        return !SharedGlue.isRealPlayer(target);
    }

    public static final boolean isaWither(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (modded) {
            if (target instanceof EntityWither) {
                return true;
            }
            String cn = target.getClass().getName();
            if (cn.contains(".spectrite.") && cn.endsWith("Wither")) {
                return true;
            }
        }
        return !modded && target.getClass() == EntityWither.class;
    }

    public static final boolean isaDragon(Entity target, boolean modded) {
        if (target != null) {
            ResourceLocation eid;
            if (modded && target instanceof EntityDragon || !modded && target.getClass().equals(EntityDragon.class)) {
                return true;
            }
            if (target instanceof MultiPartEntityPart) {
                MultiPartEntityPart mp = (MultiPartEntityPart)target;
                if (mp.field_70259_a instanceof Entity && mp.field_70259_a != mp) {
                    return NPE.isaDragon((Entity)mp.field_70259_a, modded);
                }
            } else if (modded && target instanceof EntityLivingBase && (eid = EntityList.func_191301_a((Entity)target)) != null && "dragonboss".equals(eid.func_110623_a())) {
                return true;
            }
        }
        return false;
    }

    public static final boolean isaEnderman(Entity target, boolean modded) {
        if (target == null) {
            return false;
        }
        if (modded) {
            if (target instanceof EntityEnderman) {
                return true;
            }
            String cn = target.getClass().getName();
            if (cn.contains(".spectrite.") && cn.endsWith("Enderman")) {
                return true;
            }
        }
        return !modded && target.getClass() == EntityEnderman.class;
    }

    static final boolean isaWitheringThingy(Entity thingy) {
        return thingy != null && (thingy.getClass() == EntityWitherSkeleton.class || thingy.getClass() == EntityWitherSkull.class);
    }

    public static final boolean isWardingProtectionFrom(Entity target, boolean modded) {
        return NPE.isaWitch(target, modded) || NPE.isaWither(target, modded) || NPE.isaWitheringThingy(target);
    }

    public static final boolean isMisusedMagic(@Nonnull DamageSource ds) {
        Entity e = ds.func_76346_g();
        if (e == null || !ds.func_82725_o()) {
            return false;
        }
        return e instanceof EntityGuardian;
    }

    public static final boolean isPrimedTnT(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity instanceof EntityTNTPrimed) {
            return true;
        }
        return ModIntegration.PRIMITIVE_MOBS.matches(entity, "primitive_tnt_primed");
    }

    public static final String getTranslationName(@Nullable ResourceLocation subject) {
        if (ExtendedResourceLocation.isa(subject)) {
            subject = ExtendedResourceLocation.narrow(subject);
        }
        String translatedId = EntityList.func_191302_a((ResourceLocation)subject);
        translatedId = (String)StringUtils.defaultIfBlank((CharSequence)translatedId, (CharSequence)"UNKNOWN");
        return "entity." + translatedId + ".name";
    }

    @Nonnull
    public static final String getTranslatedName(String translatedId) {
        translatedId = (String)StringUtils.defaultIfBlank((CharSequence)translatedId, (CharSequence)"UNKNOWN");
        String lookup = "entity." + translatedId + ".name";
        return Strings.translate(lookup);
    }

    @Nonnull
    public static final String getTranslatedName(@Nullable ResourceLocation subject) {
        if (ExtendedResourceLocation.isa(subject)) {
            subject = ExtendedResourceLocation.narrow(subject);
        }
        String translatedId = EntityList.func_191302_a((ResourceLocation)subject);
        return NPE.getTranslatedName(translatedId);
    }

    @Nonnull
    public static final String getTranslatedName(Entity subject) {
        return NPE.getTranslatedName(EntityList.func_191301_a((Entity)subject));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void addModdedBadGuy(ResourceLocation rLoc) {
        if (rLoc != null) {
            List<ResourceLocation> list = _BAD_GUYS;
            synchronized (list) {
                if (!_BAD_GUYS.contains(rLoc)) {
                    _BAD_GUYS.add(rLoc);
                }
            }
        }
    }

    static final boolean isKnownBadGuy(ResourceLocation rLoc) {
        return ModIntegration.MOWZIE_MOBS.belongsTo(rLoc) || ModIntegration.GHOSTLY.belongsTo(rLoc) || ModIntegration.DMONSTERS.belongsTo(rLoc);
    }

    static final boolean isBadGuy(ResourceLocation rLoc) {
        for (ResourceLocation deny : _BAD_GUYS) {
            if (deny.equals((Object)rLoc)) {
                return true;
            }
            if (!"*".equals(deny.func_110623_a()) || !deny.func_110624_b().equals(rLoc.func_110624_b())) continue;
            return true;
        }
        return NPE.isKnownBadGuy(rLoc);
    }

    public static final boolean isModdedBadGuy(@Nullable ResourceLocation rLoc) {
        return rLoc != null && NPE.isBadGuy(rLoc);
    }

    public static final void resetModdedBadGuys() {
        _BAD_GUYS.clear();
    }

    private NPE() {
    }

    public static final void init() {
    }
}

