/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.api.IRegistrationListener;

public final class IniRegistries {
    private static final Map<String, ModDefs> registryDefsINSTANCE = new ConcurrentHashMap<String, ModDefs>();

    public static final boolean isStarted(String modid) {
        return registryDefsINSTANCE.containsKey(modid);
    }

    public static final void clearAll(@Nullable String modid) {
        if (modid != null) {
            registryDefsINSTANCE.remove(modid);
        } else {
            registryDefsINSTANCE.clear();
        }
    }

    @Nullable
    static final ModDefs getModDefs(@Nonnull String modid, boolean force) {
        ModDefs modDefs = registryDefsINSTANCE.get(modid);
        if (modDefs == null && force) {
            modDefs = new ModDefs();
            registryDefsINSTANCE.put(modid, modDefs);
        }
        return modDefs;
    }

    @Nonnull
    public static final List<Block> autoregisterBlocks(@Nonnull String modid, @Nonnull IForgeRegistry<Block> blocks) {
        List<Object> pending;
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredBlocks.isEmpty()) {
            pending = (List)modDefs._unregisteredBlocks.clone();
            modDefs._unregisteredBlocks.clear();
            for (Block block : pending) {
                blocks.register((IForgeRegistryEntry)block);
            }
            for (Block block : pending) {
                if (!(block instanceof IRegistrationListener)) continue;
                ((IRegistrationListener)block).notifyRegistered(blocks);
            }
        } else {
            pending = new ArrayList<Block>();
        }
        return pending;
    }

    @Nonnull
    public static final List<Item> autoregisterItems(@Nonnull String modid, @Nonnull IForgeRegistry<Item> items) {
        List<Object> pending;
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredItems.isEmpty()) {
            pending = (List)modDefs._unregisteredItems.clone();
            modDefs._unregisteredItems.clear();
            modDefs._unregisteredItemFromBlockMap.clear();
            for (Item item : pending) {
                items.register((IForgeRegistryEntry)item);
            }
            for (Item item : pending) {
                if (!(item instanceof IRegistrationListener)) continue;
                ((IRegistrationListener)item).notifyRegistered(items);
            }
        } else {
            pending = new ArrayList<Item>();
        }
        return pending;
    }

    public static final <T> T autoregisterItem(@Nonnull String modid, @Nonnull Item item, @Nonnull String oid) {
        item.setRegistryName(oid);
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredItems.add(item);
        return (T)item;
    }

    public static final void autoregisterBlockItem(@Nonnull String modid, @Nonnull ItemBlock blockitem, @Nonnull String oid) {
        IniRegistries.autoregisterItem(modid, (Item)blockitem, oid);
        Block block = blockitem.func_179223_d();
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredItemFromBlockMap.put(block, blockitem);
    }

    @Nonnull
    public static final Block autoregisterBlock(@Nonnull String modid, @Nonnull Block block, @Nonnull String oid, boolean only) {
        block.setRegistryName(oid);
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredBlocks.add(block);
        if (!only) {
            ItemBlock itemblock = new ItemBlock(block);
            IniRegistries.autoregisterBlockItem(modid, itemblock, oid);
        }
        return block;
    }

    public static final void autoregisterBlockTile(Class<? extends TileEntity> teClass, String fq_oid) {
        GameRegistry.registerTileEntity(teClass, (String)fq_oid);
    }

    @Nullable
    public static final Item getItemFromBlock(@Nonnull String modid, @Nonnull Block block) {
        ItemBlock blockitem;
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && (blockitem = modDefs._unregisteredItemFromBlockMap.get(block)) != null) {
            return blockitem;
        }
        return Item.func_150898_a((Block)block);
    }

    public static final Potion autoregisterPotion(@Nonnull String modid, @Nonnull Potion potion, @Nonnull String oid) {
        potion.setRegistryName(modid, oid);
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredPotions.add(potion);
        return potion;
    }

    public static final PotionType autoregisterPotionType(@Nonnull String modid, @Nonnull PotionType mix, @Nonnull String oid) {
        mix.setRegistryName(modid, oid);
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredPotionMixes.add(mix);
        return mix;
    }

    public static final void autoregisterPotions(@Nonnull String modid, @Nonnull IForgeRegistry<Potion> potions) {
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredPotions.isEmpty()) {
            List pending = (List)modDefs._unregisteredPotions.clone();
            modDefs._unregisteredPotions.clear();
            for (Potion p : pending) {
                potions.register((IForgeRegistryEntry)p);
            }
            for (Potion p : pending) {
                if (!(p instanceof IRegistrationListener)) continue;
                ((IRegistrationListener)p).notifyRegistered(potions);
            }
        }
    }

    public static final void autoregisterPotionMixes(@Nonnull String modid, @Nonnull IForgeRegistry<PotionType> mixes) {
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredPotionMixes.isEmpty()) {
            List pending = (List)modDefs._unregisteredPotionMixes.clone();
            modDefs._unregisteredPotionMixes.clear();
            for (PotionType mix : pending) {
                mixes.register((IForgeRegistryEntry)mix);
            }
        }
    }

    public static final Enchantment autoregisterEnchantment(@Nonnull String modid, @Nonnull Enchantment enchant, @Nonnull String oid) {
        enchant.setRegistryName(modid, oid);
        IniRegistries.getModDefs((String)modid, (boolean)true)._unregisteredEnchantments.add(enchant);
        return enchant;
    }

    public static final void autoregisterEnchantments(@Nonnull String modid, @Nonnull IForgeRegistry<Enchantment> enchantments) {
        ModDefs modDefs = IniRegistries.getModDefs(modid, false);
        if (modDefs != null && !modDefs._unregisteredEnchantments.isEmpty()) {
            List pending = (List)modDefs._unregisteredEnchantments.clone();
            modDefs._unregisteredEnchantments.clear();
            for (Enchantment e : pending) {
                enchantments.register((IForgeRegistryEntry)e);
            }
            for (Enchantment e : pending) {
                if (!(e instanceof IRegistrationListener)) continue;
                ((IRegistrationListener)e).notifyRegistered(enchantments);
            }
        }
    }

    private IniRegistries() {
    }

    public static final class ModDefs {
        final ArrayList<Block> _unregisteredBlocks = new ArrayList(91);
        final ArrayList<Item> _unregisteredItems = new ArrayList(301);
        final HashMap<Block, ItemBlock> _unregisteredItemFromBlockMap = new HashMap(71, 0.8f);
        final ArrayList<Potion> _unregisteredPotions = new ArrayList(31);
        final ArrayList<PotionType> _unregisteredPotionMixes = new ArrayList(71);
        final ArrayList<Enchantment> _unregisteredEnchantments = new ArrayList(31);
    }
}

