/*
 * Decompiled with CFR 0.152.
 */
package com.realgecko.xpfromharvest;

import com.realgecko.xpfromharvest.ModConfig;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SimpleHarvestHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void handleRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!(event.getWorld() instanceof WorldServer)) {
            return;
        }
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (Arrays.asList(ModConfig.crops).contains(state.toString())) {
            this.handleHarvest(block, world, pos, state, world.field_73012_v);
        }
    }

    void handleHarvest(Block block, World world, BlockPos pos, IBlockState state, Random rand) {
        NonNullList drops = NonNullList.func_191196_a();
        block.getDrops(drops, (IBlockAccess)world, pos, state, 0);
        boolean foundSeed = false;
        for (ItemStack stack : drops) {
            if (stack.func_77973_b() instanceof IPlantable && !foundSeed) {
                foundSeed = true;
                continue;
            }
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
            world.func_72838_d((Entity)entityItem);
        }
        if (rand.nextInt(100) + 1 <= ModConfig.chance) {
            EntityXPOrb xpOrb = new EntityXPOrb(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ModConfig.xpAmount);
            world.func_72838_d((Entity)xpOrb);
        }
        state = block.func_176223_P();
        world.func_175656_a(pos, state);
    }
}

