/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.worldgen;

import cd4017be.dimstack.api.util.BlockPredicate;
import cd4017be.dimstack.worldgen.OreGenBase;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.chunk.Chunk;

public class OreGenCentered
extends OreGenBase {
    final int baseY;
    final float min;
    final float max;

    public OreGenCentered(NBTTagCompound tag) {
        super(tag);
        this.baseY = tag.func_74765_d("mainY");
        this.min = this.baseY - tag.func_74765_d("minY");
        this.max = tag.func_74765_d("maxY") - this.baseY;
    }

    public OreGenCentered(IBlockState state, int numB, float veins, BlockPredicate target, int minH, int mainH, int maxH) {
        super(state, numB, veins, target);
        this.min = mainH - minH;
        this.max = maxH - mainH;
        this.baseY = mainH;
    }

    @Override
    public void generate(Chunk chunk, Random rand) {
        int x = chunk.field_76635_g << 4;
        int z = chunk.field_76647_h << 4;
        boolean side = this.max < this.min;
        for (int n = this.veins(rand); n > 0; --n) {
            int r = rand.nextInt();
            float f = (float)((r & 0xFFF) + (r >> 12 & 0xFFF) - 4095) / 4095.0f;
            if (side) {
                if ((f *= this.min) > this.max) {
                    f = this.max - (f - this.max) / (this.min - this.max) * (this.min + this.max);
                }
            } else {
                if ((f *= this.max) > this.min) {
                    f = this.min - (f - this.min) / (this.max - this.min) * (this.max + this.min);
                }
                f = -f;
            }
            this.genOreVein(chunk.func_177412_p(), x + (r >> 24 & 0xF), this.baseY + MathHelper.func_76141_d((float)f), z + (r >> 28 & 0xF), rand);
        }
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = super.writeNBT();
        nbt.func_74777_a("mainY", (short)this.baseY);
        nbt.func_74777_a("minY", (short)((float)this.baseY - this.min));
        nbt.func_74777_a("maxY", (short)((float)this.baseY + this.max));
        return nbt;
    }

    @Override
    public String getRegistryName() {
        return "center";
    }
}

