/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.worldgen;

import cd4017be.dimstack.api.TerrainGeneration;
import cd4017be.dimstack.api.gen.ITerrainGenerator;
import cd4017be.dimstack.api.util.BlockPredicate;
import java.util.Arrays;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;

public class NoiseLayerGen
implements ITerrainGenerator {
    public static final String ID = "noiseLayer";
    private final int minY;
    private final int maxY;
    private final int source;
    private final IBlockState[] blocks;
    private final float[] levels;
    private final float gradient;

    public NoiseLayerGen(NBTTagCompound nbt) {
        this.minY = nbt.func_74771_c("minY") & 0xFF;
        this.maxY = (nbt.func_74771_c("maxY") & 0xFF) + 1;
        this.source = nbt.func_74771_c("Ngen") & 0xFF;
        this.gradient = nbt.func_74760_g("grad");
        NBTTagList list = nbt.func_150295_c("blocks", 10);
        int n = list.func_74745_c();
        this.blocks = new IBlockState[n];
        this.levels = new float[n - 1];
        for (int i = 0; i < n; ++i) {
            String s;
            NBTTagCompound tag = list.func_150305_b(i);
            if (i < n - 1) {
                this.levels[i] = tag.func_74760_g("<=");
            }
            this.blocks[i] = (s = tag.func_74779_i("b")).isEmpty() ? null : BlockPredicate.parse(s);
        }
    }

    public NoiseLayerGen(IBlockState[] blocks, float[] levels, float gradient, int minY, int maxY, int source) {
        if (blocks.length != levels.length + 1) {
            throw new IllegalArgumentException("There must be exactly one discriminator value inbetween each Block entry!");
        }
        float f = Float.NEGATIVE_INFINITY;
        for (float l : levels) {
            if (!(l > f)) {
                throw new IllegalArgumentException("Discriminatior values must be sorted in ascending order!");
            }
            f = l;
        }
        this.minY = minY;
        this.maxY = maxY;
        this.source = source;
        this.blocks = blocks;
        this.levels = levels;
        this.gradient = gradient;
    }

    @Override
    public String getRegistryName() {
        return ID;
    }

    @Override
    public NBTTagCompound writeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("minY", (byte)this.minY);
        nbt.func_74774_a("maxY", (byte)(this.maxY - 1));
        nbt.func_74774_a("Ngen", (byte)this.source);
        nbt.func_74776_a("grad", this.gradient);
        NBTTagList list = new NBTTagList();
        int n = this.blocks.length;
        for (int i = 0; i < n; ++i) {
            NBTTagCompound tag = new NBTTagCompound();
            if (i < n - 1) {
                tag.func_74776_a("<=", this.levels[i]);
            }
            if (this.blocks[i] != null) {
                tag.func_74778_a("b", BlockPredicate.serialize(this.blocks[i]));
            }
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("blocks", (NBTBase)list);
        return nbt;
    }

    @Override
    public void initNoise(TerrainGeneration cfg) {
        cfg.noiseFields[this.source].provideRange(this.minY, this.maxY);
    }

    @Override
    public void generate(World world, ChunkPrimer cp, int cx, int cz, TerrainGeneration cfg) {
        IBlockState[] blocks = this.blocks;
        float[] levels = this.levels;
        float a = this.gradient;
        float b = 1.0f / (float)(this.maxY - this.minY);
        cfg.noiseFields[this.source].generate(this.minY, this.maxY, (x, y, z, f) -> {
            int i = Arrays.binarySearch(levels, (float)f * a + (float)y * b);
            IBlockState state = blocks[i < 0 ? -1 - i : i];
            if (state != null) {
                cp.func_177855_a(x, y, z, state);
            }
        });
    }
}

