/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.worldgen;

import cd4017be.api.recipes.RecipeAPI;
import cd4017be.dimstack.api.BlockReplacements;
import cd4017be.dimstack.api.util.BlockPredicate;
import cd4017be.dimstack.command.Regen;
import cd4017be.dimstack.core.PortalConfiguration;
import cd4017be.dimstack.util.DebugInfo;
import cd4017be.lib.script.Parameters;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockReplacer
implements IWorldGenerator,
RecipeAPI.IRecipeHandler {
    private static final String BEDROCK_REPL = "bedrockRepl";
    private static final String BLOCK_REPL = "blockRepl";

    public BlockReplacer() {
        RecipeAPI.Handlers.put(BEDROCK_REPL, this);
        RecipeAPI.Handlers.put(BLOCK_REPL, this);
        GameRegistry.registerWorldGenerator((IWorldGenerator)this, (int)-1000);
        Regen.generators.put(BLOCK_REPL, this);
    }

    public void addRecipe(Parameters param) {
        String key = param.getString(0);
        int n = 2;
        BlockPredicate target = key.equals(BEDROCK_REPL) ? new BlockPredicate(Blocks.field_150357_h.getRegistryName().toString()) : BlockPredicate.parse(param.get(n++));
        IBlockState repl = BlockPredicate.parse((String)param.get(n++, String.class));
        double[] vec = param.getVector(n);
        if (vec.length != 2) {
            throw new IllegalArgumentException("height parameter must have 2 elements");
        }
        BlockReplacements.Replacement r = new BlockReplacements.Replacement(target, repl, (int)vec[0], (int)vec[1]);
        PortalConfiguration.get((int)((int)param.getNumber((int)1))).getSettings(BlockReplacements.class, (boolean)true).replacements.add(r);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator gen, IChunkProvider chunkProvider) {
        BlockReplacements repl;
        PortalConfiguration pc = PortalConfiguration.get(world);
        if (gen != null) {
            pc.getSettings(DebugInfo.class, true).genTerrainLate(pc, gen, world, chunkX, chunkZ);
        }
        if ((repl = pc.getSettings(BlockReplacements.class, false)) != null) {
            for (BlockReplacements.Replacement r : repl.replacements) {
                r.doReplace(world, chunkX, chunkZ);
            }
        }
    }
}

