/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.tileentity;

import cd4017be.dimstack.Objects;
import cd4017be.dimstack.core.PortalConfiguration;
import cd4017be.lib.TickRegistry;
import cd4017be.lib.block.AdvancedBlock;
import cd4017be.lib.tileentity.BaseTileEntity;
import cd4017be.lib.util.DimPos;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class DimensionalPipe
extends BaseTileEntity
implements AdvancedBlock.INeighborAwareTile,
TickRegistry.IUpdatable,
AdvancedBlock.IInteractiveTile {
    private static final byte ITEM = 1;
    private static final byte FLUID = 2;
    private static final Object[] NULL_CAPS = new Object[]{null, EmptyHandler.INSTANCE, EmptyFluidHandler.INSTANCE};
    protected EnumFacing side;
    protected DimensionalPipe linkTile;
    protected IBlockState conBlock = Blocks.field_150350_a.func_176223_P();
    private byte hasCap;
    private boolean updateLink;
    private boolean updateCon;

    protected void link(DimensionalPipe tile) {
        if (tile != this.linkTile) {
            this.linkTile = tile;
            if (!this.unloaded && tile != null) {
                this.onConTileChange(tile.field_145850_b.func_180495_p(tile.field_174879_c.func_177972_a(tile.side)));
            }
        }
        this.updateLink = false;
    }

    public void process() {
        if (this.unloaded) {
            return;
        }
        if (this.updateLink) {
            this.updateLink = false;
            DimPos linkPos = PortalConfiguration.getAdjacentPos(new DimPos((TileEntity)this), false);
            if (linkPos == null) {
                return;
            }
            TileEntity te = linkPos.getTileEntity();
            if (te instanceof DimensionalPipe) {
                this.link((DimensionalPipe)te);
                this.linkTile.link(this);
            } else {
                this.link(null);
            }
        }
        if (this.updateCon) {
            if (this.linkTile != null && !this.linkTile.unloaded) {
                this.linkTile.onConTileChange(this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(this.side)));
            }
            this.updateCon = false;
        }
    }

    private void onConTileChange(IBlockState state) {
        if (this.conBlock != state) {
            this.conBlock = state;
            this.field_145850_b.func_190524_a(this.field_174879_c.func_177972_a(this.side), this.field_145854_h, this.field_174879_c);
        }
    }

    public void onLoad() {
        super.onLoad();
        this.updateCon = true;
        this.updateLink = true;
        if (!this.field_145850_b.field_72995_K) {
            TickRegistry.instance.updates.add(this);
        }
        this.side = this.field_174879_c.func_177956_o() == 0 ? EnumFacing.UP : EnumFacing.DOWN;
    }

    protected void onUnload() {
        super.onUnload();
        if (this.linkTile != null && this.linkTile.linkTile == this) {
            this.linkTile.link(null);
        }
        this.linkTile = null;
    }

    public void neighborBlockChange(Block b, BlockPos src) {
        if (!this.updateCon && this.field_174879_c.func_177972_a(this.side).equals((Object)src)) {
            this.updateCon = true;
            TickRegistry.instance.updates.add(this);
        }
    }

    public void neighborTileChange(TileEntity te, EnumFacing side) {
    }

    private TileEntity getCon() {
        return this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.side));
    }

    public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
        int type;
        if (facing != this.side) {
            return false;
        }
        int n = cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? 1 : (type = cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? 2 : 0);
        if (this.linkTile != null && !this.linkTile.unloaded) {
            TileEntity te = this.linkTile.getCon();
            if (te != null && te.hasCapability(cap, this.linkTile.side.func_176734_d())) {
                this.hasCap = (byte)(this.hasCap | type);
                return true;
            }
            this.hasCap = (byte)(this.hasCap & ~type);
            return false;
        }
        return (this.hasCap & type) != 0;
    }

    public <T> T getCapability(Capability<T> cap, EnumFacing facing) {
        int type;
        if (facing != this.side) {
            return null;
        }
        int n = cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? 1 : (type = cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY ? 2 : 0);
        if (this.linkTile != null && !this.linkTile.unloaded) {
            TileEntity te = this.linkTile.getCon();
            Object c = te != null ? te.getCapability(cap, this.linkTile.side.func_176734_d()) : null;
            this.hasCap = c != null ? (byte)(this.hasCap | type) : (byte)(this.hasCap & ~type);
            return (T)c;
        }
        if ((this.hasCap & type) != 0) {
            return (T)NULL_CAPS[type];
        }
        return null;
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack item, EnumFacing s, float X, float Y, float Z) {
        if (!player.func_70093_af() || !item.func_190926_b()) {
            return false;
        }
        if (this.field_145850_b.field_72995_K) {
            return true;
        }
        DimPos posT = new DimPos((TileEntity)this);
        DimPos posO = PortalConfiguration.getAdjacentPos(posT);
        if (posO != null) {
            posO.setBlock(Objects.PORTAL.func_176223_P());
            Objects.PORTAL.syncStates(posT, Objects.PORTAL.func_176223_P());
            player.func_191521_c(new ItemStack((Item)Objects.dim_pipe));
        }
        return true;
    }

    public void onClicked(EntityPlayer player) {
    }

    protected void storeState(NBTTagCompound nbt, int mode) {
        nbt.func_74777_a("con", (short)Block.func_176210_f((IBlockState)this.conBlock));
    }

    protected void loadState(NBTTagCompound nbt, int mode) {
        this.conBlock = Block.func_176220_d((int)nbt.func_74765_d("con"));
    }
}

