/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.asm;

import cd4017be.dimstack.Main;
import cd4017be.dimstack.api.DisabledPortals;
import cd4017be.dimstack.api.util.BlockPredicate;
import cd4017be.dimstack.asm.BlockPortalTransformer;
import cd4017be.dimstack.asm.ChunkPrimerTransformer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.world.chunk.ChunkPrimer;

public class Test {
    public static void run() {
        Main.LOG.info("Testing ClassTransformer result of {} for correct functionality ...", ChunkPrimerTransformer.class);
        try {
            Test.dryTest();
            Main.LOG.info("dryTest passed!");
        }
        catch (Throwable e) {
            Main.LOG.fatal("dryTest failed! Please report this to the mod author!", e);
        }
        try {
            Test.mainTest();
            Main.LOG.info("mainTest passed!");
        }
        catch (Throwable e) {
            Main.LOG.fatal("mainTest failed! Please report this to the mod author!", e);
        }
        Main.LOG.info("Testing ClassTransformer result of {} for correct functionality ...", BlockPortalTransformer.class);
        try {
            Test.portalTest();
            Main.LOG.info("portalTest passed!");
        }
        catch (Throwable e) {
            Main.LOG.fatal("portalTest failed! Please report this to the mod author!", e);
        }
    }

    private static void dryTest() throws Exception {
        ChunkPrimer cp = new ChunkPrimer();
        IBlockState in = Blocks.field_150348_b.func_176223_P();
        cp.func_177855_a(8, 25, 8, in);
        Test.assEq(in, cp.func_177856_a(8, 25, 8), "Non blacklisted block was not placed:");
        cp.func_177855_a(8, 25, 8, null);
        Test.assEq(Blocks.field_150350_a.func_176223_P(), cp.func_177856_a(8, 25, 8), "Default block was not placed:");
    }

    private static void mainTest() throws Exception {
        ChunkPrimer cp = new ChunkPrimer();
        IBlockState in = Blocks.field_150348_b.func_176223_P();
        IBlockState bl = Blocks.field_150343_Z.func_176223_P();
        BlockPredicate.disableBlock(cp, bl);
        cp.func_177855_a(8, 25, 8, in);
        Test.assEq(in, cp.func_177856_a(8, 25, 8), "Non blacklisted block was not placed:");
        cp.func_177855_a(8, 25, 8, bl);
        Test.assEq(in, cp.func_177856_a(8, 25, 8), "Blacklisted block was placed:");
        cp.func_177855_a(8, 25, 8, null);
        Test.assEq(Blocks.field_150350_a.func_176223_P(), cp.func_177856_a(8, 25, 8), "Default block was not placed:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void portalTest() throws Exception {
        String key = "nether";
        DisabledPortals cfg = Main.dimstack.getSettings(DisabledPortals.class, true);
        boolean disabled = cfg.contains("nether");
        try {
            cfg.remove("nether");
            try {
                Blocks.field_150427_aO.func_176548_d(null, null);
                throw new Exception("BlockPortal didn't try to place portal although nether portal enabled!");
            }
            catch (NullPointerException nullPointerException) {
                cfg.add("nether");
                try {
                    Blocks.field_150427_aO.func_176548_d(null, null);
                }
                catch (NullPointerException e) {
                    throw new Exception("BlockPortal tried to place portal although nether portal disabled!", e);
                }
                if (disabled) {
                    cfg.add("nether");
                } else {
                    cfg.remove("nether");
                }
            }
        }
        catch (Throwable throwable) {
            if (disabled) {
                cfg.add("nether");
            } else {
                cfg.remove("nether");
            }
            throw throwable;
        }
    }

    private static void assEq(IBlockState exp, IBlockState got, String message) throws Exception {
        if (exp != got) {
            throw new Exception(message + " expected " + BlockPredicate.serialize(exp) + " but got " + BlockPredicate.serialize(got) + ".");
        }
    }
}

