/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.api.util;

import cd4017be.dimstack.api.util.BlockPlacer;
import java.util.Arrays;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class NoiseField {
    public final double hScale;
    public final double vScale;
    public final int hGrid;
    public final int vGrid;
    public NoiseGenerator gen;
    private int[] ranges;
    private double[][] fieldBuffers;
    private int offsetY = 0;

    public NoiseField(int hGrid, int vGrid, double hScale, double vScale) {
        if (hGrid <= 0 || hGrid > 16 || (hGrid & -hGrid) != hGrid) {
            throw new IllegalArgumentException("invalid grid interval!");
        }
        this.hScale = hScale;
        this.vScale = vScale;
        this.hGrid = hGrid;
        this.vGrid = vGrid;
    }

    public NoiseField clone() {
        return new NoiseField(this.hGrid, this.vGrid, this.hScale, this.vScale).setGenerator(this.gen);
    }

    public NoiseField provideRange(int y0, int y1) {
        int g = this.vGrid;
        if (g <= 0) {
            if (this.ranges == null) {
                this.provideLayer(0);
            }
            return this;
        }
        if (y0 >= y1) {
            throw new IllegalArgumentException("upper bound must be greater than lower bound!");
        }
        y0 += this.offsetY;
        y1 += this.offsetY;
        if (g != 1) {
            y0 = Math.floorDiv(y0, g);
            y1 = Math.floorDiv(y1 - 1, g) + 2;
        }
        if (this.ranges == null) {
            this.ranges = new int[]{y0, y1};
            return this;
        }
        int i0 = this.segIndex(y0);
        int i1 = this.segIndex(y1);
        int l = this.ranges.length;
        int l1 = l - i1;
        int l0 = i0 + (~i0 & 1) + (~i1 & 1);
        int[] na = new int[l0 + l1];
        if ((i0 & 1) == 0) {
            na[i0] = y0;
        }
        if ((i1 & 1) == 0) {
            na[l0 - 1] = y1;
        }
        System.arraycopy(this.ranges, 0, na, 0, i0);
        System.arraycopy(this.ranges, i1, na, l0, l1);
        this.ranges = na;
        return this;
    }

    public NoiseField provideLayer(int y) {
        int g = this.vGrid;
        if (g > 0) {
            return this.provideRange(y, y + 1);
        }
        y += this.offsetY;
        if (this.ranges == null) {
            this.ranges = new int[]{y};
            return this;
        }
        int l = this.ranges.length;
        this.ranges = Arrays.copyOf(this.ranges, l + 1);
        this.ranges[l] = y;
        return this;
    }

    public NoiseField setOffsetY(int ofsY) {
        this.offsetY = ofsY;
        return this;
    }

    public NoiseField setGenerator(NoiseGenerator gen) {
        this.gen = gen;
        return this;
    }

    private int segIndex(int y) {
        int i = Arrays.binarySearch(this.ranges, y);
        if (i >= 0) {
            return i + 1;
        }
        return -1 - i;
    }

    public void prepareFor(int x, int z) {
        double hScale = this.hScale;
        double yScale = this.vScale;
        int g = this.hGrid;
        int dh = g == 1 ? 16 : 16 / g + 1;
        x = (x << 4) / g;
        z = (z << 4) / g;
        boolean flat = this.vGrid <= 0;
        int[] ranges = this.ranges;
        if (ranges == null) {
            return;
        }
        int l = ranges.length >> (flat ? 0 : 1);
        Object fields = this.fieldBuffers;
        if (fields == null) {
            double[][] dArrayArray = new double[l][];
            fields = dArrayArray;
            this.fieldBuffers = dArrayArray;
        }
        for (int i = 0; i < l; ++i) {
            int y;
            double[] f = fields[i];
            if (flat) {
                y = ranges[i];
                if (this.gen instanceof NoiseGeneratorOctaves) {
                    f = ((NoiseGeneratorOctaves)this.gen).func_76304_a(f, x, y, z, dh, 1, dh, hScale, yScale, hScale);
                } else if (this.gen instanceof NoiseGeneratorPerlin) {
                    f = ((NoiseGeneratorPerlin)this.gen).func_151599_a(f, (double)x, (double)z, dh, dh, hScale, hScale, yScale);
                } else if (f == null) {
                    f = new double[dh * dh];
                }
            } else {
                y = ranges[i << 1];
                int dy = ranges[i << 1 | 1] - y;
                if (this.gen instanceof NoiseGeneratorOctaves) {
                    f = ((NoiseGeneratorOctaves)this.gen).func_76304_a(f, x, y, z, dh, dy, dh, hScale, yScale, hScale);
                } else if (f == null) {
                    f = new double[dh * dh * dy];
                }
            }
            fields[i] = f;
        }
    }

    public int getIndex(int y) {
        y += this.offsetY;
        int g = this.vGrid;
        if (g <= 0) {
            int i = Arrays.binarySearch(this.ranges, y);
            if (i >= 0) {
                return i;
            }
            return Math.min(-i, this.ranges.length) - 1;
        }
        int i = this.segIndex(y / g);
        if ((i & 1) == 0) {
            return -1;
        }
        return i >> 1;
    }

    public int getYOffset(int i) {
        int g = this.vGrid;
        return (g <= 0 ? this.ranges[i] : this.ranges[i << 1] * g) - this.offsetY;
    }

    public double[] getField(int i) {
        return this.fieldBuffers[i];
    }

    public void generate(int y0, int y1, BlockPlacer p) {
        int idx = this.getIndex(y0);
        if (idx < 0) {
            throw new IllegalStateException("height range not registered: " + y0 + " to " + y1);
        }
        double[] f = this.getField(idx);
        if (this.vGrid > 0) {
            NoiseField.interpolate3D(f, this.hGrid, this.vGrid, this.getYOffset(idx), y0, y1, p);
        } else {
            NoiseField.interpolate2D(f, this.hGrid, y0, y1, p);
        }
    }

    public static void interpolate3D(double[] field, int hGrid, int vGrid, int yOffset, int y0, int y1, BlockPlacer p) {
        int Y0 = (y0 - yOffset) / vGrid;
        if (hGrid == 1) {
            int nY = field.length / 256;
            int i = 0;
            for (int bx = 0; bx < 16; ++bx) {
                int bz = 0;
                while (bz < 16) {
                    int by = y0;
                    int y = (y0 - yOffset) % vGrid;
                    int Y = Y0;
                    while (by < y1) {
                        double f = field[i * nY + Y + 0];
                        double d = (field[i * nY + Y + 1] - f) / (double)vGrid;
                        while (y < vGrid && by < y1) {
                            p.place(bx, by, bz, f);
                            f += d;
                            ++y;
                            ++by;
                        }
                        ++Y;
                        y = 0;
                    }
                    ++bz;
                    ++i;
                }
            }
        } else {
            int nh = 16 / hGrid;
            int nH = nh + 1;
            int nY = field.length / nH / nH;
            for (int X = 0; X < nh; ++X) {
                for (int Z = 0; Z < nh; ++Z) {
                    int by = y0;
                    int y = (y0 - yOffset) % vGrid;
                    int Y = Y0;
                    while (by < y1) {
                        double f00 = field[((X + 0) * nH + Z + 0) * nY + Y + 0];
                        double f01 = field[((X + 0) * nH + Z + 1) * nY + Y + 0];
                        double f10 = field[((X + 1) * nH + Z + 0) * nY + Y + 0];
                        double f11 = field[((X + 1) * nH + Z + 1) * nY + Y + 0];
                        double d00 = (field[((X + 0) * nH + Z + 0) * nY + Y + 1] - f00) / (double)vGrid;
                        double d01 = (field[((X + 0) * nH + Z + 1) * nY + Y + 1] - f01) / (double)vGrid;
                        double d10 = (field[((X + 1) * nH + Z + 0) * nY + Y + 1] - f10) / (double)vGrid;
                        double d11 = (field[((X + 1) * nH + Z + 1) * nY + Y + 1] - f11) / (double)vGrid;
                        while (y < vGrid && by < y1) {
                            double f0 = f00;
                            double f1 = f01;
                            double d0 = (f10 - f00) / (double)hGrid;
                            double d1 = (f11 - f01) / (double)hGrid;
                            for (int x = 0; x < hGrid; ++x) {
                                int bx = x + X * hGrid;
                                double f = f0;
                                double d = (f1 - f0) / (double)hGrid;
                                for (int z = 0; z < hGrid; ++z) {
                                    int bz = z + Z * hGrid;
                                    p.place(bx, by, bz, f);
                                    f += d;
                                }
                                f0 += d0;
                                f1 += d1;
                            }
                            f00 += d00;
                            f01 += d01;
                            f10 += d10;
                            f11 += d11;
                            ++y;
                            ++by;
                        }
                        ++Y;
                        y = 0;
                    }
                }
            }
        }
    }

    public static void interpolate2D(double[] field, int hGrid, int y0, int y1, BlockPlacer p) {
        if (hGrid == 1) {
            int i = 0;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    double f = field[i++];
                    for (int y = y0; y < y1; ++y) {
                        p.place(x, y, z, f);
                    }
                }
            }
        } else {
            int nh = 16 / hGrid;
            int nH = nh + 1;
            for (int X = 0; X < nh; ++X) {
                for (int Z = 0; Z < nh; ++Z) {
                    double f0 = field[(X + 0) * nH + Z + 0];
                    double f1 = field[(X + 0) * nH + Z + 1];
                    double d0 = (field[(X + 1) * nH + Z + 0] - f0) / (double)hGrid;
                    double d1 = (field[(X + 1) * nH + Z + 1] - f1) / (double)hGrid;
                    for (int x = 0; x < hGrid; ++x) {
                        int bx = x + X * hGrid;
                        double f = f0;
                        double d = (f1 - f0) / (double)hGrid;
                        for (int z = 0; z < hGrid; ++z) {
                            int bz = z + Z * hGrid;
                            for (int by = y0; by < y1; ++by) {
                                p.place(bx, by, bz, f);
                            }
                            f += d;
                        }
                        f0 += d0;
                        f1 += d1;
                    }
                }
            }
        }
    }
}

