/*
 * Decompiled with CFR 0.152.
 */
package cd4017be.dimstack.api;

import cd4017be.dimstack.api.IDimensionSettings;
import cd4017be.dimstack.api.util.NoiseField;
import java.util.Random;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.gen.NoiseGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;

public class SharedNoiseFields
implements IDimensionSettings {
    private static final long MAGIC = -851437634L;
    public byte[] octaves;
    public byte[] source;
    public NoiseGenerator[] noiseGens;
    public Random rand;
    public NoiseField[] noiseFields;

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74773_a("octaves", this.octaves);
        NBTTagList list = new NBTTagList();
        int n = 0;
        for (NoiseField nf : this.noiseFields) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("hg", (byte)nf.hGrid);
            tag.func_74774_a("vg", (byte)nf.vGrid);
            tag.func_74780_a("hs", nf.hScale);
            tag.func_74780_a("vs", nf.vScale);
            tag.func_74774_a("src", this.source[n++]);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("fields", (NBTBase)list);
        return nbt;
    }

    public void deserializeNBT(NBTBase tag) {
        NBTTagCompound nbt = (NBTTagCompound)tag;
        this.octaves = nbt.func_74770_j("octaves");
        this.noiseGens = new NoiseGenerator[this.octaves.length];
        NBTTagList list = nbt.func_150295_c("fields", 10);
        this.source = new byte[list.func_74745_c()];
        this.noiseFields = new NoiseField[this.source.length];
        for (int i = 0; i < this.source.length; ++i) {
            NBTTagCompound ctag = list.func_150305_b(i);
            this.source[i] = ctag.func_74771_c("src");
            this.noiseFields[i] = new NoiseField(ctag.func_74771_c("hg"), ctag.func_74771_c("vg") & 0xFF, ctag.func_74769_h("hs"), ctag.func_74769_h("vs"));
        }
    }

    public void init(long seed) {
        if (this.rand != null) {
            return;
        }
        this.rand = new Random(seed + -851437634L);
        if (this.noiseGens == null) {
            this.noiseGens = new NoiseGenerator[this.octaves.length];
        }
        for (byte o : this.octaves) {
            this.noiseGens[i] = o > 0 ? new NoiseGeneratorOctaves(this.rand, (int)o) : new NoiseGeneratorPerlin(this.rand, (int)(-o));
        }
        int n = this.source.length;
        for (int i = 0; i < n; ++i) {
            byte s = this.source[i];
            if (s < 0 || s >= this.noiseGens.length) continue;
            this.noiseFields[i].setGenerator(this.noiseGens[i]);
        }
    }
}

