/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.spawnercontrol;

import javax.annotation.Nullable;
import ladysnake.spawnercontrol.config.MSCConfig;
import ladysnake.spawnercontrol.config.SpawnerConfig;
import ladysnake.spawnercontrol.controlledspawner.CapabilityControllableSpawner;
import ladysnake.spawnercontrol.controlledspawner.IControllableSpawner;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class SpawnerUtil {
    @Nullable
    public static SpawnerConfig getConfig(@Nullable NBTBase nbt) {
        WorldServer world;
        long spawnerPos;
        if (nbt instanceof NBTTagCompound && ((NBTTagCompound)nbt).func_74764_b("pos")) {
            spawnerPos = ((NBTTagCompound)nbt).func_74763_f("pos");
            world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(((NBTTagCompound)nbt).func_74762_e("dimension"));
        } else if (nbt instanceof NBTTagLong) {
            spawnerPos = ((NBTTagLong)nbt).func_150291_c();
            world = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(0);
        } else {
            return null;
        }
        return SpawnerUtil.getConfig((World)world, BlockPos.func_177969_a((long)spawnerPos));
    }

    @Nullable
    public static SpawnerConfig getConfig(World world, BlockPos spawnerPos) {
        TileEntity spawnerTE = world.func_175625_s(spawnerPos);
        if (!(spawnerTE instanceof TileEntityMobSpawner)) {
            return null;
        }
        if (MSCConfig.customSpawners.length == 0) {
            return MSCConfig.alterVanillaSpawner ? MSCConfig.vanillaSpawnerConfig : null;
        }
        SpawnerConfig ret = CapabilityControllableSpawner.getHandler((TileEntityMobSpawner)spawnerTE).getConfig();
        if (ret == MSCConfig.vanillaSpawnerConfig && !MSCConfig.alterVanillaSpawner) {
            return null;
        }
        return ret;
    }

    @Nullable
    public static IControllableSpawner getHandlerIfAffected(World world, BlockPos spawnerPos) {
        TileEntity spawnerTE = world.func_175625_s(spawnerPos);
        if (!(spawnerTE instanceof TileEntityMobSpawner)) {
            return null;
        }
        IControllableSpawner ret = CapabilityControllableSpawner.getHandler((TileEntityMobSpawner)spawnerTE);
        if (ret.getConfig() == MSCConfig.vanillaSpawnerConfig && !MSCConfig.alterVanillaSpawner) {
            return null;
        }
        return ret;
    }
}

