/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.util.internal;

import com.charles445.simpledifficulty.api.temperature.ITemperatureDynamicModifier;
import com.charles445.simpledifficulty.api.temperature.ITemperatureModifier;
import com.charles445.simpledifficulty.api.temperature.ITemperatureUtil;
import com.charles445.simpledifficulty.api.temperature.TemperatureEnum;
import com.charles445.simpledifficulty.api.temperature.TemperatureRegistry;
import com.charles445.simpledifficulty.util.WorldUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class TemperatureUtilInternal
implements ITemperatureUtil {
    private final String ARMOR_TEMPERATURE_TAG = "SDArmorTemp";

    @Override
    public int getPlayerTargetTemperature(EntityPlayer player) {
        float sum = 0.0f;
        World world = player.func_130014_f_();
        BlockPos pos = WorldUtil.getSidedBlockPos(world, (Entity)player);
        for (ITemperatureModifier modifier : TemperatureRegistry.modifiers.values()) {
            sum += modifier.getWorldInfluence(world, pos);
            sum += modifier.getPlayerInfluence(player);
        }
        for (ITemperatureDynamicModifier dynmodifier : TemperatureRegistry.dynamicModifiers.values()) {
            sum = dynmodifier.applyDynamicWorldInfluence(world, pos, sum);
            sum = dynmodifier.applyDynamicPlayerInfluence(player, sum);
        }
        return (int)sum;
    }

    @Override
    public int getWorldTemperature(World world, BlockPos pos) {
        float sum = 0.0f;
        for (ITemperatureModifier modifier : TemperatureRegistry.modifiers.values()) {
            sum += modifier.getWorldInfluence(world, pos);
        }
        for (ITemperatureDynamicModifier dynmodifier : TemperatureRegistry.dynamicModifiers.values()) {
            sum = dynmodifier.applyDynamicWorldInfluence(world, pos, sum);
        }
        return (int)sum;
    }

    @Override
    public int clampTemperature(int temperature) {
        return MathHelper.func_76125_a((int)temperature, (int)TemperatureEnum.FREEZING.getLowerBound(), (int)TemperatureEnum.BURNING.getUpperBound());
    }

    @Override
    public TemperatureEnum getTemperatureEnum(int temp) {
        for (TemperatureEnum temp_enum : TemperatureEnum.values()) {
            if (!temp_enum.matches(temp)) continue;
            return temp_enum;
        }
        if (temp < 0) {
            return TemperatureEnum.FREEZING;
        }
        return TemperatureEnum.BURNING;
    }

    @Override
    public void setArmorTemperatureTag(ItemStack stack, float temperature) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound compound = stack.func_77978_p();
        compound.func_74776_a("SDArmorTemp", temperature);
    }

    @Override
    public float getArmorTemperatureTag(ItemStack stack) {
        NBTBase tempTag;
        NBTTagCompound compound;
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("SDArmorTemp") && (tempTag = compound.func_74781_a("SDArmorTemp")) instanceof NBTTagFloat) {
            return ((NBTTagFloat)tempTag).func_150288_h();
        }
        return 0.0f;
    }

    @Override
    public void removeArmorTemperatureTag(ItemStack stack) {
        NBTTagCompound compound;
        if (stack.func_77942_o() && (compound = stack.func_77978_p()).func_74764_b("SDArmorTemp")) {
            compound.func_82580_o("SDArmorTemp");
        }
    }
}

