/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.tileentity;

import com.charles445.simpledifficulty.api.SDBlocks;
import com.charles445.simpledifficulty.block.BlockCampfire;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.util.SoundUtil;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntitySpit
extends TileEntity
implements ITickable {
    private static final String NBT_INT_PROGRESS = "progress";
    private static final String NBT_DOUBLE_EXPERIENCE = "experience";
    private static final String NBT_TAG_ITEMS = "items";
    public ItemHandler items;
    private int progress = 0;
    private double experience = 0.0;
    private int timer = 0;

    public TileEntitySpit() {
        this.items = new ItemHandler(ModConfig.server.miscellaneous.campfireSpitSize);
    }

    public void func_73660_a() {
        if (this.timer % 20 == 0) {
            this.timer = 0;
            this.secondUpdate();
        }
        ++this.timer;
    }

    private void secondUpdate() {
        if (this.shouldCook()) {
            ++this.progress;
            if (this.progress >= ModConfig.server.miscellaneous.campfireSpitDelay) {
                this.cookFood();
                this.progress = 0;
            }
        }
    }

    private void cookFood() {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack stack = this.items.getStackInSlot(i);
            if (!this.isCookable(stack)) continue;
            ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack).func_77946_l();
            if (ModConfig.server.miscellaneous.campfireSpitExperience) {
                this.experience += (double)FurnaceRecipes.func_77602_a().func_151398_b(result);
            }
            this.items.setStackInSlot(i, result);
        }
    }

    private boolean playWorldSound(World world, BlockPos pos, boolean deposit) {
        SoundUtil.serverPlayBlockSound(world, pos, SoundEvents.field_187724_dU, 0.4f, 0.9f);
        return true;
    }

    public void handleRightClick(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        int i;
        ItemStack heldItemStack = player.func_184586_b(hand);
        boolean rawWithdraw = heldItemStack.func_190926_b();
        boolean playedSound = false;
        boolean found = false;
        boolean withdrewToHand = false;
        for (i = 0; i < this.items.getSlots(); ++i) {
            if (!this.isCooked(this.items.getStackInSlot(i))) continue;
            withdrewToHand = this.withdrawFromSlot(player, hand, i);
            this.dumpExperience(world, pos);
            if (!playedSound) {
                playedSound = this.playWorldSound(world, pos, false);
            }
            found = true;
            break;
        }
        if (!withdrewToHand && this.isCookable(heldItemStack)) {
            int i2;
            String heldItemName = heldItemStack.func_77973_b().getRegistryName().toString();
            boolean isBlacklisted = false;
            String[] spitBlacklist = ModConfig.server.miscellaneous.campfireSpitBlacklist;
            for (i2 = 0; i2 < spitBlacklist.length; ++i2) {
                if (!spitBlacklist[i2].equals(heldItemName)) continue;
                isBlacklisted = true;
                break;
            }
            if (isBlacklisted == ModConfig.server.miscellaneous.campfireSpitBlacklistIsWhitelist) {
                for (i2 = 0; i2 < this.items.getSlots(); ++i2) {
                    if (!this.items.getStackInSlot(i2).func_190926_b()) continue;
                    this.items.insertItem(i2, new ItemStack(heldItemStack.func_77973_b(), 1, heldItemStack.func_77952_i()), false);
                    heldItemStack.func_190918_g(1);
                    this.progress = 0;
                    if (!playedSound) {
                        playedSound = this.playWorldSound(world, pos, true);
                    }
                    found = true;
                    break;
                }
            }
        }
        if (!found && rawWithdraw && player.func_70093_af()) {
            for (i = 0; i < this.items.getSlots(); ++i) {
                if (this.items.getStackInSlot(i).func_190926_b()) continue;
                this.withdrawFromSlot(player, hand, i);
                if (playedSound) break;
                playedSound = this.playWorldSound(world, pos, false);
                break;
            }
        }
    }

    private boolean withdrawFromSlot(EntityPlayer player, EnumHand hand, int slot) {
        ItemStack stack = this.items.extractItem(slot, 1, false);
        if (player.func_184586_b(hand).func_190926_b()) {
            player.func_184611_a(hand, stack);
            return true;
        }
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
            return false;
        }
        if (player instanceof EntityPlayerMP) {
            ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
        }
        return false;
    }

    private boolean isCookable(ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        return !result.func_190926_b() && result.func_77973_b() instanceof ItemFood;
    }

    private boolean isCooked(ItemStack stack) {
        return !stack.func_190926_b() && !this.isCookable(stack);
    }

    private boolean shouldCook() {
        boolean hasItem = false;
        for (int i = 0; i < this.items.getSlots(); ++i) {
            if (!this.isCookable(this.items.getStackInSlot(i))) continue;
            hasItem = true;
            break;
        }
        if (!hasItem) {
            return false;
        }
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b());
        Block block = state.func_177230_c();
        if (block == SDBlocks.campfire) {
            return (Boolean)state.func_177229_b((IProperty)BlockCampfire.BURNING);
        }
        return false;
    }

    public void dumpItems(World world, BlockPos pos) {
        for (int i = 0; i < this.items.getSlots(); ++i) {
            ItemStack itemstack = this.items.getStackInSlot(i);
            if (!itemstack.func_190926_b()) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)itemstack);
            }
            this.items.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public void dumpExperience(World world, BlockPos pos) {
        int val;
        int convExp;
        this.experience -= (double)convExp;
        for (convExp = (int)this.experience; convExp > 0; convExp -= val) {
            val = EntityXPOrb.func_70527_a((int)convExp);
            this.field_145850_b.func_72838_d((Entity)new EntityXPOrb(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, val));
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.progress = compound.func_74762_e(NBT_INT_PROGRESS);
        this.items.deserializeNBT(compound.func_74775_l(NBT_TAG_ITEMS));
        this.experience = compound.func_74769_h(NBT_DOUBLE_EXPERIENCE);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a(NBT_INT_PROGRESS, this.progress);
        compound.func_74782_a(NBT_TAG_ITEMS, (NBTBase)this.items.serializeNBT());
        compound.func_74780_a(NBT_DOUBLE_EXPERIENCE, this.experience);
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
        this.updateClients();
    }

    public void updateClients() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    public class ItemHandler
    extends ItemStackHandler {
        public ItemHandler(int slots) {
            super(slots);
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntitySpit.this.func_70296_d();
            TileEntitySpit.this.updateClients();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    }
}

