/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.temperature;

import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.temperature.ModifierBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ModifierTime
extends ModifierBase {
    public ModifierTime() {
        super("Time");
    }

    @Override
    public float getWorldInfluence(World world, BlockPos pos) {
        if (!world.field_73011_w.func_76569_d()) {
            return 0.0f;
        }
        long time = world.func_72820_D() % 24000L;
        if (time < 12000L && !ModConfig.server.temperature.timeTemperatureDay) {
            return 0.0f;
        }
        if (time >= 12000L && !ModConfig.server.temperature.timeTemperatureNight) {
            return 0.0f;
        }
        float timetemperature = (Math.abs(((float)time % 12000.0f - 6000.0f) / 6000.0f) - 1.0f) * (float)ModConfig.server.temperature.timeMultiplier;
        if (time < 12000L) {
            timetemperature *= -1.0f;
        }
        float biomeMultiplier = 1.0f + Math.abs(this.normalizeToPlusMinus(this.getTempForBiome(world.func_180494_b(pos)))) * ((float)ModConfig.server.temperature.timeBiomeMultiplier - 1.0f);
        timetemperature *= biomeMultiplier;
        int shadeConf = ModConfig.server.temperature.timeTemperatureShade;
        if (timetemperature > 0.0f && shadeConf != 0 && !world.func_175678_i(pos) && !world.func_175678_i(pos.func_177984_a())) {
            timetemperature = Math.max(0.0f, timetemperature + (float)shadeConf);
        }
        return this.applyUndergroundEffect(timetemperature, world, pos);
    }
}

