/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.temperature;

import com.charles445.simpledifficulty.api.config.JsonConfig;
import com.charles445.simpledifficulty.api.config.ServerConfig;
import com.charles445.simpledifficulty.api.config.ServerOptions;
import com.charles445.simpledifficulty.api.config.json.JsonPropertyTemperature;
import com.charles445.simpledifficulty.api.temperature.ITemperatureTileEntity;
import com.charles445.simpledifficulty.config.JsonConfigInternal;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.temperature.ModifierBase;
import com.charles445.simpledifficulty.util.WorldUtil;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ModifierBlocksTiles
extends ModifierBase {
    private float coldestValue = 0.0f;
    private float hottestValue = 0.0f;
    private float coldestResultValue = 0.0f;
    private float hottestResultValue = 0.0f;
    private float hotTotal = 0.0f;
    private float coldTotal = 0.0f;

    public ModifierBlocksTiles() {
        super("BlocksTiles");
    }

    @Override
    public float getWorldInfluence(World world, BlockPos pos) {
        this.resetHeat();
        this.doBlocksRoutine(world, pos);
        if (ModConfig.server.temperature.blocksTilesSeparate) {
            float result = this.consolidateHeat();
            this.resetHeat();
            this.doTileEntitiesRoutine(world, pos);
            return result + this.consolidateHeat();
        }
        this.doTileEntitiesRoutine(world, pos);
        return this.consolidateHeat();
    }

    private void resetHeat() {
        this.coldestValue = 0.0f;
        this.hottestValue = 0.0f;
        this.coldestResultValue = 0.0f;
        this.hottestResultValue = 0.0f;
        this.hotTotal = 0.0f;
        this.coldTotal = 0.0f;
    }

    private float consolidateHeat() {
        float coldLogValue;
        if (!ModConfig.server.temperature.stackingTemperature) {
            return this.hottestValue + this.coldestValue;
        }
        this.hotTotal -= this.hottestValue;
        this.coldTotal -= this.coldestValue;
        float hotLogValue = this.hottestValue * (float)Math.sqrt(this.easyLog(this.hotTotal));
        float result = hotLogValue + (coldLogValue = this.coldestValue * (float)Math.sqrt(this.easyLog(this.coldTotal)));
        if (result > this.hottestValue) {
            return Math.min(this.hottestValue + (float)ModConfig.server.temperature.stackingTemperatureLimit, result);
        }
        if (result < this.coldestValue) {
            return Math.max(this.coldestValue - (float)ModConfig.server.temperature.stackingTemperatureLimit, result);
        }
        return result;
    }

    private void doBlocksRoutine(World world, BlockPos pos) {
        ChunkCache cache = new ChunkCache(world, pos.func_177982_a(-4, -3, -4), pos.func_177982_a(4, 1, 4), 0);
        for (int x = -4; x <= 4; ++x) {
            for (int y = -3; y <= 1; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    BlockPos blockpos = pos.func_177982_a(x, y, z);
                    IBlockState blockstate = cache.func_180495_p(blockpos);
                    Block block = blockstate.func_177230_c();
                    List<JsonPropertyTemperature> tempInfoList = JsonConfig.blockTemperatures.get(block.getRegistryName().toString());
                    if (tempInfoList != null) {
                        IBlockState actualBlockState = block.func_176221_a(blockstate, (IBlockAccess)cache, blockpos);
                        for (JsonPropertyTemperature tempInfo : tempInfoList) {
                            float blockTemp;
                            if (tempInfo == null || (blockTemp = tempInfo.temperature) == 0.0f || !tempInfo.matchesState(actualBlockState)) continue;
                            this.processTemp(blockTemp);
                        }
                        continue;
                    }
                    if (blockstate.func_185904_a() != Material.field_151581_o) continue;
                    this.processTemp(JsonConfigInternal.materialTemperature.fire);
                }
            }
        }
    }

    private void doTileEntitiesRoutine(World world, BlockPos pos) {
        if (!ServerConfig.instance.getBoolean(ServerOptions.TEMPERATURE_TE_ENABLED)) {
            return;
        }
        FloatPair pair = new FloatPair();
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                this.checkChunkAndProcess(pair, world, pos.func_177982_a(x * 16, 0, z * 16), pos);
            }
        }
    }

    private void processTemp(float blockTemp) {
        if (blockTemp == 0.0f) {
            return;
        }
        if (blockTemp >= 0.0f) {
            this.processHot(blockTemp);
        } else {
            this.processCold(blockTemp);
        }
    }

    private void processHot(float blockTemp) {
        this.hotTotal += blockTemp;
        if (blockTemp > this.hottestValue) {
            this.hottestValue = blockTemp;
        }
    }

    private void processCold(float blockTemp) {
        this.coldTotal += blockTemp;
        if (blockTemp < this.coldestValue) {
            this.coldestValue = blockTemp;
        }
    }

    private void checkChunkAndProcess(FloatPair pair, World world, BlockPos pos, BlockPos selfPos) {
        if (WorldUtil.isChunkLoaded(world, pos)) {
            Chunk chunk = world.func_72863_F().func_186025_d(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            for (Map.Entry entry : chunk.func_177434_r().entrySet()) {
                this.processTemp(this.checkTileEntity(world, (BlockPos)entry.getKey(), (TileEntity)entry.getValue(), selfPos));
            }
        }
    }

    private float checkTileEntity(World world, BlockPos pos, TileEntity tileEntity, BlockPos selfPos) {
        double distance = pos.func_177951_i((Vec3i)selfPos);
        if (distance < 2500.0 && tileEntity instanceof ITemperatureTileEntity) {
            return ((ITemperatureTileEntity)tileEntity).getInfluence(selfPos, distance);
        }
        return 0.0f;
    }

    private float easyLog(float f) {
        if (f >= 0.0f) {
            return (float)Math.log10(f + 10.0f);
        }
        return (float)Math.log10(-1.0f * f + 10.0f);
    }

    private float easyLogPowTwo(float f) {
        float ff = this.easyLog(f);
        return ff * ff;
    }

    private float easyLogPowEight(float f) {
        float ff = this.easyLog(f);
        ff *= ff;
        ff *= ff;
        return ff * ff;
    }

    private class FloatPair {
        protected float high = 0.0f;
        protected float low = 0.0f;

        protected FloatPair() {
        }
    }
}

