/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.register.crafting;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;

public class RecipeUtil {
    public static CraftingHelper.ShapedPrimer getShapedPrimer(JsonContext context, JsonObject json) {
        HashMap ingMap = Maps.newHashMap();
        for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)json, (String)"key").entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)((JsonElement)entry.getValue()), (JsonContext)context));
        }
        ingMap.put(Character.valueOf(' '), Ingredient.field_193370_a);
        JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)json, (String)"pattern");
        if (patternJ.size() == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        String[] pattern = new String[patternJ.size()];
        for (int x = 0; x < pattern.length; ++x) {
            String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
            if (x > 0 && pattern[0].length() != line.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            pattern[x] = line;
        }
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.width = pattern[0].length();
        primer.height = pattern.length;
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
        primer.input = NonNullList.func_191197_a((int)(primer.width * primer.height), (Object)Ingredient.field_193370_a);
        HashSet keys = Sets.newHashSet(ingMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (String line : pattern) {
            for (char chr : line.toCharArray()) {
                Ingredient ing = (Ingredient)ingMap.get(Character.valueOf(chr));
                if (ing == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                }
                primer.input.set(x++, (Object)ing);
                keys.remove(Character.valueOf(chr));
            }
        }
        return primer;
    }

    public static NonNullList<Ingredient> getShapelessIngredients(JsonContext context, JsonObject json) {
        NonNullList ingList = NonNullList.func_191196_a();
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            ingList.add((Object)CraftingHelper.getIngredient((JsonElement)ele, (JsonContext)context));
        }
        if (ingList.isEmpty()) {
            throw new JsonParseException("No ingredients for shapeless recipe");
        }
        return ingList;
    }
}

