/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.register;

import com.charles445.simpledifficulty.api.SDBlocks;
import com.charles445.simpledifficulty.block.BlockCampfire;
import com.charles445.simpledifficulty.block.BlockRainCollector;
import com.charles445.simpledifficulty.block.BlockSpit;
import com.charles445.simpledifficulty.block.BlockTemperature;
import com.charles445.simpledifficulty.register.ModCreativeTab;
import com.charles445.simpledifficulty.tileentity.TileEntitySpit;
import com.charles445.simpledifficulty.tileentity.TileEntityTemperature;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegisterBlocks {

    @Mod.EventBusSubscriber(modid="simpledifficulty")
    public static class Registrar {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            SDBlocks.campfire = Registrar.registerAs("campfire", new BlockCampfire(), (IForgeRegistry<Block>)registry);
            SDBlocks.rainCollector = Registrar.registerAs("rain_collector", new BlockRainCollector(), (IForgeRegistry<Block>)registry);
            SDBlocks.heater = Registrar.registerAs("heater", (Block)new BlockTemperature(1.0f), (IForgeRegistry<Block>)registry);
            SDBlocks.chiller = Registrar.registerAs("chiller", (Block)new BlockTemperature(-1.0f), (IForgeRegistry<Block>)registry);
            SDBlocks.spit = Registrar.registerAs("spit", (Block)new BlockSpit(), (IForgeRegistry<Block>)registry);
            GameRegistry.registerTileEntity(TileEntitySpit.class, (ResourceLocation)new ResourceLocation("simpledifficulty", "campfirespit"));
            GameRegistry.registerTileEntity(TileEntityTemperature.class, (ResourceLocation)new ResourceLocation("simpledifficulty", "temperatureChanged"));
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            Registrar.registerItemBlock(SDBlocks.campfire, (IForgeRegistry<Item>)registry);
            Registrar.registerItemBlock(SDBlocks.rainCollector, (IForgeRegistry<Item>)registry);
            Registrar.registerItemBlock(SDBlocks.heater, (IForgeRegistry<Item>)registry);
            Registrar.registerItemBlock(SDBlocks.chiller, (IForgeRegistry<Item>)registry);
            Registrar.registerItemBlock(SDBlocks.spit, (IForgeRegistry<Item>)registry);
        }

        private static void registerItemBlock(Block block, IForgeRegistry<Item> registry) {
            registry.register(new ItemBlock(block).setRegistryName(block.getRegistryName()));
        }

        private static Block registerAs(String name, Block newBlock, IForgeRegistry<Block> registry) {
            newBlock.setRegistryName("simpledifficulty", name);
            newBlock.func_149663_c(newBlock.getRegistryName().toString());
            newBlock.func_149647_a((CreativeTabs)ModCreativeTab.instance);
            registry.register((IForgeRegistryEntry)newBlock);
            SDBlocks.blocks.put(name, newBlock);
            return newBlock;
        }
    }
}

