/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.proxy;

import com.charles445.simpledifficulty.client.command.ClientCommandCopy;
import com.charles445.simpledifficulty.client.command.ClientCommandIdentityCopy;
import com.charles445.simpledifficulty.client.gui.TemperatureGui;
import com.charles445.simpledifficulty.client.gui.TemperatureInfoGui;
import com.charles445.simpledifficulty.client.gui.ThirstGui;
import com.charles445.simpledifficulty.client.particle.ParticleChiller;
import com.charles445.simpledifficulty.client.particle.ParticleHeater;
import com.charles445.simpledifficulty.client.particle.ParticleTemperature;
import com.charles445.simpledifficulty.client.render.RenderSpit;
import com.charles445.simpledifficulty.compat.CompatController;
import com.charles445.simpledifficulty.handler.TooltipHandler;
import com.charles445.simpledifficulty.proxy.CommonProxy;
import com.charles445.simpledifficulty.tileentity.TileEntitySpit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.command.ICommand;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.client.ClientCommandHandler;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new TemperatureGui());
        MinecraftForge.EVENT_BUS.register((Object)new TemperatureInfoGui());
        MinecraftForge.EVENT_BUS.register((Object)new ThirstGui());
        MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
    }

    @Override
    public void init() {
        super.init();
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntitySpit.class, (TileEntitySpecialRenderer)new RenderSpit());
    }

    @Override
    public void postInit() {
        super.postInit();
        CompatController.setupClient();
        ClientCommandHandler.instance.func_71560_a((ICommand)new ClientCommandCopy());
        ClientCommandHandler.instance.func_71560_a((ICommand)new ClientCommandIdentityCopy());
    }

    @Override
    public Side getSide() {
        return Side.CLIENT;
    }

    @Override
    public EntityPlayer getClientMinecraftPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @Override
    public Boolean isClientConnectedToServer() {
        return Minecraft.func_71410_x().func_147114_u().func_147298_b().func_150724_d();
    }

    @Override
    public void spawnClientParticle(World world, String type, double xPos, double yPos, double zPos, double motionX, double motionY, double motionZ) {
        if (!world.field_72995_K) {
            return;
        }
        ParticleTemperature particle = null;
        switch (type) {
            case "HEATER": {
                particle = new ParticleHeater(world, xPos, yPos, zPos, motionX, motionY, motionZ);
                break;
            }
            case "CHILLER": {
                particle = new ParticleChiller(world, xPos, yPos, zPos, motionX, motionY, motionZ);
                break;
            }
        }
        if (particle != null) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
        }
    }
}

