/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.item;

import com.charles445.simpledifficulty.SimpleDifficulty;
import com.charles445.simpledifficulty.api.config.QuickConfig;
import com.charles445.simpledifficulty.api.temperature.TemperatureEnum;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.util.WorldUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemThermometer
extends Item {
    protected static Map<Integer, Long> hashAge = new HashMap<Integer, Long>();
    protected static Map<Integer, Float> hashTemp = new HashMap<Integer, Float>();
    protected static long lastAudit = 0L;

    @SideOnly(value=Side.CLIENT)
    protected static void audit(long worldTime) {
        if (worldTime - lastAudit >= 200L || worldTime < lastAudit) {
            lastAudit = worldTime;
            boolean mismatched = false;
            for (Integer key : hashTemp.keySet()) {
                if (hashAge.containsKey(key)) continue;
                mismatched = true;
            }
            for (Integer key : hashAge.keySet()) {
                if (hashTemp.containsKey(key)) continue;
                mismatched = true;
            }
            if (mismatched) {
                SimpleDifficulty.logger.warn("Thermometer audit had mismatched maps!");
                hashAge.clear();
                hashTemp.clear();
                return;
            }
            int removalCount = 0;
            HashSet<Integer> removalSet = new HashSet<Integer>();
            for (Map.Entry<Integer, Long> entry : hashAge.entrySet()) {
                if (worldTime - entry.getValue() < 100L && worldTime >= entry.getValue()) continue;
                removalSet.add(entry.getKey());
            }
            for (Integer value : removalSet) {
                hashAge.remove(value);
                hashTemp.remove(value);
                ++removalCount;
            }
            removalSet.clear();
        }
    }

    public ItemThermometer() {
        this.func_185043_a(new ResourceLocation("temperature"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World world, @Nullable EntityLivingBase pendingEntity) {
                EntityLivingBase entity;
                boolean hasEntity = pendingEntity != null;
                Object object = entity = hasEntity ? pendingEntity : stack.func_82836_z();
                if (world == null && entity != null) {
                    world = entity.field_70170_p;
                }
                if (world == null || entity == null) {
                    return 0.0f;
                }
                if (QuickConfig.isTemperatureEnabled() && ModConfig.client.thermometer.enableThermometer) {
                    return this.wobble(world, (Entity)entity, stack.hashCode());
                }
                return 0.0f;
            }

            @SideOnly(value=Side.CLIENT)
            private float wobble(World world, Entity entity, int hash) {
                Long age = hashAge.get(hash);
                Float temp = hashTemp.get(hash);
                long totalWorldTime = world.func_82737_E();
                ItemThermometer.audit(totalWorldTime);
                boolean cleanStart = false;
                if (age == null && temp == null) {
                    cleanStart = true;
                } else if (age == null || temp == null) {
                    hashAge.remove(hash);
                    hashTemp.remove(hash);
                    cleanStart = true;
                }
                if (cleanStart) {
                    hashAge.put(hash, totalWorldTime);
                    float newTemp = this.calculateTemperature(world, entity);
                    hashTemp.put(hash, Float.valueOf(newTemp));
                    return newTemp;
                }
                if (totalWorldTime - age >= 10L + (long)(hash & 7)) {
                    float newTemp = this.calculateTemperature(world, entity);
                    hashTemp.put(hash, Float.valueOf(newTemp));
                    hashAge.put(hash, totalWorldTime);
                    return newTemp;
                }
                return temp.floatValue();
            }

            @SideOnly(value=Side.CLIENT)
            private float calculateTemperature(World world, Entity entity) {
                int tempRange = TemperatureEnum.BURNING.getUpperBound() - TemperatureEnum.FREEZING.getLowerBound() + 1;
                return (float)WorldUtil.calculateClientWorldEntityTemperature(world, entity) / (float)tempRange;
            }
        });
    }
}

