/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.config;

import com.charles445.simpledifficulty.SimpleDifficulty;
import com.charles445.simpledifficulty.api.SDBlocks;
import com.charles445.simpledifficulty.api.SDItems;
import com.charles445.simpledifficulty.api.config.JsonConfig;
import com.charles445.simpledifficulty.api.config.json.JsonConsumableTemperature;
import com.charles445.simpledifficulty.api.config.json.JsonConsumableThirst;
import com.charles445.simpledifficulty.api.config.json.JsonItemIdentity;
import com.charles445.simpledifficulty.api.config.json.JsonPropertyTemperature;
import com.charles445.simpledifficulty.api.config.json.JsonPropertyValue;
import com.charles445.simpledifficulty.api.config.json.JsonTemperature;
import com.charles445.simpledifficulty.api.config.json.JsonTemperatureIdentity;
import com.charles445.simpledifficulty.api.config.json.migrate.JsonConsumableTemperatureMigrate;
import com.charles445.simpledifficulty.api.config.json.migrate.JsonConsumableThirstMigrate;
import com.charles445.simpledifficulty.api.config.json.migrate.JsonTemperatureMetadataMigrate;
import com.charles445.simpledifficulty.api.temperature.TemporaryModifierGroupEnum;
import com.charles445.simpledifficulty.compat.JsonCompatDefaults;
import com.charles445.simpledifficulty.config.JsonFileName;
import com.charles445.simpledifficulty.config.JsonTypeToken;
import com.charles445.simpledifficulty.config.json.ExtraItem;
import com.charles445.simpledifficulty.config.json.MaterialTemperature;
import com.charles445.simpledifficulty.item.ItemJuice;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import org.apache.commons.io.FileUtils;

public class JsonConfigInternal {
    public static MaterialTemperature materialTemperature = new MaterialTemperature();
    public static Map<String, ExtraItem> extraItems = new HashMap<String, ExtraItem>();
    public static List<String> jsonErrors = new ArrayList<String>();
    public static final JsonItemIdentity DEFAULT_ITEM_IDENTITY = new JsonItemIdentity(-1);

    public static void preInit(File jsonDirectory) {
        SimpleDifficulty.logger.info("Extra Items Initialization");
        JsonConfigInternal.makeExtraItem("frost_rod", "Frost Rod - For recipes");
        JsonConfigInternal.makeExtraItem("frost_powder", "Frost Powder - For recipes");
        JsonConfigInternal.makeExtraItem("dragon_canteen", "Dragon Canteen - Automatically purifies water").put("capacity", "8");
        extraItems = JsonConfigInternal.processJson(JsonFileName.extraItems, extraItems, jsonDirectory, false);
    }

    public static void postInit(File jsonDirectory) {
        JsonConfig.registerArmorTemperature(new ItemStack(SDItems.wool_helmet), 2.0f);
        JsonConfig.registerArmorTemperature(new ItemStack(SDItems.wool_chestplate), 2.0f);
        JsonConfig.registerArmorTemperature(new ItemStack(SDItems.wool_leggings), 2.0f);
        JsonConfig.registerArmorTemperature(new ItemStack(SDItems.wool_boots), 2.0f);
        JsonConfig.registerArmorTemperature(new ItemStack(SDItems.ice_helmet), -2.0f);
        JsonConfig.registerArmorTemperature(new ItemStack(SDItems.ice_chestplate), -2.0f);
        JsonConfig.registerArmorTemperature(new ItemStack(SDItems.ice_leggings), -2.0f);
        JsonConfig.registerArmorTemperature(new ItemStack(SDItems.ice_boots), -2.0f);
        JsonConfig.registerBlockTemperature(SDBlocks.campfire, 7.0f, new JsonPropertyValue("burning", "true"));
        JsonConfig.registerBlockTemperature(SDBlocks.campfire, 0.0f, new JsonPropertyValue("burning", "false"));
        JsonConfig.registerBlockTemperature(Blocks.field_150478_aa, 1.0f, new JsonPropertyValue[0]);
        JsonConfig.registerBlockTemperature(Blocks.field_150470_am, 4.0f, new JsonPropertyValue[0]);
        JsonConfig.registerBlockTemperature((Block)Blocks.field_150353_l, 12.5f, new JsonPropertyValue[0]);
        JsonConfig.registerBlockTemperature((Block)Blocks.field_150356_k, 12.5f, new JsonPropertyValue[0]);
        JsonConfig.registerBlockTemperature(Blocks.field_189877_df, 10.0f, new JsonPropertyValue[0]);
        JsonConfig.registerConsumableTemperature(TemporaryModifierGroupEnum.FOOD.group(), new ItemStack(Items.field_151009_A), 1.0f, 1200);
        JsonConfig.registerConsumableTemperature(TemporaryModifierGroupEnum.DRINK.group(), new ItemStack(SDItems.juice, 1, ItemJuice.JuiceEnum.CACTUS.ordinal()), 1.0f, 1200);
        JsonConfig.registerConsumableTemperature(TemporaryModifierGroupEnum.DRINK.group(), new ItemStack(SDItems.juice, 1, ItemJuice.JuiceEnum.CHORUS_FRUIT.ordinal()), 1.0f, 2400);
        JsonConfig.registerConsumableThirst(new ItemStack(Items.field_151117_aB), 4, 1.0f, 0.2f);
        JsonConfig.registerDimensionTemperature(0, 0.0f);
        JsonConfig.registerHeldItem(new ItemStack(Blocks.field_189877_df), 3.0f);
        JsonConfig.registerHeldItem(new ItemStack(Blocks.field_150478_aa), 1.0f);
        JsonCompatDefaults.instance.populate();
        JsonConfigInternal.processAllJson(jsonDirectory);
    }

    public static void clearContainers() {
        JsonConfig.armorTemperatures.clear();
        JsonConfig.blockTemperatures.clear();
        JsonConfig.consumableTemperature.clear();
        JsonConfig.consumableThirst.clear();
        JsonConfig.dimensionTemperature.clear();
        JsonConfig.fluidTemperatures.clear();
        JsonConfig.heldItemTemperatures.clear();
    }

    public static void processAllJson(File jsonDirectory) {
        Map<String, List<JsonTemperatureIdentity>> jsonArmorTemperatures;
        String jsonFileName;
        block76: {
            jsonFileName = JsonFileName.armorTemperatures.get();
            jsonArmorTemperatures = null;
            try {
                jsonArmorTemperatures = JsonConfigInternal.processUncaughtJson(JsonFileName.armorTemperatures, JsonConfig.armorTemperatures, jsonDirectory, true);
            }
            catch (Exception e) {
                boolean bl;
                HashMap hashMap = new HashMap();
                Map map = JsonConfigInternal.processJson(JsonFileName.armorTemperatures_MIGRATE, hashMap, jsonDirectory, true);
                if (map == null) break block76;
                boolean bl2 = false;
                for (JsonTemperature jsonTemperature : map.values()) {
                    if (jsonTemperature.temperature == 0.0f) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    SimpleDifficulty.logger.info("Attempting to migrate " + jsonFileName + " to new format");
                    try {
                        for (Map.Entry entry : map.entrySet()) {
                            JsonConfig.registerArmorTemperature((String)entry.getKey(), ((JsonTemperature)entry.getValue()).temperature, new JsonItemIdentity(-1));
                        }
                        try {
                            JsonConfigInternal.manuallyWriteToJson(JsonFileName.armorTemperatures, JsonConfig.armorTemperatures, jsonDirectory);
                            SimpleDifficulty.logger.info("Migrated " + jsonFileName);
                        }
                        catch (Exception exception) {
                            JsonConfigInternal.logMerge(jsonFileName, exception);
                        }
                    }
                    catch (Exception exception) {
                        SimpleDifficulty.logger.error("Migration failed, JSON of " + jsonFileName + " was likely already invalid");
                        JsonConfigInternal.logMerge(jsonFileName, exception);
                    }
                }
                jsonArmorTemperatures = JsonConfigInternal.processJson(JsonFileName.armorTemperatures, JsonConfig.armorTemperatures, jsonDirectory, true);
            }
        }
        if (jsonArmorTemperatures != null) {
            for (Map.Entry<String, List<JsonTemperatureIdentity>> entry : jsonArmorTemperatures.entrySet()) {
                for (JsonTemperatureIdentity jsonTemperatureIdentity : entry.getValue()) {
                    if (jsonTemperatureIdentity.identity != null) {
                        jsonTemperatureIdentity.identity.tryPopulateCompound();
                    }
                    JsonConfig.registerArmorTemperature(entry.getKey(), jsonTemperatureIdentity.temperature, jsonTemperatureIdentity.identity == null ? DEFAULT_ITEM_IDENTITY : jsonTemperatureIdentity.identity);
                }
            }
            try {
                JsonConfigInternal.manuallyWriteToJson(JsonFileName.armorTemperatures, JsonConfig.armorTemperatures, jsonDirectory);
            }
            catch (Exception e) {
                JsonConfigInternal.logMerge(jsonFileName, e);
            }
        }
        jsonFileName = JsonFileName.blockTemperatures.get();
        Map<String, List<JsonPropertyTemperature>> jsonBlockTemperatures = JsonConfigInternal.processJson(JsonFileName.blockTemperatures, JsonConfig.blockTemperatures, jsonDirectory, true);
        if (jsonBlockTemperatures != null) {
            for (Map.Entry<String, List<JsonPropertyTemperature>> entry : jsonBlockTemperatures.entrySet()) {
                for (JsonPropertyTemperature jsonPropertyTemperature : entry.getValue()) {
                    JsonConfig.registerBlockTemperature(entry.getKey(), jsonPropertyTemperature.temperature, jsonPropertyTemperature.getAsPropertyArray());
                }
            }
            try {
                JsonConfigInternal.manuallyWriteToJson(JsonFileName.blockTemperatures, JsonConfig.blockTemperatures, jsonDirectory);
            }
            catch (Exception exception) {
                JsonConfigInternal.logMerge(jsonFileName, exception);
            }
        }
        jsonFileName = JsonFileName.consumableTemperature.get();
        Map<String, List<JsonConsumableTemperature>> map = JsonConfigInternal.processJson(JsonFileName.consumableTemperature, JsonConfig.consumableTemperature, jsonDirectory, true);
        if (map != null) {
            boolean bl;
            boolean bl3 = true;
            block38: for (List<JsonConsumableTemperature> list : map.values()) {
                for (JsonConsumableTemperature jsonConsumableTemperature : list) {
                    if (jsonConsumableTemperature.identity == null) continue;
                    bl = false;
                    continue block38;
                }
            }
            if (bl) {
                SimpleDifficulty.logger.info("Attempting to migrate " + jsonFileName + " to new format");
                HashMap hashMap = new HashMap();
                try {
                    Map map2 = JsonConfigInternal.processUncaughtJson(JsonFileName.consumableTemperature_MIGRATE, hashMap, jsonDirectory, true);
                    for (Map.Entry entry : map2.entrySet()) {
                        for (JsonConsumableTemperatureMigrate jsonConsumableTemperatureMigrate : (List)entry.getValue()) {
                            JsonConfig.registerConsumableTemperature(jsonConsumableTemperatureMigrate.group, (String)entry.getKey(), jsonConsumableTemperatureMigrate.temperature, jsonConsumableTemperatureMigrate.duration, new JsonItemIdentity(jsonConsumableTemperatureMigrate.metadata));
                        }
                    }
                    try {
                        JsonConfigInternal.manuallyWriteToJson(JsonFileName.consumableTemperature, JsonConfig.consumableTemperature, jsonDirectory);
                        SimpleDifficulty.logger.info("Migrated " + jsonFileName);
                    }
                    catch (Exception exception) {
                        JsonConfigInternal.logMerge(jsonFileName, exception);
                    }
                }
                catch (Exception exception) {
                    SimpleDifficulty.logger.error("Migration failed, JSON of " + jsonFileName + " was likely already invalid");
                    JsonConfigInternal.logMerge(jsonFileName, exception);
                }
            } else {
                for (Map.Entry<String, List<JsonConsumableTemperature>> entry : map.entrySet()) {
                    for (JsonConsumableTemperature jsonConsumableTemperature : entry.getValue()) {
                        if (jsonConsumableTemperature.identity != null) {
                            jsonConsumableTemperature.identity.tryPopulateCompound();
                        }
                        JsonConfig.registerConsumableTemperature(jsonConsumableTemperature.group, entry.getKey(), jsonConsumableTemperature.temperature, jsonConsumableTemperature.duration, jsonConsumableTemperature.identity == null ? DEFAULT_ITEM_IDENTITY : jsonConsumableTemperature.identity);
                    }
                }
                try {
                    JsonConfigInternal.manuallyWriteToJson(JsonFileName.consumableTemperature, JsonConfig.consumableTemperature, jsonDirectory);
                }
                catch (Exception exception) {
                    JsonConfigInternal.logMerge(jsonFileName, exception);
                }
            }
        }
        jsonFileName = JsonFileName.consumableThirst.get();
        Map<String, List<JsonConsumableThirst>> map3 = JsonConfigInternal.processJson(JsonFileName.consumableThirst, JsonConfig.consumableThirst, jsonDirectory, true);
        if (map3 != null) {
            boolean bl;
            boolean bl4 = true;
            block44: for (List<JsonConsumableThirst> list : map3.values()) {
                for (JsonConsumableThirst jsonConsumableThirst : list) {
                    if (jsonConsumableThirst.identity == null) continue;
                    bl = false;
                    continue block44;
                }
            }
            if (bl) {
                SimpleDifficulty.logger.info("Attempting to migrate " + jsonFileName + " to new format");
                HashMap hashMap = new HashMap();
                try {
                    Map map4 = JsonConfigInternal.processUncaughtJson(JsonFileName.consumableThirst_MIGRATE, hashMap, jsonDirectory, true);
                    for (Map.Entry entry : map4.entrySet()) {
                        for (JsonConsumableThirstMigrate jsonConsumableThirstMigrate : (List)entry.getValue()) {
                            JsonConfig.registerConsumableThirst((String)entry.getKey(), jsonConsumableThirstMigrate.amount, jsonConsumableThirstMigrate.saturation, jsonConsumableThirstMigrate.thirstyChance, new JsonItemIdentity(jsonConsumableThirstMigrate.metadata));
                        }
                    }
                    try {
                        JsonConfigInternal.manuallyWriteToJson(JsonFileName.consumableThirst, JsonConfig.consumableThirst, jsonDirectory);
                        SimpleDifficulty.logger.info("Migrated " + jsonFileName);
                    }
                    catch (Exception exception) {
                        JsonConfigInternal.logMerge(jsonFileName, exception);
                    }
                }
                catch (Exception exception) {
                    SimpleDifficulty.logger.error("Migration failed, JSON of " + jsonFileName + " was likely already invalid");
                    JsonConfigInternal.logMerge(jsonFileName, exception);
                }
            } else {
                for (Map.Entry<String, List<JsonConsumableThirst>> entry : map3.entrySet()) {
                    for (JsonConsumableThirst jsonConsumableThirst : entry.getValue()) {
                        if (jsonConsumableThirst.identity != null) {
                            jsonConsumableThirst.identity.tryPopulateCompound();
                        }
                        JsonConfig.registerConsumableThirst(entry.getKey(), jsonConsumableThirst.amount, jsonConsumableThirst.saturation, jsonConsumableThirst.thirstyChance, jsonConsumableThirst.identity == null ? DEFAULT_ITEM_IDENTITY : jsonConsumableThirst.identity);
                    }
                }
                try {
                    JsonConfigInternal.manuallyWriteToJson(JsonFileName.consumableThirst, JsonConfig.consumableThirst, jsonDirectory);
                }
                catch (Exception exception) {
                    JsonConfigInternal.logMerge(jsonFileName, exception);
                }
            }
        }
        jsonFileName = JsonFileName.dimensionTemperature.get();
        Map<String, JsonTemperature> map5 = JsonConfigInternal.processJson(JsonFileName.dimensionTemperature, JsonConfig.dimensionTemperature, jsonDirectory, true);
        if (map5 != null) {
            for (Map.Entry<String, JsonTemperature> entry : map5.entrySet()) {
                JsonConfig.registerDimensionTemperature(entry.getKey(), entry.getValue().temperature);
            }
            try {
                JsonConfigInternal.manuallyWriteToJson(JsonFileName.dimensionTemperature, JsonConfig.dimensionTemperature, jsonDirectory);
            }
            catch (Exception exception) {
                JsonConfigInternal.logMerge(jsonFileName, exception);
            }
        }
        jsonFileName = JsonFileName.fluidTemperatures.get();
        Map<String, JsonTemperature> map6 = JsonConfigInternal.processJson(JsonFileName.fluidTemperatures, JsonConfig.fluidTemperatures, jsonDirectory, true);
        if (map6 != null) {
            for (Map.Entry<String, JsonTemperature> entry : map6.entrySet()) {
                JsonConfig.registerFluidTemperature(entry.getKey(), entry.getValue().temperature);
            }
            try {
                JsonConfigInternal.manuallyWriteToJson(JsonFileName.fluidTemperatures, JsonConfig.fluidTemperatures, jsonDirectory);
            }
            catch (Exception exception) {
                JsonConfigInternal.logMerge(jsonFileName, exception);
            }
        }
        jsonFileName = JsonFileName.heldItemTemperatures.get();
        Map<String, List<JsonTemperatureIdentity>> map7 = JsonConfigInternal.processJson(JsonFileName.heldItemTemperatures, JsonConfig.heldItemTemperatures, jsonDirectory, true);
        if (map7 != null) {
            boolean bl;
            boolean bl5 = true;
            block52: for (List<JsonTemperatureIdentity> list : map7.values()) {
                for (Object value : list) {
                    if (((JsonTemperatureIdentity)value).identity == null) continue;
                    bl = false;
                    continue block52;
                }
            }
            if (bl) {
                SimpleDifficulty.logger.info("Attempting to migrate " + jsonFileName + " to new format");
                HashMap hashMap = new HashMap();
                try {
                    Map map8 = JsonConfigInternal.processUncaughtJson(JsonFileName.heldItemTemperatures_MIGRATE, hashMap, jsonDirectory, true);
                    for (Map.Entry entry : map8.entrySet()) {
                        for (JsonTemperatureMetadataMigrate jctm : (List)entry.getValue()) {
                            JsonConfig.registerHeldItem((String)entry.getKey(), jctm.temperature, new JsonItemIdentity(jctm.metadata));
                        }
                    }
                    try {
                        JsonConfigInternal.manuallyWriteToJson(JsonFileName.heldItemTemperatures, JsonConfig.heldItemTemperatures, jsonDirectory);
                        SimpleDifficulty.logger.info("Migrated " + jsonFileName);
                    }
                    catch (Exception exception) {
                        JsonConfigInternal.logMerge(jsonFileName, exception);
                    }
                }
                catch (Exception exception) {
                    SimpleDifficulty.logger.error("Migration failed, JSON of " + jsonFileName + " was likely already invalid");
                    JsonConfigInternal.logMerge(jsonFileName, exception);
                }
            } else {
                for (Map.Entry<String, List<JsonTemperatureIdentity>> entry : map7.entrySet()) {
                    for (JsonTemperatureIdentity jtm : entry.getValue()) {
                        if (jtm.identity != null) {
                            jtm.identity.tryPopulateCompound();
                        }
                        JsonConfig.registerHeldItem(entry.getKey(), jtm.temperature, jtm.identity == null ? DEFAULT_ITEM_IDENTITY : jtm.identity);
                    }
                }
                try {
                    JsonConfigInternal.manuallyWriteToJson(JsonFileName.heldItemTemperatures, JsonConfig.heldItemTemperatures, jsonDirectory);
                }
                catch (Exception exception) {
                    JsonConfigInternal.logMerge(jsonFileName, exception);
                }
            }
        }
        materialTemperature = JsonConfigInternal.processJson(JsonFileName.materialTemperature, materialTemperature, jsonDirectory, false);
    }

    private static void logMerge(String jsonFileName, Exception e) {
        SimpleDifficulty.logger.error("Error writing merged JSON File: " + jsonFileName, (Throwable)e);
        jsonErrors.add("config/simpledifficulty/" + jsonFileName + " failed to load!");
    }

    public static String manuallyExportAll() {
        File jsonDirectory = SimpleDifficulty.jsonDirectory;
        try {
            JsonConfigInternal.manuallyWriteToJson(JsonFileName.armorTemperatures, JsonConfig.armorTemperatures, jsonDirectory);
            JsonConfigInternal.manuallyWriteToJson(JsonFileName.blockTemperatures, JsonConfig.blockTemperatures, jsonDirectory);
            JsonConfigInternal.manuallyWriteToJson(JsonFileName.consumableTemperature, JsonConfig.consumableTemperature, jsonDirectory);
            JsonConfigInternal.manuallyWriteToJson(JsonFileName.consumableThirst, JsonConfig.consumableThirst, jsonDirectory);
            JsonConfigInternal.manuallyWriteToJson(JsonFileName.dimensionTemperature, JsonConfig.dimensionTemperature, jsonDirectory);
            JsonConfigInternal.manuallyWriteToJson(JsonFileName.fluidTemperatures, JsonConfig.fluidTemperatures, jsonDirectory);
            JsonConfigInternal.manuallyWriteToJson(JsonFileName.heldItemTemperatures, JsonConfig.heldItemTemperatures, jsonDirectory);
            JsonConfigInternal.manuallyWriteToJson(JsonFileName.materialTemperature, materialTemperature, jsonDirectory);
            return "Successfully exported SimpleDifficulty configuration to JSON";
        }
        catch (Exception e) {
            SimpleDifficulty.logger.error("Export to JSON Failure Details", (Throwable)e);
            return "Export to JSON FAILED! See log for details.";
        }
    }

    @Nullable
    public static <T> T processJson(JsonFileName jfn, T container, File jsonDirectory, boolean forMerging) {
        try {
            return JsonConfigInternal.processUncaughtJson(jfn, container, jsonDirectory, forMerging);
        }
        catch (Exception e) {
            SimpleDifficulty.logger.error("Error managing JSON File: " + jfn.get(), (Throwable)e);
            jsonErrors.add("config/simpledifficulty/" + jfn.get() + " failed to load!");
            if (forMerging) {
                return null;
            }
            return container;
        }
    }

    @Nullable
    public static <T> T processUncaughtJson(JsonFileName jfn, T container, File jsonDirectory, boolean forMerging) throws Exception {
        String jsonFileName = jfn.get();
        Type type = JsonTypeToken.get(jfn);
        File jsonFile = new File(jsonDirectory, jsonFileName);
        if (jsonFile.exists()) {
            Gson gson = JsonConfigInternal.buildNewGson();
            return (T)gson.fromJson((Reader)new FileReader(jsonFile), type);
        }
        Gson gson = JsonConfigInternal.buildNewGson();
        FileUtils.write((File)jsonFile, (CharSequence)gson.toJson(container, type), (String)null);
        if (forMerging) {
            return null;
        }
        return container;
    }

    private static <T> void manuallyWriteToJson(JsonFileName jfn, T container, File jsonDirectory) throws Exception {
        String jsonFileName = jfn.get();
        Type type = JsonTypeToken.get(jfn);
        Gson gson = JsonConfigInternal.buildNewGson();
        File jsonFile = new File(jsonDirectory, jsonFileName);
        if (jsonFile.exists() && !jsonFile.canWrite()) {
            SimpleDifficulty.logger.warn(jfn.toString() + " is set to Read Only! Merged file will not be written.");
        } else {
            FileUtils.write((File)jsonFile, (CharSequence)gson.toJson(container, type), (String)null);
        }
    }

    private static Gson buildNewGson() {
        return new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{2}).create();
    }

    private static ExtraItem makeExtraItem(String itemName, String description) {
        ExtraItem extra = new ExtraItem(description, false);
        extraItems.put(itemName, extra);
        return extra;
    }
}

