/*
 * Decompiled with CFR 0.152.
 */
package com.charles445.simpledifficulty.compat.mod;

import com.charles445.simpledifficulty.SimpleDifficulty;
import com.charles445.simpledifficulty.api.SDCapabilities;
import com.charles445.simpledifficulty.api.SDDamageSources;
import com.charles445.simpledifficulty.api.SDFluids;
import com.charles445.simpledifficulty.api.item.IItemCanteen;
import com.charles445.simpledifficulty.api.thirst.ThirstEnum;
import com.charles445.simpledifficulty.api.thirst.ThirstUtil;
import com.charles445.simpledifficulty.compat.CompatRightClick;
import com.charles445.simpledifficulty.compat.HasShadows;
import com.charles445.simpledifficulty.compat.shadow.InspirationsShadow;
import com.charles445.simpledifficulty.config.ModConfig;
import com.charles445.simpledifficulty.util.ReflectUtil;
import com.charles445.simpledifficulty.util.SoundUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class InspirationsHandler {
    CompatRightClick.IRightClick fallbackCauldron = CompatRightClick.cauldronHandler;
    Class c_BlockEnhancedCauldron;
    Field f_BlockEnhancedCauldron_BOILING;
    PropertyBool o_BlockEnhancedCauldron_BOILING;
    Method m_BlockEnhancedCauldron_getCauldronLevel;
    Class c_TileCauldron;
    Method m_TileCauldron_getState;
    Method m_TileCauldron_setFluidLevel;
    Class c_CauldronState;
    Method m_CauldronState_getFluid;

    public InspirationsHandler() {
        try {
            this.c_BlockEnhancedCauldron = Class.forName("knightminer.inspirations.recipes.block.BlockEnhancedCauldron");
            this.f_BlockEnhancedCauldron_BOILING = ReflectUtil.findField(this.c_BlockEnhancedCauldron, "BOILING");
            this.o_BlockEnhancedCauldron_BOILING = (PropertyBool)this.f_BlockEnhancedCauldron_BOILING.get(null);
            this.m_BlockEnhancedCauldron_getCauldronLevel = ReflectUtil.findMethod(this.c_BlockEnhancedCauldron, "getCauldronLevel");
            this.c_TileCauldron = Class.forName("knightminer.inspirations.recipes.tileentity.TileCauldron");
            this.m_TileCauldron_getState = ReflectUtil.findMethod(this.c_TileCauldron, "getState");
            this.m_TileCauldron_setFluidLevel = ReflectUtil.findMethod(this.c_TileCauldron, "setFluidLevel");
            this.c_CauldronState = Class.forName("knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe$CauldronState");
            this.m_CauldronState_getFluid = ReflectUtil.findMethod(this.c_CauldronState, "getFluid");
            CompatRightClick.cauldronHandler = new InspirationsRightClickCauldron();
            try {
                CanteenRecipe.createCanteenRecipes();
            }
            catch (Exception e) {
                SimpleDifficulty.logger.error("Inspirations canteen recipes failed!...", (Throwable)e);
            }
        }
        catch (Exception e) {
            SimpleDifficulty.logger.error("InspirationsHandler setup failed! Inspirations compatibility is now disabled!", (Throwable)e);
            this.errorFallback();
        }
    }

    public void errorFallback() {
        CompatRightClick.cauldronHandler = this.fallbackCauldron;
    }

    public int getCauldronLevel(IBlockState state) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Integer)this.m_BlockEnhancedCauldron_getCauldronLevel.invoke(null, state);
    }

    public void setFluidLevel(TileEntity tileCauldron, int fluidLevel) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.m_TileCauldron_setFluidLevel.invoke((Object)tileCauldron, Math.max(0, fluidLevel));
    }

    @Nullable
    public Object getCauldronState(TileEntity tileCauldron) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return this.m_TileCauldron_getState.invoke((Object)tileCauldron, new Object[0]);
    }

    @Nullable
    public Fluid getCauldronStateFluid(Object cauldronState) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return (Fluid)this.m_CauldronState_getFluid.invoke(cauldronState, new Object[0]);
    }

    protected void damageFromBoilingDrink(EntityPlayer player) {
        if (!player.func_70045_F()) {
            player.func_70097_a(SDDamageSources.INSPIRATIONS_CAULDRON_BURN, 1.0f);
        }
    }

    @HasShadows
    public static class CanteenRecipe
    implements InspirationsShadow.ICauldronRecipe {
        public static void createCanteenRecipes() {
            CanteenRecipe recipe = new CanteenRecipe();
            try {
                Class<?> c_ICauldronRecipe = Class.forName("knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe");
                Class<?> c_InspirationsRegistry = Class.forName("knightminer.inspirations.library.InspirationsRegistry");
                Method m_InspirationsRegistry_addCauldronRecipe = ReflectUtil.findMethod(c_InspirationsRegistry, "addCauldronRecipe", c_ICauldronRecipe);
                m_InspirationsRegistry_addCauldronRecipe.invoke(null, recipe);
            }
            catch (Exception e) {
                SimpleDifficulty.logger.error("Inspirations compatibility failed while reflecting for cauldron recipes!", (Throwable)e);
            }
        }

        @Override
        public boolean matches(ItemStack stack, boolean boiling, int level, InspirationsShadow.ICauldronRecipe.CauldronState state) {
            if (!ModConfig.server.compatibility.toggles.inspirations) {
                return false;
            }
            if (level == 0) {
                return false;
            }
            if (stack.func_77973_b() instanceof IItemCanteen) {
                IItemCanteen canteen = (IItemCanteen)stack.func_77973_b();
                Fluid fluid = state.getFluid();
                if (fluid == null) {
                    return false;
                }
                if (fluid == FluidRegistry.WATER) {
                    if (boiling) {
                        return canteen.tryAddDose(stack, ThirstEnum.PURIFIED);
                    }
                    return canteen.tryAddDose(stack, ThirstEnum.NORMAL);
                }
            }
            return false;
        }

        @Override
        public int getLevel(int level) {
            return level - 1;
        }

        @Override
        public ItemStack getResult(ItemStack stack, boolean boiling, int level, InspirationsShadow.ICauldronRecipe.CauldronState state) {
            return ItemStack.field_190927_a;
        }

        @Override
        public ItemStack getContainer(ItemStack stack) {
            return ItemStack.field_190927_a;
        }

        @Override
        public SoundEvent getSound(ItemStack stack, boolean boiling, int level, InspirationsShadow.ICauldronRecipe.CauldronState state) {
            return SoundEvents.field_187630_M;
        }

        @Override
        public ItemStack transformInput(ItemStack stack, boolean boiling, int level, InspirationsShadow.ICauldronRecipe.CauldronState state) {
            return stack;
        }
    }

    public class InspirationsRightClickCauldron
    implements CompatRightClick.IRightClick {
        @Override
        public void process(PlayerInteractEvent.RightClickBlock event, World world, BlockPos pos, IBlockState state, EntityPlayer player) {
            if (!ModConfig.server.compatibility.toggles.inspirations || !InspirationsHandler.this.c_BlockEnhancedCauldron.isInstance(state.func_177230_c())) {
                InspirationsHandler.this.fallbackCauldron.process(event, world, pos, state, player);
                return;
            }
            ItemStack heldItem = player.func_184614_ca();
            if (heldItem.func_190926_b() && player.func_70093_af() && SDCapabilities.getThirstData(player).isThirsty()) {
                boolean boiling = (Boolean)state.func_177229_b((IProperty)InspirationsHandler.this.o_BlockEnhancedCauldron_BOILING);
                try {
                    int level = InspirationsHandler.this.getCauldronLevel(state);
                    if (level > 0) {
                        TileEntity te = world.func_175625_s(pos);
                        if (InspirationsHandler.this.c_TileCauldron.isInstance(te)) {
                            Fluid fluid;
                            Object cauldronState = InspirationsHandler.this.getCauldronState(te);
                            if (cauldronState != null && (fluid = InspirationsHandler.this.getCauldronStateFluid(cauldronState)) != null) {
                                if (fluid == FluidRegistry.WATER) {
                                    if (boiling) {
                                        ThirstUtil.takeDrink(player, ThirstEnum.PURIFIED);
                                        InspirationsHandler.this.damageFromBoilingDrink(player);
                                        InspirationsHandler.this.setFluidLevel(te, level - 1);
                                    } else {
                                        ThirstUtil.takeDrink(player, ThirstEnum.NORMAL);
                                    }
                                    SoundUtil.serverPlayBlockSound(world, pos, SoundEvents.field_187664_bz);
                                } else if (fluid == SDFluids.purifiedWater) {
                                    ThirstUtil.takeDrink(player, ThirstEnum.PURIFIED);
                                    if (boiling) {
                                        InspirationsHandler.this.damageFromBoilingDrink(player);
                                    }
                                    SoundUtil.serverPlayBlockSound(world, pos, SoundEvents.field_187664_bz);
                                    InspirationsHandler.this.setFluidLevel(te, 0);
                                }
                            }
                        } else {
                            if (boiling) {
                                ThirstUtil.takeDrink(player, ThirstEnum.PURIFIED);
                                InspirationsHandler.this.damageFromBoilingDrink(player);
                            } else {
                                ThirstUtil.takeDrink(player, ThirstEnum.NORMAL);
                            }
                            SoundUtil.serverPlayBlockSound(world, pos, SoundEvents.field_187664_bz);
                        }
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    SimpleDifficulty.logger.error("Inspirations compatibility failed while handling a cauldron!", (Throwable)e);
                    InspirationsHandler.this.errorFallback();
                    return;
                }
            }
        }
    }
}

